﻿
StiMobileDesigner.prototype.TextBoxWithEditButton = function (name, width, height, readOnly, showClearButton, showSimpleEditor, showCheckButton) {
    var jsObject = this;
    var control = this.CreateHTMLTable();
    control.isEnabled = true;
    control.style.borderCollapse = "separate";

    var textHeight = height || this.options.controlsHeight;
    var buttonWidth = this.options.controlsButtonsWidth;
    var buttonHeight = textHeight - 4;
    var baseCellClass = "stiDesignerTextBoxEditButton stiDesignerTextBoxEditButton";

    var buttonsCount = 1;
    if (showClearButton) buttonsCount++;
    if (showCheckButton) buttonsCount++;

    var textBoxWidth = width - ((buttonWidth + 1) * buttonsCount);
    var textBox = control.textBox = this.TextBox(name, textBoxWidth, textHeight);
    textBox.mainControl = control;
    textBox.style.borderRight = "0";
    control.addCell(textBox).style.fontSize = "0px";

    if (jsObject.allowRoundedControls()) {
        textBox.style.borderRadius = "3px 0 0 3px";
    }

    if (showCheckButton) {
        var checkButton = control.checkButton = this.StandartSmallButton(null, null, null, "Check.png", this.loc.Buttons.Check, null, true);
        checkButton.imageCell.style.padding = "0";
        checkButton.innerTable.style.width = "100%";
        checkButton.style.width = buttonWidth + "px";
        checkButton.style.height = buttonHeight + "px";
        checkButton.style.borderRadius = "0";

        var checkButtonCell = control.checkButtonCell = control.addCell(checkButton);
        checkButtonCell.className = baseCellClass + "Default";
        checkButtonCell.style.borderRadius = "0";
        checkButtonCell.style.borderRight = "0";
    }

    var button = control.button = this.StandartSmallButton(name + "Button", null, null, "SmallEdit.png", this.loc.QueryBuilder.Edit, null, true);
    button.imageCell.style.padding = "0";
    button.textBox = textBox;

    if (showSimpleEditor) {
        button.action = function () {
            jsObject.InitializeTextEditorFormOnlyText(function (form) {
                form.controlTextBox = textBox;

                form.showFunction = function () {
                    this.textArea.value = textBox.value;
                }

                form.actionFunction = function () {
                    textBox.value = this.textArea.value;
                    control.action();
                }

                form.changeVisibleState(true);
            });
        }
    }

    //Override
    button.innerTable.style.width = "100%";
    button.style.width = buttonWidth + "px";
    button.style.height = buttonHeight + "px";
    
    var buttonCell = control.buttonCell = control.addCell(button);
    buttonCell.className = baseCellClass + "Default";

    if (jsObject.allowRoundedControls()) {
        buttonCell.style.borderRadius = button.style.borderRadius = "0 3px 3px 0";
    }

    if (readOnly) {
        textBox.readOnly = readOnly;
        textBox.style.cursor = "default";
        textBox.onclick = function () { if (!jsObject.options.isTouchDevice) this.mainControl.button.onclick(); }
        textBox.ontouchend = function () { this.mainControl.button.ontouchend(); }
    }

    if (showClearButton) {
        var clearButton = control.clearButton = this.StandartSmallButton(name + "ClearButton", null, null, "RemoveSmall.png", this.loc.Gui.monthcalendar_clearbutton, null, true, { width: 16, height: 16 });
        clearButton.imageCell.style.padding = "0px";
        clearButton.innerTable.style.width = "100%";
        clearButton.style.width = buttonWidth + "px";
        clearButton.style.height = buttonHeight + "px";

        var clearButtonCell = control.clearButtonCell = control.addCell(clearButton);
        clearButtonCell.className = baseCellClass + "Default";

        if (jsObject.allowRoundedControls()) {
            clearButtonCell.style.borderRadius = clearButton.style.borderRadius = "0 3px 3px 0";
        }

        clearButton.action = function () {
            textBox.value = "";
            control.action();
        }

        button.style.borderRadius = buttonCell.style.borderRadius = "0";
        buttonCell.style.borderLeft = buttonCell.style.borderRight = "0";
    }

    control.onmouseover = function () {
        if (!jsObject.options.isTouchDevice) this.onmouseenter();
    }

    control.onmouseenter = function () {
        if (!this.isEnabled || jsObject.options.isTouchClick) return;
        this.isOver = true;
        textBox.onmouseenter();
        buttonCell.className = baseCellClass + "Over";
        if (control.clearButtonCell) control.clearButtonCell.className = baseCellClass + "Over";
        if (control.checkButtonCell) control.checkButtonCell.className = baseCellClass + "Over";
    }

    control.onmouseleave = function () {
        if (!this.isEnabled) return;
        this.isOver = false;
        textBox.onmouseleave();
        buttonCell.className = baseCellClass + "Default";
        if (control.clearButtonCell) control.clearButtonCell.className = baseCellClass + "Default";
        if (control.checkButtonCell) control.checkButtonCell.className = baseCellClass + "Default";
    }

    control.action = function () { };

    textBox.action = function () { control.action(); }

    control.setEnabled = function (state) {
        this.isEnabled = state;
        this.textBox.setEnabled(state);
        this.button.setEnabled(state);
        buttonCell.className = baseCellClass + (state ? "Default" : "Disabled");

        if (showClearButton) {
            this.clearButton.setEnabled(state);
            this.clearButtonCell.className = baseCellClass + (state ? "Default" : "Disabled");
        }

        if (showCheckButton) {
            this.checkButton.setEnabled(state);
            this.checkButtonCell.className = baseCellClass + (state ? "Default" : "Disabled");
        }
    }

    return control;
}