﻿
StiMobileDesigner.prototype.HeadersControl = function (name, width, dataColumns, countRows) {
    var jsObject = this;
    var control = this.TextBoxWithEditButton(name, width, null, true);

    control.button.action = function () {
        var form = jsObject.options.forms.headersEditor || jsObject.HeadersEditorForm(dataColumns, countRows);

        form.show(control.key);

        form.action = function (value) {
            this.changeVisibleState(false);
            var value = this.dataControl.getValue();

            if (value && value.length > 1) {
                var data = {};
                for (var i = 1; i < value.length; i++) {
                    data[value[i][0]] = value[i][1];
                }
                value = StiBase64.encode(JSON.stringify(data));
            }

            control.setKey(value);
            control.action();
        }
    }

    control.action = function () { }

    control.setKey = function (key) {
        this.key = key;
        this.textBox.value = key ? jsObject.loc.PropertyMain.Headers : jsObject.loc.Report.NotAssigned;
    }

    return control;
}

StiMobileDesigner.prototype.HeadersEditorForm = function (dataColumns, countRows) {
    var form = this.BaseForm("headersEditor", this.loc.FormViewer.Editor, 3);

    var dataControl = form.dataControl = this.InitializeManualDataControl(300, 250, dataColumns, countRows);
    dataControl.style.margin = "12px 12px 0 12px";
    form.container.appendChild(dataControl);

    form.show = function (value) {
        this.changeVisibleState(true);

        if (value) {
            var data = JSON.parse(StiBase64.decode(value));
            var dataArray = [["key", "value"]];
            for (var key in data) {
                dataArray.push([key, data[key]]);
            }
            value = JSON.stringify(dataArray);
        }

        dataControl.setValue(value);
    }

    return form;
}