﻿
StiMobileDesigner.prototype.InitializeEditWebContentElementForm_ = function () {
    var form = this.DashboardBaseForm("editWebContentElementForm", this.loc.Components.StiWebContent, 1, this.GetHelpLink("webContentElement"));
    form.isDockableToComponent = true;
    form.caption.style.padding = "0px 10px 0 12px";
    form.container.style.borderTop = "0px";
    form.hideButtonsPanel();
    var jsObject = this;

    var urlText = this.SimpleTextContainer("URL");
    urlText.style.padding = "4px 0 4px 12px";
    form.container.appendChild(urlText);

    var urlControl = this.ExpressionControl(null, 350, null, false, false, false, null, false, ["https://www.youtube.com/embed/F1dVM3al3dY", "{DataSource.Field}", "https://www.{VariableWithURL}.com"], null, 40);
    urlControl.style.margin = "0 12px 12px 12px";
    form.container.appendChild(urlControl);

    urlControl.action = function () {
        form.setPropertyValue("url", StiBase64.encode(this.textBox.value));
    }

    //separator or
    var separator = this.SeparatorOr();
    separator.style.margin = "16px 12px 6px 12px";
    form.container.appendChild(separator);

    var embedText = this.SimpleTextContainer(this.loc.Cloud.TabItemEmbedCode);
    embedText.style.padding = "4px 0 4px 12px";
    form.container.appendChild(embedText);

    var embedCodeControl = this.TextAreaWithEditButton(null, 350, 200, null, true, true);
    embedCodeControl.style.margin = "0 12px 12px 12px";
    form.container.appendChild(embedCodeControl);

    embedCodeControl.action = function () {
        form.setPropertyValue("embedCode", StiBase64.encode(this.textArea.value));
    }

    form.onshow = function () {
        urlControl.textBox.value = StiBase64.decode(form.currentWebContentElement.properties.url);
        embedCodeControl.textArea.value = StiBase64.decode(form.currentWebContentElement.properties.embedCode);
    }

    form.setPropertyValue = function (propertyName, propertyValue) {
        form.sendCommand(
            {
                command: "SetPropertyValue",
                propertyName: propertyName,
                propertyValue: propertyValue
            },
            function (answer) {
                if (answer.elementProperties) {
                    form.updateSvgContent(answer.elementProperties.svgContent);
                    form.updateElementProperties(answer.elementProperties);
                }
            }
        );
    }

    form.updateSvgContent = function (svgContent) {
        this.currentWebContentElement.properties.svgContent = svgContent;
        this.currentWebContentElement.repaint();
    }

    form.updateElementProperties = function (properties) {
        var jsObject = this.jsObject;
        for (var propertyName in properties) {
            this.currentWebContentElement.properties[propertyName] = properties[propertyName];
        }
        jsObject.options.homePanel.updateControls();
        if (jsObject.options.propertiesPanel) jsObject.options.propertiesPanel.updateControls();
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        form.jsObject.SendCommandToDesignerServer("UpdateWebContentElement",
            {
                componentName: form.currentWebContentElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    return form;
}
