/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.io;

import com.stimulsoft.lib.io.StiLineIterator;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.Closeable;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.Statement;
import java.util.logging.Logger;

public class StiCloseUtil {
    static Logger LOGGER = Logger.getLogger("com.stimulsoft.lib.io.StiCloseUtil");

    private StiCloseUtil() {
    }

    public static void close(Closeable ... closeableObjs) {
        for (Closeable stream : closeableObjs) {
            StiCloseUtil.close(stream);
        }
    }

    public static void close(Statement closeableObj1, Connection closeableObj2) {
        StiCloseUtil.close(closeableObj1);
        StiCloseUtil.close(closeableObj2);
    }

    public static void close(Closeable closeableObj) {
        try {
            if (closeableObj != null) {
                closeableObj.close();
            }
        }
        catch (Exception ioe) {
            StiValidationUtil.nothing();
        }
    }

    public static void close(Connection closeableObj) {
        try {
            if (closeableObj != null && !closeableObj.isClosed()) {
                closeableObj.close();
            }
        }
        catch (Exception e) {
            LOGGER.warning("Unable to close connection: " + closeableObj);
            e.printStackTrace();
            StiValidationUtil.nothing();
        }
    }

    public static void close(Statement closeableObj) {
        try {
            if (closeableObj != null) {
                closeableObj.close();
            }
        }
        catch (Exception e) {
            StiValidationUtil.nothing();
        }
    }

    public static void close(Socket closeableObj) {
        try {
            if (closeableObj != null) {
                closeableObj.close();
            }
        }
        catch (Exception e) {
            StiValidationUtil.nothing();
        }
    }

    public static void close(ServerSocket closeableObj) {
        try {
            if (closeableObj != null) {
                closeableObj.close();
            }
        }
        catch (Exception e) {
            StiValidationUtil.nothing();
        }
    }

    public static void close(StiLineIterator iterator) {
        if (iterator != null) {
            iterator.close();
        }
    }
}

