/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.base64;

import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StiBase64EncoderUtil {
    protected static final int FOUR_SEXTETS = 4;
    protected static final int INPUT_BUFFER_SIZE = 32768;
    protected static final int SEXTET_MASK = 63;
    protected static final int SHIFT_1_SEXTET = 6;
    protected static final int SHIFT_2_SEXTET = 12;
    protected static final int SHIFT_3_SEXTET = 18;
    protected static final byte PAD = 61;
    protected static final byte[] MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected static final int OCTET_3 = 3;
    protected static final int OCTET_1_MASK = 65535;
    protected static final int OCTET_2_MASK = 0xFF00FF;
    protected static final int OCTET_3_MASK = 0xFFFF00;
    protected static final int OCTET_MASK = 255;
    protected static final int SHIFT_1_OCTET = 8;
    protected static final int SHIFT_2_OCTET = 16;
    private static final int BUFFER_SIZE = 32768;
    protected int buffer;
    protected int octets;
    protected final OutputStream stream;
    protected byte[] outputBuffer = new byte[32768];
    protected int count;

    public StiBase64EncoderUtil(OutputStream stream) {
        this.stream = stream;
    }

    public static void encode(InputStream input, OutputStream out) throws IOException {
        int len;
        StiBase64EncoderUtil encoder = new StiBase64EncoderUtil(out);
        byte[] buf = new byte[32768];
        while ((len = input.read(buf, 0, buf.length)) != -1) {
            encoder.translate(buf, 0, len);
        }
        encoder.flush();
    }

    public static byte[] encode(byte[] data) {
        if (data == null) {
            return null;
        }
        return StiBase64EncoderUtil.encode(data, 0, data.length);
    }

    public static String encode(String data) {
        if (data == null) {
            return null;
        }
        return new String(StiBase64EncoderUtil.encode(data.getBytes()));
    }

    public static byte[] encode(byte[] data, int begin, int end) {
        byte[] result = new byte[]{};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            new StiBase64EncoderUtil(stream).translate(data, begin, end).flush();
            result = stream.toByteArray();
        }
        catch (IOException e) {
            StiValidationUtil.nothing();
        }
        return result;
    }

    protected StiBase64EncoderUtil translate(byte[] bytes) throws IOException {
        return this.translate(bytes, 0, bytes.length);
    }

    protected StiBase64EncoderUtil translate(byte[] bytes, int begin, int end) throws IOException {
        for (int i = begin; i < end; ++i) {
            byte b = bytes[i];
            this.buffer = this.octets == 0 ? this.buffer & 0xFFFF | (b & 0xFF) << 16 : (this.octets == 1 ? this.buffer & 0xFF00FF | (b & 0xFF) << 8 : this.buffer & 0xFFFF00 | b & 0xFF);
            if (++this.octets != 3) continue;
            this.encodeBuffer();
        }
        return this;
    }

    protected void encodeBuffer() throws IOException {
        if (this.count + 4 > this.outputBuffer.length) {
            this.writeBuffer();
        }
        this.outputBuffer[this.count++] = MAP[0x3F & this.buffer >> 18];
        this.outputBuffer[this.count++] = MAP[0x3F & this.buffer >> 12];
        this.outputBuffer[this.count++] = MAP[0x3F & this.buffer >> 6];
        this.outputBuffer[this.count++] = MAP[0x3F & this.buffer];
        this.buffer = 0;
        this.octets = 0;
    }

    protected void encodeBufferWithPadding() throws IOException {
        if (this.count + 4 > this.outputBuffer.length) {
            this.writeBuffer();
        }
        this.outputBuffer[this.count++] = MAP[0x3F & this.buffer >> 18];
        this.outputBuffer[this.count++] = MAP[0x3F & this.buffer >> 12];
        this.outputBuffer[this.count++] = this.octets <= 1 ? 61 : MAP[0x3F & this.buffer >> 6];
        this.outputBuffer[this.count++] = this.octets <= 2 ? 61 : MAP[0x3F & this.buffer];
        this.buffer = 0;
        this.octets = 0;
    }

    protected void writeBuffer() throws IOException {
        this.stream.write(this.outputBuffer, 0, this.count);
        this.count = 0;
    }

    public void flush() throws IOException {
        if (this.octets > 0) {
            this.encodeBufferWithPadding();
        }
        this.writeBuffer();
    }
}

