/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.base64;

import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StiBase64DecoderUtil {
    private static final int INPUT_BUFFER_SIZE = 16384;
    private static final int BUFFER_SIZE = 65536;
    private static final int THREE_OCTETS = 3;
    private static final int SEXTET_1_MASK = 262143;
    private static final int SEXTET_2_MASK = 0xFC0FFF;
    private static final int SEXTET_3_MASK = 0xFFF03F;
    private static final int SEXTET_4_MASK = 0xFFFFC0;
    private static final int SHIFT_1_SEXTET = 6;
    private static final int SHIFT_2_SEXTET = 12;
    private static final int SHIFT_3_SEXTET = 18;
    private static final int SEXTET_2 = 2;
    private static final int SEXTET_3 = 3;
    private static final int SEXTET_4 = 4;
    private static final int OCTET_MASK = 255;
    private static final int SHIFT_1_OCTET = 8;
    private static final int SHIFT_2_OCTET = 16;
    private static final byte SPC = 127;
    private static final byte PAD = 64;
    private static final byte[] MAP = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 64, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};
    private int buffer;
    private int sextets;
    private final OutputStream stream;
    private final byte[] outputBuffer = new byte[65536];
    private int count;

    public StiBase64DecoderUtil(OutputStream stream) {
        this.stream = stream;
    }

    public static void decode(InputStream input, OutputStream out) throws IOException {
        int len;
        StiBase64DecoderUtil decoder = new StiBase64DecoderUtil(out);
        byte[] buf = new byte[16384];
        while ((len = input.read(buf, 0, buf.length)) != -1) {
            decoder.translate(buf, 0, len);
        }
        decoder.flush();
    }

    public static void decode(InputStream input, OutputStream out, long count) throws IOException {
        if (count < 0L) {
            StiBase64DecoderUtil.decode(input, out);
        } else if (count > 0L) {
            int len;
            StiBase64DecoderUtil decoder = new StiBase64DecoderUtil(out);
            byte[] buf = new byte[16384];
            while (count > 0L && (len = input.read(buf, 0, count < (long)buf.length ? (int)count : buf.length)) != -1) {
                decoder.translate(buf, 0, len);
                count -= (long)len;
            }
            decoder.flush();
        }
    }

    public static byte[] decode(String str) {
        return StiBase64DecoderUtil.decode(str.getBytes());
    }

    public static byte[] decode(byte[] data) {
        return StiBase64DecoderUtil.decode(data, 0, data.length);
    }

    public static byte[] decode(byte[] data, int begin, int end) {
        byte[] result = new byte[]{};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            new StiBase64DecoderUtil(stream).translate(data, begin, end).flush();
            result = stream.toByteArray();
        }
        catch (IOException e) {
            StiValidationUtil.nothing();
        }
        return result;
    }

    public StiBase64DecoderUtil translate(byte[] bytes) throws IOException {
        return this.translate(bytes, 0, bytes.length);
    }

    public StiBase64DecoderUtil translate(byte[] bytes, int begin, int end) throws IOException {
        for (int i = begin; i < end; ++i) {
            byte data = MAP[bytes[i]];
            if (data == 127 || data == 64) continue;
            this.buffer = this.sextets == 0 ? this.buffer & 0x3FFFF | data << 18 : (this.sextets == 1 ? this.buffer & 0xFC0FFF | data << 12 : (this.sextets == 2 ? this.buffer & 0xFFF03F | data << 6 : this.buffer & 0xFFFFC0 | data));
            if (++this.sextets != 4) continue;
            if (this.count + 3 > this.outputBuffer.length) {
                this.stream.write(this.outputBuffer, 0, this.count);
                this.count = 0;
            }
            this.outputBuffer[this.count++] = (byte)(this.buffer >> 16 & 0xFF);
            this.outputBuffer[this.count++] = (byte)(this.buffer >> 8 & 0xFF);
            this.outputBuffer[this.count++] = (byte)(this.buffer & 0xFF);
            this.buffer = 0;
            this.sextets = 0;
        }
        return this;
    }

    private void decodeBufferWithPadding() throws IOException {
        int newcount = this.count;
        if (this.sextets >= 2) {
            ++newcount;
        }
        if (this.sextets >= 3) {
            ++newcount;
        }
        if (this.sextets >= 4) {
            ++newcount;
        }
        if (newcount > this.outputBuffer.length) {
            this.stream.write(this.outputBuffer, 0, this.count);
            this.count = 0;
        }
        if (this.sextets >= 2) {
            this.outputBuffer[this.count++] = (byte)(this.buffer >> 16 & 0xFF);
        }
        if (this.sextets >= 3) {
            this.outputBuffer[this.count++] = (byte)(this.buffer >> 8 & 0xFF);
        }
        if (this.sextets >= 4) {
            this.outputBuffer[this.count++] = (byte)(this.buffer & 0xFF);
        }
        this.buffer = 0;
        this.sextets = 0;
    }

    public void flush() throws IOException {
        if (this.sextets > 0) {
            this.decodeBufferWithPadding();
        }
        this.stream.write(this.outputBuffer, 0, this.count);
        this.count = 0;
    }
}

