/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StiFontHelper {
    static Logger LOG = Logger.getLogger(StiFontHelper.class.getName());
    static Map<Font, byte[]> customFonts = new HashMap<Font, byte[]>();
    static List<String> loadedFonts = new ArrayList<String>();
    static List<String> errorFonts = new ArrayList<String>();

    public static byte[] getFontData(Font font, Map<Font, byte[]> customFonts) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        byte[] cutomFont = StiFontHelper.findCustomFont(font, customFonts);
        if (cutomFont == null) {
            cutomFont = StiFontHelper.findCustomFont(font, StiFontHelper.getCustomFonts());
        }
        if (cutomFont != null) {
            byte[] result = new byte[cutomFont.length];
            System.arraycopy(cutomFont, 0, result, 0, result.length);
            return result;
        }
        try {
            File file = StiFontHelper.getFontFile(font);
            FileInputStream fin = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            fin.read(result);
            fin.close();
            return result;
        }
        catch (Exception e) {
            LOG.severe("Your system does not have access to font '" + font.getFontName() + "' file, please add True Type font file to report resources or use export without embedded fonts");
            throw e;
        }
    }

    private static byte[] findCustomFont(Font font, Map<Font, byte[]> customFonts) {
        for (Font customFont : customFonts.keySet()) {
            if (!font.getPSName().equals(customFont.getPSName())) continue;
            return customFonts.get(customFont);
        }
        for (Font customFont : customFonts.keySet()) {
            if (!font.getFontName().equals(customFont.getName())) continue;
            return customFonts.get(customFont);
        }
        for (Font customFont : customFonts.keySet()) {
            if (!font.getFontName().equals(customFont.getFontName())) continue;
            return customFonts.get(customFont);
        }
        for (Font customFont : customFonts.keySet()) {
            if (!font.getFamily().equals(customFont.getFamily())) continue;
            return customFonts.get(customFont);
        }
        return null;
    }

    public static File getFontFile(Font font) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        Object fontManager;
        Object f2d = null;
        Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
        try {
            Class<?> manager = Class.forName("sun.font.FontManagerFactory");
            Method managerInstance = manager.getDeclaredMethod("getInstance", new Class[0]);
            managerInstance.setAccessible(true);
            fontManager = managerInstance.invoke(null, new Object[0]);
            Method findFont2D = fontManager.getClass().getMethod("findFont2D", argTypes);
            findFont2D.setAccessible(true);
            Object font2D = findFont2D.invoke(fontManager, font.getFontName(), font.getStyle(), 2);
            Class<?> font2DClass = Class.forName("sun.font.Font2D");
            Class<?> gont2DHandleClass = Class.forName("sun.font.Font2DHandle");
            Object handle = font2DClass.getField("handle").get(font2D);
            f2d = gont2DHandleClass.getField("font2D").get(handle);
        }
        catch (Exception e) {
            try {
                Class<?> manager = Class.forName("sun.font.FontManager");
                fontManager = manager.newInstance();
                Object font2D = manager.getMethod("findFont2D", String.class, Integer.TYPE, Integer.TYPE).invoke(fontManager, font.getFontName(), font.getStyle(), 2);
                Class<?> font2DClass = Class.forName("sun.font.Font2D");
                Class<?> gont2DHandleClass = Class.forName("sun.font.Font2DHandle");
                Object handle = font2DClass.getField("handle").get(font2D);
                f2d = gont2DHandleClass.getField("font2D").get(handle);
            }
            catch (Exception manager) {
            }
            catch (IncompatibleClassChangeError i1) {
                try {
                    Class<?> manager = Class.forName("sun.font.FontManager");
                    Method findMethod = manager.getMethod("findFont2D", argTypes);
                    Object font2D = findMethod.invoke(null, font.getFontName(), font.getStyle(), 2);
                    Class<?> font2DClass = Class.forName("sun.font.Font2D");
                    Class<?> gont2DHandleClass = Class.forName("sun.font.Font2DHandle");
                    Object handle = font2DClass.getField("handle").get(font2D);
                    f2d = gont2DHandleClass.getField("font2D").get(handle);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        try {
            return new File(StiFontHelper.getPlatName(f2d));
        }
        catch (Exception e) {
            if (f2d.getClass().getName().equalsIgnoreCase("sun.font.CFont")) {
                String platName = StiFontHelper.getPlatName(f2d);
                return new File(platName);
            }
            Class<?> compositeFontClass = Class.forName("sun.font.CompositeFont");
            String platName = StiFontHelper.getPlatName(compositeFontClass.getMethod("getSlotFont", Integer.TYPE).invoke(f2d, (Integer)compositeFontClass.getMethod("getNumSlots", null).invoke(f2d, null) - 1));
            return new File(platName);
        }
    }

    private static String getPlatName(Object f2d) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        Field platName = Class.forName("sun.font.PhysicalFont").getDeclaredField("platName");
        platName.setAccessible(true);
        String fontPath = (String)platName.get(f2d);
        platName.setAccessible(false);
        return fontPath;
    }

    public static Map<Font, byte[]> getCustomFonts() {
        block6: {
            String customFontsPath = StiFontHelper.getCustomFontsPath();
            if (customFontsPath != null) {
                try {
                    File fontsFolder = new File(customFontsPath);
                    for (File fontFile : fontsFolder.listFiles()) {
                        String fontPath = fontFile.getAbsolutePath();
                        if (loadedFonts.contains(fontPath) || loadedFonts.contains(fontPath)) continue;
                        try {
                            Font font = Font.createFont(0, fontFile);
                            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                            customFonts.put(font, StiIOUtil.toByteArray((InputStream)new FileInputStream(fontFile)));
                            loadedFonts.add(fontPath);
                        }
                        catch (Exception e2) {
                            errorFonts.add(fontPath);
                            if (StiLoggingUtil.getLogLevel() < 10) continue;
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    if (StiLoggingUtil.getLogLevel() < 10) break block6;
                    e.printStackTrace();
                }
            }
        }
        return customFonts;
    }

    public static String getCustomFontsPath() {
        try {
            Object engineObj = Class.forName("com.stimulsoft.report.StiOptions").getField("Configuration").get(null);
            return (String)Class.forName("com.stimulsoft.report.options.ConfigurationOptions").getField("customFontsPath").get(engineObj);
        }
        catch (Exception e) {
            try {
                return (String)Class.forName("com.stimulsoft.report.options.ConfigurationOptions").getField("customFontsPath").get(Class.forName("com.stimulsoft.report.options.ConfigurationOptions"));
            }
            catch (Exception e2) {
                return null;
            }
        }
    }
}

