/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system.type;

import com.stimulsoft.base.system.StiDateOnly;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeOnly;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.ParameterType;
import com.stimulsoft.base.system.type.StiSystemBoolean;
import com.stimulsoft.base.system.type.StiSystemByte;
import com.stimulsoft.base.system.type.StiSystemByteArray;
import com.stimulsoft.base.system.type.StiSystemChar;
import com.stimulsoft.base.system.type.StiSystemDateOnly;
import com.stimulsoft.base.system.type.StiSystemDateTime;
import com.stimulsoft.base.system.type.StiSystemDecimal;
import com.stimulsoft.base.system.type.StiSystemDouble;
import com.stimulsoft.base.system.type.StiSystemDrawingBitmap;
import com.stimulsoft.base.system.type.StiSystemDrawingImage;
import com.stimulsoft.base.system.type.StiSystemGuid;
import com.stimulsoft.base.system.type.StiSystemInt16;
import com.stimulsoft.base.system.type.StiSystemInt32;
import com.stimulsoft.base.system.type.StiSystemInt64;
import com.stimulsoft.base.system.type.StiSystemObject;
import com.stimulsoft.base.system.type.StiSystemSingle;
import com.stimulsoft.base.system.type.StiSystemString;
import com.stimulsoft.base.system.type.StiSystemTimeOnly;
import com.stimulsoft.base.system.type.StiSystemTimeSpan;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiTypeList;
import com.stimulsoft.base.system.type.StiTypeNullable;
import com.stimulsoft.base.system.type.StiTypeRange;
import com.stimulsoft.base.system.type.StiTypeValue;
import java.math.BigDecimal;
import java.util.HashMap;

public enum StiSystemTypeEnum {
    SystemString("System.String", StiSystemString.class, ParameterType.VALUE),
    SystemSingle("System.Single", StiSystemSingle.class, ParameterType.VALUE),
    SystemDouble("System.Double", StiSystemDouble.class, ParameterType.VALUE),
    SystemDecimal("System.Decimal", StiSystemDecimal.class, ParameterType.VALUE),
    SystemDateTime("System.DateTime", StiSystemDateTime.class, ParameterType.VALUE),
    SystemTimeSpan("System.TimeSpan", StiSystemTimeSpan.class, ParameterType.VALUE),
    SystemSByte("System.SByte", StiSystemByte.class, ParameterType.VALUE),
    SystemByte("System.Byte", StiSystemByte.class, ParameterType.VALUE),
    SystemInt16("System.Int16", StiSystemInt16.class, ParameterType.VALUE),
    SystemUInt16("System.UInt16", StiSystemInt16.class, ParameterType.VALUE),
    SystemInt32("System.Int32", StiSystemInt32.class, ParameterType.VALUE),
    SystemUInt32("System.UInt32", StiSystemInt32.class, ParameterType.VALUE),
    SystemInt64("System.Int64", StiSystemInt64.class, ParameterType.VALUE),
    SystemUInt64("System.UInt64", StiSystemInt64.class, ParameterType.VALUE),
    SystemBoolean("System.Boolean", StiSystemBoolean.class, ParameterType.VALUE),
    SystemChar("System.Char", StiSystemChar.class, ParameterType.VALUE),
    SystemGuid("System.Guid", StiSystemGuid.class, ParameterType.VALUE),
    SystemObject("System.Object", StiSystemObject.class, ParameterType.VALUE),
    SystemDrawingImage("System.Drawing.Image", StiSystemDrawingImage.class, ParameterType.VALUE),
    SystemByteArray("System.Byte[]", StiSystemByteArray.class, ParameterType.VALUE),
    SystemDrawingBitmap("System.Drawing.Bitmap", StiSystemDrawingBitmap.class, ParameterType.VALUE),
    SystemFloat("System.Float", StiSystemSingle.class, ParameterType.VALUE),
    RefCursor("RefCursor", StiSystemObject.class, ParameterType.VALUE),
    SystemTimeOnly("System.TimeOnly", StiSystemTimeOnly.class, ParameterType.VALUE),
    SystemDateOnly("System.DateOnly", StiSystemDateOnly.class, ParameterType.VALUE);

    private static HashMap<String, StiSystemType> mappingsType;
    private StiSystemType systemType;

    static synchronized HashMap<String, StiSystemType> getMappingsType() {
        if (mappingsType == null) {
            mappingsType = new HashMap();
        }
        return mappingsType;
    }

    private StiSystemTypeEnum(String systemTypeName, Class<? extends StiTypeValue> systemClass, ParameterType type) {
        switch (type) {
            case VALUE: {
                this.systemType = this.newInstance(systemClass);
                break;
            }
            case NULLABLE: {
                this.systemType = new StiTypeNullable(this.newInstance(systemClass));
                break;
            }
            case LIST: {
                this.systemType = new StiTypeList(this.newInstance(systemClass));
                break;
            }
            case RANGE: {
                this.systemType = new StiTypeRange(this.newInstance(systemClass));
                break;
            }
        }
        this.systemType.setSerializeValue(systemTypeName);
        StiSystemTypeEnum.getMappingsType().put(systemTypeName, this.systemType);
    }

    public Object getValueByString(String str) {
        return this.systemType.getInstanceValueByString(str);
    }

    private StiTypeValue newInstance(Class<? extends StiTypeValue> systemClass) {
        try {
            return systemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exist(String systemTypeName) {
        return StiSystemTypeEnum.getMappingsType().containsKey(systemTypeName);
    }

    public StiSystemType getSystemType() {
        return this.systemType;
    }

    public static StiSystemType getSystemType(Object obj) {
        if (obj instanceof Integer) {
            return StiSystemTypeEnum.SystemInt32.systemType;
        }
        if (obj instanceof Long) {
            return StiSystemTypeEnum.SystemInt64.systemType;
        }
        if (obj instanceof Byte) {
            return StiSystemTypeEnum.SystemByte.systemType;
        }
        if (obj instanceof Short) {
            return StiSystemTypeEnum.SystemInt16.systemType;
        }
        if (obj instanceof Float) {
            return StiSystemTypeEnum.SystemFloat.systemType;
        }
        if (obj instanceof Double) {
            return StiSystemTypeEnum.SystemDouble.systemType;
        }
        if (obj instanceof BigDecimal) {
            return StiSystemTypeEnum.SystemDecimal.systemType;
        }
        if (obj instanceof StiDateTime) {
            return StiSystemTypeEnum.SystemDateTime.systemType;
        }
        if (obj instanceof StiDateOnly) {
            return StiSystemTypeEnum.SystemDateOnly.systemType;
        }
        if (obj instanceof Character) {
            return StiSystemTypeEnum.SystemChar.systemType;
        }
        if (obj instanceof StiGuid) {
            return StiSystemTypeEnum.SystemGuid.systemType;
        }
        if (obj instanceof StiTimeSpan) {
            return StiSystemTypeEnum.SystemTimeSpan.systemType;
        }
        if (obj instanceof StiTimeOnly) {
            return StiSystemTypeEnum.SystemTimeOnly.systemType;
        }
        if (obj instanceof Boolean) {
            return StiSystemTypeEnum.SystemBoolean.systemType;
        }
        return StiSystemTypeEnum.SystemString.systemType;
    }
}

