/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.system.StiConverterDateFormatToJava;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.lib.utils.StiCalendarUtil;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class StiDateTime
implements Cloneable,
Comparable<Object> {
    public static final String EN_DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    public static final String DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private static final String[] DATE_FORMATS = new String[]{"yyyy0MM0dd", "dd0MM0yyyy", "MM0dd0yyyy", "MM0yyyy", "yyyy0MM", "yyyy0dd0MM", "dd0MM0yy", "yy0MM0dd", "MM0dd0yy", "MM0yy", "yy0MM", "yy0dd0MM"};
    private static final String[] TIME_FORMATS = new String[]{"HH:mm:ss.SSSSSSSSS", "HH:mm:ss", "HH:mm", "HH", ""};
    private static final String[] OFFSETS = new String[]{"", "XXX", " XXX", "Z"};
    private static final String[] COMMON_FORMATS = new String[]{"MM/dd/yyyy", "yyyy-MM-dd'T'HH:mm:ss.SS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'"};
    private static final Character[] DELIMITERS = new Character[]{Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf(':')};
    private static final long[] DaysToMonth365 = new long[]{0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};
    private static final long[] DaysToMonth366 = new long[]{0L, 31L, 60L, 91L, 121L, 152L, 182L, 213L, 244L, 274L, 305L, 335L, 366L};
    public static StiDateTime ZERO = new StiDateTime();
    public static StiDateTime minValue = new StiDateTime();
    public static StiDateTime MinValue = new StiDateTime();
    public static StiDateTime MaxValue = new StiDateTime(new Date(Long.MAX_VALUE));
    private ZonedDateTime zonedDateTime;

    public StiDateTime() {
        this.zonedDateTime = ZonedDateTime.of(LocalDateTime.of(0, 1, 1, 0, 0, 0, 0), ZoneId.systemDefault());
    }

    public StiDateTime(Calendar calendar) {
        this.zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public StiDateTime(ZonedDateTime date) {
        this.zonedDateTime = date;
    }

    public StiDateTime(int year, int month, int day) {
        this.zonedDateTime = ZonedDateTime.of(LocalDateTime.of(year, month, day, 0, 0, 0, 0), ZoneId.systemDefault());
    }

    public StiDateTime(int year, int month, int day, int hour, int min, int sec) {
        this.zonedDateTime = ZonedDateTime.of(LocalDateTime.of(year, month, day, hour, min, sec, 0), ZoneId.systemDefault());
    }

    public StiDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault());
    }

    public StiDateTime(StiTimeSpan value) {
        this.setTimeSpan(value);
    }

    public StiDateTime(StiDateTime value) {
        this.zonedDateTime = value.zonedDateTime.plusHours(0L);
    }

    public StiDateTime date() {
        return this;
    }

    public static StiDateTime currentDate() {
        return new StiDateTime(ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault()));
    }

    public static StiDateTime now() {
        return new StiDateTime(ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault()));
    }

    public static StiDateTime today() {
        return StiDateTime.now();
    }

    public static StiDateTime currentDateOnly() {
        ZonedDateTime today = ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault());
        LocalTime time = LocalTime.of(0, 0);
        return new StiDateTime(today.with(time));
    }

    public String toNetJsonString() {
        return "\\/Date(" + this.zonedDateTime.toInstant().toEpochMilli() + ")\\/";
    }

    public static StiDateTime fromNetJsonString(String jsonDate) {
        long mills = Long.parseLong(jsonDate.replaceAll("\\D+", ""));
        Instant instant = Instant.ofEpochMilli(mills);
        return new StiDateTime(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault()));
    }

    public ZonedDateTime zonedDateTime() {
        return this.zonedDateTime;
    }

    public long getTicks() {
        return this.zonedDateTime.toInstant().toEpochMilli();
    }

    public static StiDateTime Parse(String from) {
        return StiDateTime.fromString(from);
    }

    public static StiDateTime fromString(String strFrom) {
        try {
            Exception ex = null;
            for (String format : COMMON_FORMATS) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.ENGLISH);
                    Date date = sdf.parse(strFrom);
                    return new StiDateTime(date);
                }
                catch (Exception ee) {
                    ex = ee;
                }
            }
            throw ex;
        }
        catch (Exception e) {
            try {
                Date date = StiDateTime.parseISO8601(strFrom);
                return new StiDateTime(date);
            }
            catch (Exception exception) {
                if (strFrom.contains("Date")) {
                    try {
                        return StiJsonReportObjectHelper.Deserialize.DateTime(strFrom);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                for (String timeFormat : TIME_FORMATS) {
                    for (Character delimiter : DELIMITERS) {
                        for (String dateFormat : DATE_FORMATS) {
                            for (String offset : OFFSETS) {
                                try {
                                    String fmt = dateFormat.replace('0', delimiter.charValue()) + (strFrom.indexOf("T") >= 0 ? "'T'" : "") + (timeFormat.length() > 0 && strFrom.indexOf("T") < 0 ? " " : "") + timeFormat + offset;
                                    if (fmt.length() != strFrom.length() && strFrom.indexOf("T") < 0) continue;
                                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(fmt).withZone(ZoneId.systemDefault());
                                    if (timeFormat.length() != 0) {
                                        ZonedDateTime parsed = ZonedDateTime.parse(strFrom, formatter);
                                        return new StiDateTime(parsed);
                                    }
                                    LocalDate parsed = LocalDate.parse(strFrom, formatter);
                                    return new StiDateTime(parsed.atStartOfDay(ZoneId.systemDefault()));
                                }
                                catch (Exception exception3) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                for (Locale locale : Locale.getAvailableLocales()) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", locale);
                        Date date = sdf.parse(strFrom);
                        return new StiDateTime(date);
                    }
                    catch (Exception exception4) {
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }

    public static Date parseISO8601(String input) throws ParseException {
        String input2;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        if (input.endsWith("Z")) {
            input2 = input.substring(0, input.length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - inset);
            String s1 = input.substring(input.length() - inset, input.length());
            input2 = s0 + "GMT" + s1;
        }
        try {
            return df.parse(input2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.toString("MM/dd/yyyy hh:mm:ss a");
    }

    public String toString(String format) {
        return this.toString(format, null);
    }

    public String toString(String format, Locale locale) {
        return this.format(format, locale);
    }

    public String format(String format) {
        return this.format(format, null);
    }

    public String format(String format, Locale locale) {
        if (StiValidationUtil.isNotEmpty((String)format) || locale != null) {
            DateTimeFormatter df = StiConverterDateFormatToJava.getDateTimeFormat(format, locale);
            return this.format(df);
        }
        return this.toString();
    }

    public String format(DateTimeFormatter df) {
        String result = df.format(this.zonedDateTime);
        if (result != null) {
            result = result.replaceAll("\\\\", "");
        }
        return result;
    }

    public String formatEN() {
        return StiDateUtil.format((ZonedDateTime)this.zonedDateTime, (String)StiDateUtil.DEFAULT_DATE_PATTERN_EN);
    }

    public String formatEnDateTime() {
        return StiDateUtil.format((ZonedDateTime)this.zonedDateTime, (String)"MM/dd/yyyy hh:mm:ss a");
    }

    public void setTimeSpan(StiTimeSpan value) {
        this.zonedDateTime = ZonedDateTime.now();
        LocalTime time = LocalTime.of(value.getHours(), value.getMinutes(), value.getSeconds());
        this.zonedDateTime = this.zonedDateTime.with(time);
    }

    public int getDayOfWeek() {
        int result = this.zonedDateTime.getDayOfWeek().getValue();
        return result == 7 ? 1 : result + 1;
    }

    public StiDateTime addDays(long days) {
        return new StiDateTime(this.zonedDateTime.plusDays(days));
    }

    public StiDateTime addHours(long hours) {
        return new StiDateTime(this.zonedDateTime.plusHours(hours));
    }

    public StiDateTime addMilliseconds(long milliseconds) {
        return new StiDateTime(this.zonedDateTime.plus(milliseconds, ChronoUnit.MILLIS));
    }

    public StiDateTime addMinutes(long minutes) {
        return new StiDateTime(this.zonedDateTime.plusMinutes(minutes));
    }

    public StiDateTime addMonths(int months) {
        return new StiDateTime(this.zonedDateTime.plusMonths(months));
    }

    public StiDateTime addSeconds(long seconds) {
        return new StiDateTime(this.zonedDateTime.plusSeconds(seconds));
    }

    public StiDateTime addYears(int years) {
        return new StiDateTime(this.zonedDateTime.plusYears(years));
    }

    public static int daysInMonth(long year, long month) {
        if (month < 1L || month > 12L) {
            throw new IndexOutOfBoundsException("month ArgumentOutOfRange_Month: " + month);
        }
        long[] days = StiDateTime.isLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
        return (int)days[(int)month] - (int)days[(int)month - 1];
    }

    public static boolean isLeapYear(long year) {
        if (year < 1L || year > 9999L) {
            throw new IndexOutOfBoundsException("year ArgumentOutOfRange_Year: " + year);
        }
        return year % 4L == 0L && (year % 100L != 0L || year % 400L == 0L);
    }

    public StiDateTime clone() {
        return new StiDateTime(this.zonedDateTime.plusSeconds(0L));
    }

    public String format() {
        return StiTypeConverter.dateTimeToString((ZonedDateTime)this.zonedDateTime);
    }

    public StiTimeSpan subtract(StiDateTime subtrahend) {
        return new StiTimeSpan(StiCalendarUtil.subtract((ZonedDateTime)this.zonedDateTime, (ZonedDateTime)subtrahend.zonedDateTime) * 1000L);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof Calendar) {
            Calendar calendar = (Calendar)o;
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
            return this.zonedDateTime.compareTo(dateTime);
        }
        if (o instanceof ZonedDateTime) {
            return this.zonedDateTime.compareTo((ZonedDateTime)o);
        }
        if (o instanceof StiDateTime) {
            return this.zonedDateTime.compareTo(((StiDateTime)o).zonedDateTime);
        }
        if (o instanceof String) {
            return this.zonedDateTime.compareTo(this.tryParse((String)((String)o)).zonedDateTime);
        }
        throw new IllegalArgumentException("Illegal class " + o.getClass());
    }

    private StiDateTime tryParse(String value) {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("MM/dd/yyyy hh:mm:ss a");
        formats.add(StiDateUtil.DEFAULT_DATE_TIME_PATTERN);
        formats.add(StiDateUtil.DEFAULT_DATE_PATTERN);
        formats.add(StiDateUtil.DEFAULT_DATE_PATTERN_EN);
        formats.add(TIME_FORMAT);
        formats.add(TIME_FORMAT);
        for (String format : formats) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                Date date = sdf.parse(value);
                return new StiDateTime(date);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Illegal datetime format " + value);
    }

    public static StiDateTime valueOf(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object is null ");
        }
        if (o instanceof StiDateTime) {
            return (StiDateTime)o;
        }
        if (o instanceof ZonedDateTime) {
            return new StiDateTime((ZonedDateTime)o);
        }
        if (o instanceof Calendar) {
            return new StiDateTime((Calendar)o);
        }
        if (o instanceof Date) {
            return new StiDateTime((Date)o);
        }
        throw new IllegalArgumentException("Illegal class " + o.getClass());
    }

    public double toOADate() {
        LocalDateTime baseDate = LocalDateTime.of(1899, 12, 30, 0, 0, 0);
        long millisecondsDiff = ChronoUnit.MILLIS.between(baseDate, this.zonedDateTime.toLocalDateTime());
        double daysDiff = (double)millisecondsDiff / 8.64E7;
        return daysDiff;
    }

    public Calendar toCalendar() {
        Date date = Date.from(this.zonedDateTime.toInstant());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof StiDateTime && ((StiDateTime)obj).zonedDateTime.equals(this.zonedDateTime);
    }

    public int year() {
        return this.zonedDateTime.getYear();
    }

    public int month() {
        return this.zonedDateTime.getMonthValue();
    }

    public int day() {
        return this.zonedDateTime.getDayOfMonth();
    }

    public int hour() {
        return this.zonedDateTime.getHour();
    }

    public int minute() {
        return this.zonedDateTime.getMinute();
    }

    public int second() {
        return this.zonedDateTime.getSecond();
    }
}

