/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.base.system.StiConverterDateFormatToJava;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class StiDateOnly
implements Cloneable,
Comparable<Object> {
    public static final String DATE_FORMAT = "M/d/yyyy";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("M/d/yyyy");
    private LocalDate date = LocalDate.now();

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonthValue();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public LocalDate getDate() {
        return this.date;
    }

    public String toString() {
        return this.date.format(FORMATTER);
    }

    public String format(String format, Locale locale) {
        if (StiValidationUtil.isNotEmpty((String)format) || locale != null) {
            DateTimeFormatter df = StiConverterDateFormatToJava.getDateFormat(format, locale);
            return this.format(df);
        }
        return this.toString();
    }

    public String format(DateTimeFormatter df) {
        String result = df.format(this.date);
        if (result != null) {
            result = result.replaceAll("\\\\", "");
        }
        return result;
    }

    public static StiDateOnly valueOf(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof StiDateOnly) {
            return (StiDateOnly)o;
        }
        if (o instanceof String) {
            return new StiDateOnly((String)o);
        }
        if (o instanceof LocalDate) {
            return new StiDateOnly((LocalDate)o);
        }
        if (o instanceof StiDateTime) {
            return new StiDateOnly(((StiDateTime)o).zonedDateTime().toLocalDate());
        }
        if (o instanceof ZonedDateTime) {
            return new StiDateOnly(((ZonedDateTime)o).toLocalDate());
        }
        if (o instanceof Calendar) {
            return new StiDateOnly((Calendar)o);
        }
        if (o instanceof Date) {
            return new StiDateOnly((Date)o);
        }
        throw new IllegalArgumentException("Illegal class " + o.getClass());
    }

    public StiDateOnly() {
    }

    public StiDateOnly(LocalDate date) {
        this.date = date;
    }

    public StiDateOnly(String value) {
        this.date = LocalDate.parse(value, FORMATTER);
    }

    public StiDateOnly(Calendar calendar) {
        this.date = LocalDate.from(calendar.toInstant());
    }

    public StiDateOnly(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.date = LocalDate.from(calendar.toInstant());
    }

    @Override
    public int compareTo(Object o) {
        return this.date.compareTo(o != null ? StiDateOnly.valueOf((Object)o).date : null);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof StiDateOnly && ((StiDateOnly)obj).date.equals(this.date);
    }

    public StiDateTime toDateTime() {
        return new StiDateTime(this.date.atStartOfDay(ZoneOffset.UTC));
    }
}

