/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.StiDocumentItemAttribut;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiClassConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class StiDocumentItemAttributes {
    private static final String SERVICE_REF = "Ref";
    private static final String SERVICE_TYPE = "type";
    private static final String SERVICE_ISSER = "isSer";
    private static final String[] SERVICE_ATTRIBUTES = new String[]{"Ref", "type", "isSer"};
    private static final Comparator<StiDocumentItemAttribut> BY_NAME = new Comparator<StiDocumentItemAttribut>(){

        @Override
        public int compare(StiDocumentItemAttribut value1, StiDocumentItemAttribut value2) {
            return value1.attributName.compareTo(value2.attributName);
        }
    };
    private final ArrayList<StiDocumentItemAttribut> attributes = new ArrayList();

    StiDocumentItemAttributes() {
    }

    public StiDocumentItemAttributes(IStiSerializableRef object) {
        StiDocumentItemAttribut ref = new StiDocumentItemAttribut(SERVICE_REF, object.getReference());
        this.putAttribute(ref);
        StiDocumentItemAttribut type = new StiDocumentItemAttribut(SERVICE_TYPE, StiClassConverter.getNetClass(object.getClass()));
        this.putAttribute(type);
        StiDocumentItemAttribut isSer = new StiDocumentItemAttribut(SERVICE_ISSER, "true");
        this.putAttribute(isSer);
    }

    private void putAttribute(StiDocumentItemAttribut attribut) {
        this.attributes.add(attribut);
    }

    public void addNotDefault(StiDocumentItemAttribut attribut) {
        if (StiValidationUtil.isNotEmpty((String)attribut.attributName)) {
            this.putAttribute(attribut);
        }
    }

    public ArrayList<StiDocumentItemAttribut> getAttributes() {
        return this.attributes;
    }

    public void addNotEmpty(String attributName, String attributValue) {
        if (StiValidationUtil.isNotNullOrEmpty((String)attributValue)) {
            StiDocumentItemAttribut attribut = new StiDocumentItemAttribut(attributName, attributValue);
            this.putAttribute(attribut);
        }
    }

    public String get(String attributName) {
        StiDocumentItemAttribut attribut = this.getAttribut(attributName);
        return attribut != null ? attribut.attributValue : null;
    }

    public boolean getBoolean(String attributName, boolean defaultValue) {
        StiDocumentItemAttribut attribut = this.getAttribut(attributName);
        return attribut != null ? attribut.getBoolean(attributName) : defaultValue;
    }

    public <T extends IStiSerializableToString> T getSerializeObject(String attributName, Class<T> class1) {
        return this.getSerializeObject(attributName, class1, null);
    }

    public <T extends IStiSerializableToString> T getSerializeObject(String attributName, Class<T> class1, T defaultObject) {
        StiDocumentItemAttribut attribut = this.getAttribut(attributName);
        return attribut != null ? attribut.getSerializeObject(attributName, class1) : defaultObject;
    }

    private StiDocumentItemAttribut getAttribut(String attributName) {
        StiDocumentItemAttribut keyInstance = new StiDocumentItemAttribut();
        keyInstance.attributName = attributName;
        int index = Collections.binarySearch(this.attributes, keyInstance, BY_NAME);
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        return this.attributes.get(index);
    }

    public void finishAdd() {
        Collections.sort(this.attributes, BY_NAME);
    }

    public <T extends Enum<?>> T getEnum(String attributName, T defaulValue) {
        StiDocumentItemAttribut attribut = this.getAttribut(attributName);
        return attribut != null ? attribut.getEnum(defaulValue) : defaulValue;
    }

    public static boolean isServiceAttribute(String nodeName) {
        for (String serviceAttribut : SERVICE_ATTRIBUTES) {
            if (!nodeName.equals(serviceAttribut)) continue;
            return true;
        }
        return false;
    }
}

