/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing;

import com.stimulsoft.base.serializing.StiProperties;
import com.stimulsoft.base.serializing.StiProperty;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class StiClassProperties {
    private static final ConcurrentHashMap<String, StiProperties> CLASS_PROPERTIES = new ConcurrentHashMap();

    private StiClassProperties() {
    }

    private static void add(Class<?> clazz, StiProperties properties) {
        CLASS_PROPERTIES.put(clazz.getName(), properties);
    }

    public static StiProperties getPropertys(Object instance) {
        return StiClassProperties.getPropertys(instance.getClass());
    }

    static StiProperties getPropertys(Class<?> clazz) {
        StiProperties existProperties = CLASS_PROPERTIES.get(clazz.getName());
        if (existProperties != null) {
            return existProperties;
        }
        return StiClassProperties.notExistProperties(clazz);
    }

    private static StiProperties notExistProperties(Class<?> clazz) {
        StiProperties properties = StiClassProperties.createProperties(clazz);
        StiClassProperties.add(clazz, properties);
        return properties;
    }

    private static StiProperties createProperties(Class<?> clazz) {
        Method[] methods;
        StiProperties properties = new StiProperties(clazz);
        for (Method method : methods = StiClassProperties.getMethods(clazz)) {
            try {
                StiClassProperties.createProperty(clazz, properties, method);
            }
            catch (Exception e) {
                throw new RuntimeException("\nClass" + clazz + "\nmethod" + method, e);
            }
        }
        return properties;
    }

    private static Method[] getMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        return methods;
    }

    private static void createProperty(Class<?> clazz, StiProperties properties, Method getMetod) {
        StiSerializable anoField = getMetod.getAnnotation(StiSerializable.class);
        if (anoField != null && anoField.need()) {
            Method setMetod = StiProperty.createSetMetod(clazz, getMetod);
            StiProperty property = new StiProperty(getMetod, setMetod, anoField.propertyName());
            properties.add(property);
        }
    }
}

