/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableToString;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;

public abstract class Range
implements IStiSerializable,
IStiSerializableToString {
    public abstract String getRangeName();

    public abstract StiSystemTypeEnum getRangeType();

    public abstract Object getFromObject();

    public abstract void setFromObject(Object var1);

    public abstract Object getToObject();

    public abstract void setToObject(Object var1);

    protected abstract String getSerializeName();

    public void setFromAndTo(Object from, Object to) {
        this.setFromObject(from);
        this.setToObject(to);
    }

    public final void Parse(String from, String to) {
        if (this.getRangeType() == StiSystemTypeEnum.SystemChar) {
            if (from != null && from.length() > 0) {
                this.setFromObject(Character.valueOf(from.charAt(0)));
            }
            if (to != null && to.length() > 0) {
                this.setToObject(Character.valueOf(to.charAt(0)));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemDateTime) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(null);
            } else {
                this.setFromObject(new Date(Date.parse(from)));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(null);
            } else {
                this.setToObject(new Date(Date.parse(to)));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemTimeSpan) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(null);
            } else {
                this.setFromObject(StiDateTime.Parse(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(null);
            } else {
                this.setToObject(StiDateTime.Parse(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemDecimal) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(0);
            } else {
                this.setFromObject(new BigDecimal(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(0);
            } else {
                this.setToObject(new BigDecimal(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemSingle) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(Float.valueOf(0.0f));
            } else {
                this.setFromObject(Float.valueOf(Float.parseFloat(from)));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(Float.valueOf(0.0f));
            } else {
                this.setToObject(Float.valueOf(Float.parseFloat(to)));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemDouble) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(0.0);
            } else {
                this.setFromObject(Double.parseDouble(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(0.0);
            } else {
                this.setToObject(Double.parseDouble(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemByte) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(0);
            } else {
                this.setFromObject(Byte.parseByte(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(0);
            } else {
                this.setToObject(Byte.parseByte(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemInt16) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(0);
            } else {
                this.setFromObject(Short.parseShort(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(0);
            } else {
                this.setToObject(Short.parseShort(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemInt32) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(0);
            } else {
                this.setFromObject(Integer.parseInt(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(0);
            } else {
                this.setToObject(Integer.parseInt(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemInt64) {
            if (StiValidationUtil.isNullOrEmpty((String)from.trim())) {
                this.setFromObject(0);
            } else {
                this.setFromObject(Long.parseLong(from));
            }
            if (StiValidationUtil.isNullOrEmpty((String)to.trim())) {
                this.setToObject(0);
            } else {
                this.setToObject(Long.parseLong(to));
            }
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemGuid) {
            this.setFromObject(new StiGuid(from));
            this.setToObject(new StiGuid(to));
        } else if (this.getRangeType() == StiSystemTypeEnum.SystemString) {
            this.setFromObject(from);
            this.setToObject(to);
        }
    }

    @Override
    public String serialize() {
        String data = MessageFormat.format(this.getSerializeName() + ",{0},{1}", StiXMLConvert.encodeName(this.getFromObject()), StiXMLConvert.encodeName(this.getToObject()));
        return data;
    }

    public Range fromStringValue(String str) {
        this.deserialize(str);
        return this;
    }

    public String toString() {
        String from = this.getFromObject() != null ? this.getFromObject().toString() : "";
        String to = this.getToObject() != null ? this.getToObject().toString() : "";
        return String.format("%s '%s' %s '%s'", StiLocalization.Get("PropertyMain", "RangeFrom"), from, StiLocalization.Get("PropertyMain", "RangeTo"), to);
    }
}

