/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;

public class IntRange
extends Range {
    public int From = 0;
    public int To = 0;

    @Override
    public String getRangeName() {
        return "IntRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemInt32;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof Integer) {
            this.From = (Integer)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof Integer) {
            this.To = (Integer)value;
        }
    }

    public final boolean Contains(int value) {
        return this.From <= value && this.To >= value;
    }

    public IntRange() {
    }

    public IntRange(int from, int to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String serialize() {
        String data = String.format(this.getSerializeName() + ",%s,%s", this.getFromObject(), this.getToObject());
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiSerializTypeConverter.stringToInteger(values[1]);
        this.To = StiSerializTypeConverter.stringToInteger(values[2]);
    }

    @Override
    protected String getSerializeName() {
        return "Int";
    }

    public static IntRange fromSerializeValue(String str) {
        IntRange result = new IntRange();
        result.deserialize(str);
        return result;
    }
}

