/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.range;

import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.serializing.utils.StiSerializTypeConverter;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import java.math.BigDecimal;
import java.text.MessageFormat;

public class DecimalRange
extends Range {
    public BigDecimal From = BigDecimal.ZERO;
    public BigDecimal To = BigDecimal.ZERO;

    @Override
    public String getRangeName() {
        return "DecimalRange";
    }

    @Override
    public StiSystemTypeEnum getRangeType() {
        return StiSystemTypeEnum.SystemDecimal;
    }

    @Override
    public Object getFromObject() {
        return this.From;
    }

    @Override
    public void setFromObject(Object value) {
        if (value instanceof BigDecimal) {
            this.From = (BigDecimal)value;
        }
    }

    @Override
    public Object getToObject() {
        return this.To;
    }

    @Override
    public void setToObject(Object value) {
        if (value instanceof BigDecimal) {
            this.To = (BigDecimal)value;
        }
    }

    public final boolean Contains(BigDecimal value) {
        return this.From.compareTo(value) <= 0 && this.To.compareTo(value) >= 0;
    }

    public DecimalRange() {
    }

    public DecimalRange(BigDecimal from, BigDecimal to) {
        this.From = from;
        this.To = to;
    }

    @Override
    public String serialize() {
        String data = MessageFormat.format(this.getSerializeName() + ",{0},{1}", StiXMLConvert.encodeName(StiSerializTypeConverter.bigDecimalToString(this.From)), StiXMLConvert.encodeName(StiSerializTypeConverter.bigDecimalToString(this.To)));
        return data;
    }

    @Override
    public void deserialize(String strObject) {
        String[] values = strObject.split(",");
        this.From = StiSerializTypeConverter.stringToBigDecimal(StiXMLConvert.decodeName(values[1]));
        this.To = StiSerializTypeConverter.stringToBigDecimal(StiXMLConvert.decodeName(values[2]));
    }

    @Override
    protected String getSerializeName() {
        return "Decimal";
    }

    public static DecimalRange fromSerializeValue(String str) {
        DecimalRange result = new DecimalRange();
        result.deserialize(str);
        return result;
    }
}

