/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.parser;

import com.stimulsoft.base.parser.SecurityCode;
import com.stimulsoft.base.parser.StiCSharpScriptParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StiSecureClassValidator {
    private static final Set<String> ALLOWED_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.String", "java.util.AbstractMap$SimpleEntry", "void", "java.lang.Exception", "java.lang.Comparable", "java.util.Stack", "java.lang.StringBuilder", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Number", "java.lang.Math", "java.lang.Object", "java.util.ArrayList", "java.util.HashMap", "java.util.HashSet", "java.util.TreeMap", "java.util.TreeSet", "java.util.LinkedList", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.Collections", "java.util.Arrays", "java.time.LocalDate", "java.time.LocalTime", "java.time.LocalDateTime", "java.time.ZonedDateTime", "java.time.Instant", "java.time.Duration", "java.time.Period", "java.math.BigDecimal", "java.math.BigInteger", "com.stimulsoft.base.drawing.StiColor", "com.stimulsoft.base.drawing.StiHatchStyle", "com.stimulsoft.base.system.StiFont", "com.stimulsoft.base.system.StiFontStyle", "com.stimulsoft.base.system.StiSize", "com.stimulsoft.base.system.StiPoint", "com.stimulsoft.base.system.StiRectangle", "com.stimulsoft.base.system.StiDateTime", "com.stimulsoft.base.system.StiDateTimeOffset", "com.stimulsoft.base.system.StiTimeSpan", "com.stimulsoft.base.system.StiGuid", "com.stimulsoft.base.parser.classes.HashSet", "com.stimulsoft.base.parser.classes.Queue", "com.stimulsoft.base.parser.classes.SortedList")));
    private static final Set<String> BLOCKED_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.Runtime", "java.lang.ProcessBuilder", "java.lang.Process", "java.lang.System", "java.lang.Class", "java.lang.ClassLoader", "java.lang.Thread", "java.lang.ThreadGroup", "java.io.File", "java.io.FileInputStream", "java.io.FileOutputStream", "java.io.FileReader", "java.io.FileWriter", "java.io.RandomAccessFile", "java.nio.file.Files", "java.nio.file.Paths", "java.nio.file.Path", "java.nio.file.WatchService", "java.net.Socket", "java.net.ServerSocket", "java.net.DatagramSocket", "java.net.URL", "java.net.URLConnection", "java.net.HttpURLConnection", "java.net.Socket", "java.lang.reflect.Field", "java.lang.reflect.Method", "java.lang.reflect.Constructor", "java.lang.reflect.Proxy", "sun.reflect.Reflection", "sun.reflect.ReflectionFactory", "java.security.AccessController", "java.security.CodeSource", "java.security.Policy", "java.security.Permission", "java.security.ProtectionDomain", "java.security.KeyStore", "javax.script.ScriptEngineManager", "javax.script.ScriptEngine", "java.io.ObjectInputStream", "java.io.ObjectOutputStream", "java.io.Serializable", "java.lang.UNIXProcess", "java.lang.ProcessImpl")));
    private static final Set<String> BLOCKED_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("exec", "start", "getRuntime", "getClass", "getProtectionDomain", "exit", "halt", "abort", "destroy", "forName", "getDeclaredMethod", "getDeclaredField", "getDeclaredFields", "getDeclaredMethods", "getDeclaredConstructor", "getDeclaredConstructors", "setAccessible", "newInstance", "newProxyInstance", "loadLibrary", "load", "loadClass", "defineClass", "loadClassInternal", "getenv", "getProperty", "setProperty", "clearProperty", "getProperties", "delete", "deleteOnExit", "mkdir", "mkdirs", "createNewFile", "renameTo", "setWritable", "setReadable", "setExecutable", "setLastModified", "setReadOnly", "accept", "bind", "connect", "send", "receive", "listen", "setSecurityManager", "getSecurityManager", "getInputStream", "getOutputStream", "getErrorStream", "shutdown", "shutdownNow", "runFinalization", "gc", "getModule", "getModules", "getUnnamedModule")));
    private static final Set<String> BLOCKED_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("out", "err", "in", "properties", "securityManager", "security", "cons", "parent", "classes", "resources", "nativeLibraryPath", "cmd")));
    private static final Set<String> ALLOWED_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("name", "Name")));
    private static final Set<String> BLOCKED_PACKAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.invoke", "sun.", "jdk.", "com.sun.", "java.nio.channels", "java.nio.file", "java.io")));

    public static void validateClass(String className) throws StiCSharpScriptParser.ScriptSecurityException {
        if (className == null || className.isEmpty()) {
            throw new StiCSharpScriptParser.ScriptSecurityException("Class name cannot be null or empty", SecurityCode.BlockedType);
        }
        if (BLOCKED_CLASSES.contains(className)) {
            throw new StiCSharpScriptParser.ScriptSecurityException("Access to class '" + className + "' is blocked for security reasons (CWE-95)", SecurityCode.BlockedType);
        }
        for (String blockedPackage : BLOCKED_PACKAGES) {
            if (!className.startsWith(blockedPackage)) continue;
            throw new StiCSharpScriptParser.ScriptSecurityException("Access to package '" + blockedPackage + "' is blocked for security reasons", SecurityCode.BlockedType);
        }
        if (!StiSecureClassValidator.isAllowedClass(className)) {
            throw new StiCSharpScriptParser.ScriptSecurityException("Access to class '" + className + "' is not allowed. Only whitelisted classes are permitted (CWE-95)", SecurityCode.BlockedType);
        }
    }

    public static void validateMethod(String className, String methodName) throws StiCSharpScriptParser.ScriptSecurityException {
        StiSecureClassValidator.validateClass(className);
        if (BLOCKED_METHODS.contains(methodName)) {
            throw new StiCSharpScriptParser.ScriptSecurityException("Method '" + methodName + "' on class '" + className + "' is blocked for security reasons (CWE-95)", SecurityCode.BlockedType);
        }
        if (className.equals("java.lang.String") && methodName.equals("substring")) {
            return;
        }
    }

    public static void validateField(String className, String fieldName) throws StiCSharpScriptParser.ScriptSecurityException {
        if (!ALLOWED_FIELDS.contains(fieldName)) {
            StiSecureClassValidator.validateClass(className);
        }
        if (BLOCKED_FIELDS.contains(fieldName)) {
            throw new StiCSharpScriptParser.ScriptSecurityException("Field '" + fieldName + "' in class '" + className + "' is blocked for security reasons (CWE-95)", SecurityCode.BlockedType);
        }
    }

    public static void validateConstructor(String className) throws StiCSharpScriptParser.ScriptSecurityException {
        StiSecureClassValidator.validateClass(className);
        HashSet<String> noConstruct = new HashSet<String>(Arrays.asList("java.lang.Runtime", "java.lang.System", "java.lang.Math", "java.lang.ClassLoader", "java.lang.Class", "java.lang.Thread", "java.lang.ProcessBuilder"));
        if (noConstruct.contains(className)) {
            throw new StiCSharpScriptParser.ScriptSecurityException("Cannot instantiate class '" + className + "'", SecurityCode.BlockedType);
        }
    }

    private static boolean isAllowedClass(String className) {
        if (ALLOWED_CLASSES.contains(className)) {
            return true;
        }
        if (className.startsWith("com.stimulsoft.base.parser.classes.")) {
            return true;
        }
        return className.startsWith("com.stimulsoft.") && !className.contains("java.");
    }

    public static boolean isPrimitiveType(String className) {
        HashSet<String> primitiveTypes = new HashSet<String>(Arrays.asList("int", "long", "double", "float", "boolean", "byte", "short", "char", "void", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Character", "java.lang.Void"));
        return primitiveTypes.contains(className);
    }

    public static Set<String> getAllowedClasses() {
        return ALLOWED_CLASSES;
    }

    public static Set<String> getBlockedClasses() {
        return BLOCKED_CLASSES;
    }
}

