/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.licenses;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.licenses.StiLicense;
import com.stimulsoft.base.licenses.StiLicenseKey;
import com.stimulsoft.base.licenses.StiLicenseProduct;
import com.stimulsoft.base.licenses.StiProductIdent;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.Calendar;

public class StiLicenseKeyValidator {
    private static long lastLicenseMills = 0L;

    private static void showTrial() {
        long currentMills = Calendar.getInstance().getTimeInMillis();
        if (currentMills - lastLicenseMills > 20000L) {
            System.out.println("You are using a trial version of the Stimulsoft product!");
            lastLicenseMills = currentMills;
        }
    }

    public static boolean isValid(StiProductIdent ident, StiLicenseKey key) {
        if (key == null) {
            key = StiLicenseKeyValidator.getLicenseKey();
        }
        boolean res = false;
        if (key != null) {
            for (StiLicenseProduct p : key.getProducts()) {
                if (p.getIdent() != ident && p.getIdent() != StiProductIdent.Ultimate || p.getExpirationDate().compareTo(StiAttribute.CREATED) <= 0) continue;
                res = true;
            }
        }
        return key != null && key.getProducts() != null && res;
    }

    public static boolean isValidOnJavaFramework(StiLicenseKey key) {
        boolean result;
        if (key == null) {
            key = StiLicenseKeyValidator.getLicenseKey();
        }
        boolean res = false;
        if (key != null) {
            for (StiLicenseProduct p : key.getProducts()) {
                if (!StiLicenseKeyValidator.isJavaPlatform(p.getIdent()) || p.getExpirationDate().compareTo(StiAttribute.CREATED) <= 0) continue;
                res = true;
            }
        }
        boolean bl = result = key != null && key.getProducts() != null && res;
        if (!result) {
            StiLicenseKeyValidator.showTrial();
        }
        return result;
    }

    public static boolean isValidOnAnyPlatform(StiLicenseKey key) {
        if (key == null) {
            key = StiLicenseKeyValidator.getLicenseKey();
        }
        boolean res = false;
        if (key != null) {
            for (StiLicenseProduct p : key.getProducts()) {
                if (p.getExpirationDate().compareTo(StiAttribute.CREATED) <= 0) continue;
                res = true;
            }
        }
        return key != null && key.getProducts() != null && res;
    }

    public static boolean isValidInDesignerOrOnSpecifiedPlatform(StiProductIdent ident, StiLicenseKey key) {
        return false;
    }

    private static boolean isJavaPlatform(StiProductIdent ident) {
        return ident == StiProductIdent.Java || ident == StiProductIdent.Ultimate;
    }

    public static StiLicenseKey getLicenseKey() {
        if (StiValidationUtil.isNullOrWhiteSpace((String)StiLicense.getKey())) {
            return null;
        }
        if (StiLicense.getLicenseKey() == null) {
            return null;
        }
        if (StiLicense.getLicenseKey().getSignature() == null) {
            return null;
        }
        return StiLicense.getLicenseKey();
    }
}

