/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.licenses;

import com.stimulsoft.base.licenses.StiCryptHelper;
import com.stimulsoft.base.licenses.StiLicenseKey;
import com.stimulsoft.base.licenses.StiRsaPublicKey;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class StiLicense {
    private static StiLicenseKey licenseKey;
    private static String key;

    public static StiLicenseKey getLicenseKey() {
        return licenseKey;
    }

    public static void setLicenseKey(StiLicenseKey licenseKey) {
        StiLicense.licenseKey = licenseKey;
    }

    public static String getKey() {
        return key;
    }

    public static void setKey(String value) {
        StiLicense.setNewLicenseKey(value);
    }

    public static void setNewLicenseKey(String value) {
        boolean throwException = true;
        if (StiValidationUtil.isNullOrWhiteSpace((String)value)) {
            key = null;
            StiLicense.setLicenseKey(null);
        } else {
            StiLicenseKey newLicenseKey = StiLicenseKey.get(value);
            if (newLicenseKey != null && !StiLicense.isValidUserName(newLicenseKey.getUserName())) {
                if (throwException) {
                    throw new RuntimeException("The license key is invalid. In order to use Stimulsoft products, please obtain and install a new valid license key.");
                }
                key = null;
                StiLicense.setLicenseKey(null);
            }
            if (StiLicense.isValidLicenseKey(newLicenseKey)) {
                StiLicense.setLicenseKey(newLicenseKey);
                key = value;
            } else {
                key = null;
                StiLicense.setLicenseKey(null);
            }
        }
    }

    public static boolean isValidLicenseKey(StiLicenseKey licenseKey) {
        try {
            if (licenseKey == null) {
                return false;
            }
            if (licenseKey.getSignature() == null) {
                return false;
            }
            StiLicenseKey newKey = (StiLicenseKey)licenseKey.clone();
            newKey.setSignature(null);
            Cipher cipher = Cipher.getInstance("RSA");
            PublicKey pubKey = StiRsaPublicKey.getPublicKey();
            cipher.init(2, pubKey);
            byte[] encrypted = cipher.doFinal(StiBase64DecoderUtil.decode((String)licenseKey.getSignature()));
            String rsaEncrypted = StiLicense.byteArrayToHexString(encrypted);
            MessageDigest md = null;
            md = MessageDigest.getInstance("SHA-1");
            String sha = StiLicense.byteArrayToHexString(md.digest(newKey.saveToBytesInternal()));
            return StiValidationUtil.isNotNullOrEmpty((String)sha) && StiValidationUtil.isNotNullOrEmpty((String)rsaEncrypted) && sha.length() >= 30 && rsaEncrypted.endsWith(sha);
        }
        catch (Exception e) {
            if (StiLoggingUtil.getLogLevel() >= 10) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static void loadFromFile(String file) throws FileNotFoundException, IOException {
        String sfile = StiIOUtil.toString((InputStream)new FileInputStream(file));
        StiLicense.loadFromString(sfile);
    }

    public static void loadFromStream(InputStream stream) throws IOException {
        StiLicense.loadFromString(StiIOUtil.toString((InputStream)stream));
    }

    public static void loadFromString(String licenseKey) {
        StiLicense.setKey(licenseKey);
    }

    private static boolean isValidUserName(String userName) {
        try {
            String hash = StiCryptHelper.MD5(userName.trim().toLowerCase());
            InputStream stream = StiLicense.class.getResourceAsStream("/com/stimulsoft/Maps.data");
            String[] lines = StiIOUtil.toString((InputStream)stream).split(",");
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].equalsIgnoreCase(hash)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

