/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.helper;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiConvert;
import com.stimulsoft.base.system.StiDateOnly;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiTimeOnly;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;

public class StiValueHelper {
    /*
     * Loose catch block
     */
    public static Double tryToNullableDouble(Object value) {
        block10: {
            if (value == null || value == DBNull.Value) {
                return null;
            }
            if (value instanceof String) {
                String str = StiValueHelper.normalizeFloatingPointValue(value);
                try {
                    return Double.parseDouble(str);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (value.getClass().isEnum()) {
                return ((Enum)value).ordinal();
            }
            if (value.getClass().isAssignableFrom(Number.class)) break block10;
            return null;
            {
                catch (Exception e) {
                    return null;
                }
            }
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static StiDateOnly tryToNullableDateOnly(Object value) {
        if (value == null || value instanceof String && StiValidationUtil.isNullOrEmpty((String)((String)value))) {
            return null;
        }
        try {
            return (StiDateOnly)StiConvert.changeType(value, StiSystemTypeEnum.SystemDateOnly.getSystemType(), false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String tryToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static StiTimeOnly tryToNullableTimeOnly(Object value) {
        if (value instanceof StiTimeOnly) {
            return (StiTimeOnly)value;
        }
        if (value == null) {
            return null;
        }
        try {
            return (StiTimeOnly)StiConvert.changeType(value, StiSystemTypeEnum.SystemTimeOnly.getSystemType(), false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BigDecimal tryToDecimal(Object value) {
        if (value == null || value == DBNull.Value) {
            return null;
        }
        try {
            String str;
            String string = str = value instanceof String ? (String)value : null;
            if (str != null) {
                str = StiValueHelper.normalizeFloatingPointValue(value);
                try {
                    return new BigDecimal(str.trim());
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (!(value instanceof Number)) {
                return null;
            }
            return StiValueHelper.toDecimal(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BigDecimal toDecimal(Object value) {
        try {
            if (value instanceof Long) {
                return new BigDecimal((Long)value);
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return new BigDecimal(value.toString());
        }
        catch (Exception exception) {
            return new BigDecimal(0);
        }
    }

    public static StiGuid tryToGuid(Object value) {
        if (value instanceof StiGuid) {
            return (StiGuid)value;
        }
        if (value == null || StiValidationUtil.isNullOrEmpty((String)value.toString())) {
            return StiGuid.getEmpty();
        }
        try {
            return (StiGuid)StiConvert.changeType(value, StiGuid.class, false);
        }
        catch (Exception e) {
            return StiGuid.getEmpty();
        }
    }

    public static StiTimeSpan TryToTimeSpan(Object value) {
        try {
            if (value instanceof StiTimeSpan) {
                return (StiTimeSpan)value;
            }
            if (value == null || value == DBNull.Value) {
                return new StiTimeSpan(0L);
            }
            Object valObject = StiConvert.changeType(value, StiTimeSpan.class, false);
            return valObject instanceof StiTimeSpan ? (StiTimeSpan)valObject : StiTimeSpan.ZERO;
        }
        catch (Exception e) {
            return new StiTimeSpan(0L);
        }
    }

    public static StiDateTime tryToDateTime(Object value) {
        try {
            if (value instanceof StiDateTime) {
                return (StiDateTime)value;
            }
        }
        catch (Exception e) {
            return StiDateTime.currentDate();
        }
        return StiDateTime.currentDate();
    }

    public static boolean tryToBool(Object value) {
        try {
            if (value == null || value == DBNull.Value) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return StiValueHelper.tryToDouble(value) == 1.0;
            }
            if (value instanceof String) {
                String str = ((String)value).toLowerCase();
                return str.equals("true") || str.equals("on") || str.equals("yes");
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static char tryToChar(Object value) {
        if (value == null) {
            return ' ';
        }
        String str = value.toString();
        return str.length() > 0 ? str.charAt(0) : (char)' ';
    }

    public static double tryToDouble(Object value) {
        BigDecimal result = StiValueHelper.tryToDecimal(value);
        return result == null ? 0.0 : result.doubleValue();
    }

    public static long tryToLong(Object value) {
        Double result = StiValueHelper.tryToDouble(value);
        return result == null ? 0L : result.longValue();
    }

    public static float tryToFloat(Object value) {
        return new Double(StiValueHelper.tryToDouble(value)).floatValue();
    }

    public static int tryToInt(Object value) {
        Double result = StiValueHelper.tryToDouble(value);
        return result == null ? 0 : result.intValue();
    }

    public static int tryToShort(Object value) {
        Double result = StiValueHelper.tryToDouble(value);
        return result == null ? (short)0 : result.shortValue();
    }

    private static String normalizeFloatingPointValue(Object value) {
        return value.toString().trim().replace(",", ".");
    }
}

