/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.exception;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class StiPopupTextArea
extends JTextArea {
    private static final long serialVersionUID = 6558629844146933045L;

    public StiPopupTextArea() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem();
        copyItem.setAction(this.getActionMap().get("copy-to-clipboard"));
        copyItem.setText("Copy");
        JMenuItem cutItem = new JMenuItem();
        cutItem.setAction(this.getActionMap().get("cut-to-clipboard"));
        cutItem.setText("Cut");
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.setAction(this.getActionMap().get("paste-from-clipboard"));
        pasteItem.setText("Paste");
        JMenuItem selectAllItem = new JMenuItem("Select All");
        selectAllItem.setAction(this.getActionMap().get("select-all"));
        selectAllItem.setText("Select All");
        menu.add(copyItem);
        menu.add(cutItem);
        menu.add(pasteItem);
        menu.add(new JSeparator());
        menu.add(selectAllItem);
        this.add(menu);
        this.addMouseListener(new PopupTriggerMouseListener(menu, this));
    }

    public static class PopupTriggerMouseListener
    extends MouseAdapter {
        private JPopupMenu popup;
        private JComponent component;

        public PopupTriggerMouseListener(JPopupMenu popup, JComponent component) {
            this.popup = popup;
            this.component = component;
        }

        private void showMenuIfPopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(this.component, e.getX() + 3, e.getY() + 3);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showMenuIfPopupTrigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showMenuIfPopupTrigger(e);
        }
    }
}

