/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.elements;

import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StiKeyHelper {
    public static String generateKey() {
        return StiGuid.newGuidStringPlain();
    }

    public static boolean isKey(String key) {
        return !StiKeyHelper.isEmptyKey(key);
    }

    public static boolean isCorrectKey(String key) {
        if (StiKeyHelper.isEmptyKey(key)) {
            return true;
        }
        if (key.length() != 32) {
            return false;
        }
        Pattern p = Pattern.compile("^[a-zA-Z0-9]*$");
        Matcher m = p.matcher(key);
        return m.matches();
    }

    public static boolean isEmptyKey(String key) {
        return StiValidationUtil.isNullOrEmpty((String)key);
    }

    public static boolean isEmptyKey(String key1, String key2) {
        return StiKeyHelper.isEmptyKey(key1) && StiKeyHelper.isEmptyKey(key2);
    }

    public static String selectKey(String key1, String key2) {
        if (!StiKeyHelper.isEmptyKey(key1)) {
            return key1;
        }
        return key2;
    }

    public static boolean isEqualKeys(String key1, String key2) {
        if (StiKeyHelper.isEmptyKey(key1) && StiKeyHelper.isEmptyKey(key2)) {
            return true;
        }
        key1 = key1.trim().toLowerCase();
        key2 = key2.trim().toLowerCase();
        return key1.equals(key2);
    }

    public static String getOrGeneratedKey(String key) {
        return StiKeyHelper.isEmptyKey(key) ? StiKeyHelper.generateKey() : key;
    }

    public static String getOrGeneratedKey(String key1, String key2) {
        return StiKeyHelper.getOrGeneratedKey(StiKeyHelper.selectKey(key1, key2));
    }
}

