/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class StiShadowGraphics {
    private double FACTOR = 3.0;
    private StiGraphics graphics;
    private BufferedImage shadowImage = null;
    private RenderingHints hits;

    public StiShadowGraphics(StiRectangle rect) {
        this.shadowImage = new BufferedImage((int)Math.round(rect.width / this.FACTOR) + 10, (int)Math.round(rect.height / this.FACTOR) + 10, 2);
        Graphics2D g2d = this.shadowImage.createGraphics();
        this.graphics = new StiGraphics(g2d);
        this.hits = g2d.getRenderingHints();
        g2d.scale(1.0 / this.FACTOR, 1.0 / this.FACTOR);
        this.graphics.setOffset(5.0 * this.FACTOR, 5.0 * this.FACTOR);
        StiGraphicsHelper.setRenderingHints(g2d);
    }

    public void drawShadow(StiGraphics g, StiRectangle rect, int shadowSize, double zoom) {
        RenderingHints renderingHints = g.getG().getRenderingHints();
        this.setRenderingHints(g.getG());
        StiRectangle imgRect = new StiRectangle(rect.x - 5.0 * this.FACTOR + (double)shadowSize, rect.y - 5.0 * this.FACTOR + (double)shadowSize, rect.width + 10.0 * this.FACTOR, rect.height + 10.0 * this.FACTOR);
        g.drawImage(this.shadowImage, imgRect, false, false, zoom);
        g.getG().setRenderingHints(renderingHints);
    }

    public void drawShadow(StiGraphics g, StiRectangle rect, double shadowSize, double zoom) {
        RenderingHints renderingHints = g.getG().getRenderingHints();
        this.setRenderingHints(g.getG());
        StiRectangle imgRect = new StiRectangle(rect.x - 5.0 * this.FACTOR + shadowSize, rect.y - 5.0 * this.FACTOR + shadowSize, rect.width + 10.0 * this.FACTOR, rect.height + 10.0 * this.FACTOR);
        g.drawImage(this.shadowImage, imgRect, true, false, zoom);
        g.getG().setRenderingHints(renderingHints);
    }

    private void setRenderingHints(Graphics2D graphics) {
        graphics.setRenderingHints(this.hits);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public StiGraphics getGraphics() {
        return this.graphics;
    }
}

