/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class StiFontReader {
    private int position = 0;
    private int[] data = null;
    private TtfInfo ttf = null;

    private Head ReadHeadTable() throws Exception {
        this.SetPosition(this.ttf.Tables.get((Object)"head").Offset);
        Head head = new Head();
        head.MajorVersion = this.getUint16();
        head.MinorVersion = this.getUint16();
        head.FontRevision = this.getFixed();
        head.ChecksumAdjustment = this.getUint32();
        head.MagicNumber = this.getUint32();
        head.Flags = this.getUint16();
        head.UnitsPerEm = this.getUint16();
        head.Created = this.getDate();
        head.Modified = this.getDate();
        head.XMin = this.getInt16();
        head.YMin = this.getInt16();
        head.XMax = this.getInt16();
        head.YMax = this.getInt16();
        head.MacStyle = this.getUint16();
        head.LowestRecPPEM = this.getUint16();
        head.FontDirectionHint = this.getInt16();
        head.IndexToLocFormat = this.getInt16();
        head.GlyphDataFormat = this.getInt16();
        if (head.MagicNumber != 1594834165) {
            throw new Exception("Magic number is incorrect");
        }
        return head;
    }

    private Name ReadNameTable() throws Exception {
        int i;
        Name name;
        int offset = this.ttf.Tables.get((Object)"name").Offset;
        this.SetPosition(offset);
        int format = this.getUint16();
        if (format == 0) {
            name = new Name();
            name.Format = 0;
            name.Count = this.getUint16();
            name.StringOffset = this.getOffset16();
            name.NameRecord = new ArrayList();
            for (i = 0; i < name.Count; ++i) {
                NameRecord namerecord = new NameRecord();
                namerecord.PlatformID = this.getUint16();
                namerecord.EncodingID = this.getUint16();
                namerecord.LanguageID = this.getUint16();
                namerecord.NameID = this.getUint16();
                namerecord.Length = this.getUint16();
                namerecord.Offset = this.getOffset16();
                name.NameRecord.add(namerecord);
            }
        } else if (format == 1) {
            name = new Name();
            name.Format = 1;
            name.Count = this.getUint16();
            name.StringOffset = this.getUint16();
            name.NameRecord = new ArrayList();
            for (i = 0; i < name.Count; ++i) {
                NameRecord nr = new NameRecord();
                nr.PlatformID = this.getUint16();
                nr.EncodingID = this.getUint16();
                nr.LanguageID = this.getUint16();
                nr.NameID = this.getUint16();
                nr.Length = this.getUint16();
                nr.Offset = this.getOffset16();
                name.NameRecord.add(nr);
            }
            name.LangTagCount = this.getUint16();
            name.LangTagRecord = new ArrayList();
            for (i = 0; i < name.LangTagCount; ++i) {
                LangTagRecord lt = new LangTagRecord();
                lt.Length = this.getUint16();
                lt.Offset = this.getOffset16();
                name.LangTagRecord.add(lt);
            }
        } else {
            throw new Exception("Incorrect format");
        }
        name.FontNames = new Hashtable();
        for (NameRecord record : name.NameRecord) {
            this.SetPosition(offset + name.StringOffset + record.Offset);
            record.String = record.PlatformID == 3 ? this.GetStringUtf16(record.Length) : this.GetString(record.Length);
            if ((record.PlatformID != 3 || record.EncodingID != 0 && record.EncodingID != 1 || record.NameID != 1) && (record.PlatformID != 0 || record.EncodingID != 3 || record.NameID != 1)) continue;
            name.FontNames.put(String.valueOf(record.LanguageID), record.String);
        }
        if (name.FontNames.size() == 0) {
            for (NameRecord record : name.NameRecord) {
                if (record.NameID != 1) continue;
                name.FontNames.put(String.valueOf(record.LanguageID), record.String);
            }
        }
        return name;
    }

    private Maxp ReadMaxpTable() {
        this.SetPosition(this.ttf.Tables.get((Object)"maxp").Offset);
        Maxp maxp = new Maxp();
        maxp.Version = this.getUint32();
        maxp.NumGlyphs = this.getUint16();
        maxp.MaxPoints = this.getUint16();
        maxp.MaxContours = this.getUint16();
        maxp.MaxCompositePoints = this.getUint16();
        maxp.MaxCompositeContours = this.getUint16();
        maxp.MaxZones = this.getUint16();
        maxp.MaxTwilightPoints = this.getUint16();
        maxp.MaxStorage = this.getUint16();
        maxp.MaxFunctionDefs = this.getUint16();
        maxp.MaxInstructionDefs = this.getUint16();
        maxp.MaxStackElements = this.getUint16();
        maxp.MaxSizeOfInstructions = this.getUint16();
        maxp.MaxComponentElements = this.getUint16();
        maxp.MaxComponentDepth = this.getUint16();
        return maxp;
    }

    private Hhea ReadHheaTable() {
        this.SetPosition(this.ttf.Tables.get((Object)"hhea").Offset);
        Hhea hhea = new Hhea();
        hhea.Version = this.getUint32();
        hhea.Ascent = this.getFWord();
        hhea.Descent = this.getFWord();
        hhea.LineGap = this.getFWord();
        hhea.AdvanceWidthMax = this.getUFWord();
        hhea.MinLeftSideBearing = this.getFWord();
        hhea.MinRightSideBearing = this.getFWord();
        hhea.XMaxExtent = this.getFWord();
        hhea.CaretSlopeRise = this.getInt16();
        hhea.CaretSlopeRun = this.getInt16();
        hhea.CaretOffset = this.getFWord();
        this.getInt16();
        this.getInt16();
        this.getInt16();
        this.getInt16();
        hhea.MetricDataFormat = this.getInt16();
        hhea.NumOfLongHorMetrics = this.getUint16();
        return hhea;
    }

    private Hmtx ReadHmtxTable(int numOfLongHorMetrics, int numGlyphs) {
        this.SetPosition(this.ttf.Tables.get((Object)"hmtx").Offset);
        ArrayList<LongHorMetric> hMetrics = new ArrayList<LongHorMetric>();
        for (int i = 0; i < numOfLongHorMetrics; ++i) {
            LongHorMetric lhm = new LongHorMetric();
            lhm.AdvanceWidth = this.getUint16();
            lhm.LeftSideBearing = this.getInt16();
            hMetrics.add(lhm);
        }
        ArrayList<Integer> leftSideBearing = new ArrayList<Integer>();
        for (int i = 0; i < numGlyphs - numOfLongHorMetrics; ++i) {
            leftSideBearing.add(this.getFWord());
        }
        Hmtx hmtx = new Hmtx();
        hmtx.HMetrics = hMetrics;
        hmtx.LeftSideBearing = leftSideBearing;
        return hmtx;
    }

    private Format4 ParseFormat4() {
        int i;
        int i2;
        Format4 format4 = new Format4();
        format4.Format = 4;
        format4.Length = this.getUint16();
        format4.Language = this.getUint16();
        format4.SegCountX2 = this.getUint16();
        format4.SearchRange = this.getUint16();
        format4.EntrySelector = this.getUint16();
        format4.RangeShift = this.getUint16();
        format4.EndCode = new ArrayList();
        format4.StartCode = new ArrayList();
        format4.IdDelta = new ArrayList();
        format4.IdRangeOffset = new ArrayList();
        format4.GlyphIndexMap = new Hashtable();
        int segCount = format4.SegCountX2 >> 1;
        for (i2 = 0; i2 < segCount; ++i2) {
            format4.EndCode.add(this.getUint16());
        }
        this.getUint16();
        for (i2 = 0; i2 < segCount; ++i2) {
            format4.StartCode.add(this.getUint16());
        }
        for (i2 = 0; i2 < segCount; ++i2) {
            format4.IdDelta.add(this.getInt16());
        }
        int idRangeOffsetsStart = this.position;
        for (i = 0; i < segCount; ++i) {
            format4.IdRangeOffset.add(this.getUint16());
        }
        for (i = 0; i < segCount - 1; ++i) {
            int glyphIndex = 0;
            int endCode = format4.EndCode.get(i);
            int startCode = format4.StartCode.get(i);
            int idDelta = format4.IdDelta.get(i);
            int idRangeOffset = format4.IdRangeOffset.get(i);
            for (int c = startCode; c <= endCode; ++c) {
                if (idRangeOffset != 0) {
                    int startCodeOffset = (c - startCode) * 2;
                    int currentRangeOffset = i * 2;
                    int glyphIndexOffset = idRangeOffsetsStart + idRangeOffset + currentRangeOffset + startCodeOffset;
                    this.SetPosition(glyphIndexOffset);
                    glyphIndex = this.getUint16();
                    if (glyphIndex != 0) {
                        glyphIndex = glyphIndex + idDelta & 0xFFFF;
                    }
                } else {
                    glyphIndex = c + idDelta & 0xFFFF;
                }
                format4.GlyphIndexMap.put(c, glyphIndex);
            }
        }
        return format4;
    }

    private Format12 ParseFormat12() {
        int i;
        this.getUint16();
        Format12 format12 = new Format12();
        format12.Format = 12;
        format12.Length = this.getUint32();
        format12.Language = this.getUint32();
        format12.NumGroups = this.getUint32();
        format12.StartCharCode = new ArrayList();
        format12.EndCharCode = new ArrayList();
        format12.StartGlyphId = new ArrayList();
        format12.GlyphIndexMap = new Hashtable();
        for (i = 0; i < format12.NumGroups; ++i) {
            format12.StartCharCode.add(this.getUint32());
            format12.EndCharCode.add(this.getUint32());
            format12.StartGlyphId.add(this.getUint32());
        }
        for (i = 0; i < format12.NumGroups - 1; ++i) {
            int startCode = format12.StartCharCode.get(i);
            int endCode = format12.EndCharCode.get(i);
            int glyphId = format12.StartGlyphId.get(i);
            for (int c = startCode; c <= endCode; ++c) {
                format12.GlyphIndexMap.put(c, glyphId++);
            }
        }
        return format12;
    }

    public Cmap ReadCmapTable() throws Exception {
        int offset = this.ttf.Tables.get((Object)"cmap").Offset;
        this.SetPosition(offset);
        Cmap cmap = new Cmap();
        cmap.Version = this.getUint16();
        cmap.NumTables = this.getUint16();
        cmap.EncodingRecords = new ArrayList();
        if (cmap.Version != 0) {
            throw new Exception("cmap version should be 0 but is " + cmap.Version);
        }
        for (int i = 0; i < cmap.NumTables; ++i) {
            EncodingRecord er = new EncodingRecord();
            er.PlatformID = this.getUint16();
            er.EncodingID = this.getUint16();
            er.Offset = this.getOffset32();
            cmap.EncodingRecords.add(er);
        }
        return cmap;
    }

    private Hashtable<Integer, Integer> GetCmapHashTable() throws Exception {
        if (this.ttf.Cmap.GlyphIndexMap != null) {
            return this.ttf.Cmap.GlyphIndexMap;
        }
        for (EncodingRecord table : this.ttf.Cmap.EncodingRecords) {
            if (table.PlatformID != 3 || table.EncodingID != 1 && table.EncodingID != 0) continue;
            this.SetPosition(this.ttf.Tables.get((Object)"cmap").Offset + table.Offset);
            int format = this.getUint16();
            if (format == 4) {
                this.ttf.Cmap.GlyphIndexMap = this.ParseFormat4().GlyphIndexMap;
                continue;
            }
            if (format == 12) {
                this.ttf.Cmap.GlyphIndexMap = this.ParseFormat12().GlyphIndexMap;
                continue;
            }
            throw new Exception("Unsupported format:  Required: 4 or 12.");
        }
        if (this.ttf.Cmap.GlyphIndexMap == null) {
            this.ttf.Cmap.GlyphIndexMap = new Hashtable();
        }
        return this.ttf.Cmap.GlyphIndexMap;
    }

    private int[] GetCmapTable() {
        int[] charToGlyph = null;
        int tableOffset = this.ttf.Tables.get((Object)"cmap").Offset;
        for (EncodingRecord table : this.ttf.Cmap.EncodingRecords) {
            int formatNumber;
            if (table.PlatformID != 3 || table.EncodingID != 1 || (formatNumber = this.GetUInt16(tableOffset + table.Offset)) != 4) continue;
            charToGlyph = new int[65536];
            for (int index = 0; index < 65536; ++index) {
                charToGlyph[index] = 65535;
            }
            int segCountX2 = this.GetUInt16(tableOffset + table.Offset + 6);
            for (int indexSeg = 0; indexSeg < segCountX2; indexSeg += 2) {
                int offsetSeg = tableOffset + table.Offset + 14 + indexSeg;
                int endCode = this.GetUInt16(offsetSeg);
                int startCode = this.GetUInt16(offsetSeg + 2 + segCountX2);
                int idDelta = this.GetUInt16(offsetSeg + 2 + segCountX2 * 2);
                int idRangeOffset = this.GetUInt16(offsetSeg + 2 + segCountX2 * 3);
                if (startCode == 65535) continue;
                for (int indexChar = startCode; indexChar <= endCode; ++indexChar) {
                    int glyphId = 65535;
                    if (idRangeOffset == 0) {
                        glyphId = idDelta + indexChar;
                    } else {
                        int glyphIndexAddress = idRangeOffset + 2 * (indexChar - startCode) + (offsetSeg + 2 + segCountX2 * 3);
                        glyphId = this.GetUInt16(glyphIndexAddress);
                        if (glyphId != 0) {
                            glyphId += idDelta;
                        }
                    }
                    charToGlyph[indexChar] = glyphId;
                }
            }
        }
        return charToGlyph;
    }

    private ArrayList<Integer> ReadLocaTable() {
        this.SetPosition(this.ttf.Tables.get((Object)"loca").Offset);
        ArrayList<Integer> loca = new ArrayList<Integer>();
        for (int i = 0; i < this.ttf.Maxp.NumGlyphs + 1; ++i) {
            if (this.ttf.Head.IndexToLocFormat == 0) {
                loca.add(this.getOffset16());
                continue;
            }
            loca.add(this.getOffset32());
        }
        return loca;
    }

    private ArrayList<GlyphHeader> ReadGlyfTable() {
        ArrayList<Integer> loca = this.ReadLocaTable();
        int offset = this.ttf.Tables.get((Object)"glyf").Offset;
        this.SetPosition(offset);
        ArrayList<GlyphHeader> glyf = new ArrayList<GlyphHeader>();
        for (int i = 0; i < loca.size() - 1; ++i) {
            int multiplier = this.ttf.Head.IndexToLocFormat == 0 ? 2 : 1;
            int locaOffset = loca.get(i) * multiplier;
            this.SetPosition(offset + locaOffset);
            GlyphHeader gh = new GlyphHeader();
            gh.NumberOfContours = this.getInt16();
            gh.XMin = this.getInt16();
            gh.YMin = this.getInt16();
            gh.XMax = this.getInt16();
            gh.YMax = this.getInt16();
            glyf.add(gh);
        }
        return glyf;
    }

    private OS2 ReadOS2Table() {
        int index;
        if (!this.ttf.Tables.containsKey("OS/2")) {
            return null;
        }
        Table table = this.ttf.Tables.get("OS/2");
        int offset = table.Offset;
        this.SetPosition(offset);
        OS2 os2 = new OS2();
        os2.Version = this.getUint16();
        os2.XAvgCharWidth = this.getInt16();
        os2.UsWeightClass = this.getUint16();
        os2.UsWidthClass = this.getUint16();
        os2.FsType = this.getUint16();
        os2.YSubscriptXSize = this.getInt16();
        os2.YSubscriptYSize = this.getInt16();
        os2.YSubscriptXOffset = this.getInt16();
        os2.YSubscriptYOffset = this.getInt16();
        os2.YSuperscriptXSize = this.getInt16();
        os2.YSuperscriptYSize = this.getInt16();
        os2.YSuperscriptXOffset = this.getInt16();
        os2.YSuperscriptYOffset = this.getInt16();
        os2.YStrikeoutSize = this.getInt16();
        os2.YStrikeoutPosition = this.getInt16();
        os2.SFamilyClass = this.getInt16();
        os2.Panose = new byte[10];
        for (index = 0; index < 10; ++index) {
            os2.Panose[index] = (byte)this.getUint8();
        }
        os2.UlUnicodeRange1 = this.getUint32();
        os2.UlUnicodeRange2 = this.getUint32();
        os2.UlUnicodeRange3 = this.getUint32();
        os2.UlUnicodeRange4 = this.getUint32();
        os2.AchVendID = new byte[4];
        for (index = 0; index < 4; ++index) {
            os2.AchVendID[index] = (byte)this.getUint8();
        }
        os2.FsSelection = this.getUint16();
        os2.UsFirstCharIndex = this.getUint16();
        os2.UsLastCharIndex = this.getUint16();
        if (this.position - offset + 10 <= table.Length) {
            os2.STypoAscender = this.getInt16();
            os2.STypoDescender = this.getInt16();
            os2.STypoLineGap = this.getInt16();
            os2.UsWinAscent = this.getUint16();
            os2.UsWinDescent = this.getUint16();
        }
        if (os2.Version >= 1) {
            os2.UlCodePageRange1 = this.getUint32();
            os2.UlCodePageRange2 = this.getUint32();
        }
        if (os2.Version >= 2) {
            os2.SxHeight = this.getInt16();
            os2.SCapHeight = this.getInt16();
            os2.UsDefaultChar = this.getUint16();
            os2.UsBreakChar = this.getUint16();
            os2.UsMaxContext = this.getUint16();
        }
        if (os2.Version >= 5) {
            os2.UsLowerOpticalPointSize = this.getUint16();
            os2.UsUpperOpticalPointSize = this.getUint16();
        }
        return os2;
    }

    private int getUint8() {
        return this.data[this.position++] & 0xFF;
    }

    private int getUint16() {
        return this.getUint8() << 8 | this.getUint8();
    }

    private int getUint32() {
        return this.getUint8() << 24 | this.getUint8() << 16 | this.getUint8() << 8 | this.getUint8();
    }

    private int getInt16() {
        int number = this.getUint16();
        if ((number & 0x8000) != 0) {
            return number - 65536;
        }
        return number;
    }

    private int getInt32() {
        return this.getUint8() << 24 | this.getUint8() << 16 | this.getUint8() << 8 | this.getUint8();
    }

    private int getFWord() {
        return this.getInt16();
    }

    private int getUFWord() {
        return this.getUint16();
    }

    private int getOffset16() {
        return this.getUint16();
    }

    private int getOffset32() {
        return this.getUint32();
    }

    private int getF2Dot14() {
        return this.getInt16();
    }

    private int getFixed() {
        return this.getInt32();
    }

    private String GetString(int length) throws UnsupportedEncodingException {
        byte[] byteArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            byteArray[i] = (byte)this.getUint8();
        }
        return new String(byteArray, "UTF-8");
    }

    private String GetStringUtf16(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length / 2; ++i) {
            sb.append((char)this.getUint16());
        }
        return sb.toString();
    }

    private StiDateTime getDate() {
        int macTime = this.getUint32() * 1 + this.getUint32();
        return new StiDateTime();
    }

    private void SetPosition(int pos) {
        this.position = pos;
    }

    private int GetUInt16(int pos) {
        return this.data[pos] << 8 | this.data[pos + 1];
    }

    private int GetUInt32(int pos) {
        return this.data[pos] << 24 | this.data[pos + 1] << 16 | this.data[pos + 2] << 8 | this.data[pos + 3];
    }

    public TtfInfo Ttf() {
        return this.ttf;
    }

    public int[] Data() {
        return this.data;
    }

    public TtfInfo ReadFont(int position) throws Exception {
        this.position = position;
        this.ttf = new TtfInfo();
        this.ttf.HeaderOffset = position;
        this.ttf.SfntVersion = this.getUint32();
        this.ttf.NumTables = this.getUint16();
        this.getUint16();
        this.getUint16();
        this.getUint16();
        this.ttf.Tables = new Hashtable();
        for (int i = 0; i < this.ttf.NumTables; ++i) {
            int tag = this.getUint32();
            this.position -= 4;
            String tagString = this.GetString(4);
            Table t = new Table();
            t.Tag = tag;
            t.TagString = tagString;
            t.Checksum = this.getUint32();
            t.Offset = this.getUint32();
            t.Length = this.getUint32();
            this.ttf.Tables.put(tagString, t);
        }
        this.ttf.Head = this.ReadHeadTable();
        this.ttf.Name = this.ReadNameTable();
        this.ttf.Maxp = this.ReadMaxpTable();
        this.ttf.Hhea = this.ReadHheaTable();
        this.ttf.Hmtx = this.ReadHmtxTable(this.ttf.Hhea.NumOfLongHorMetrics, this.ttf.Maxp.NumGlyphs);
        this.ttf.Cmap = this.ReadCmapTable();
        this.ttf.OS2 = this.ReadOS2Table();
        return this.ttf;
    }

    public TtfInfo ScanFontFile(String fontName) throws Exception {
        int tag = this.GetUInt32(0);
        if (tag == 65536 || tag == 0x4F54544F) {
            return this.ReadFont(0);
        }
        int ttcVer = this.GetUInt32(4);
        if (tag == 1953784678 && (ttcVer == 65536 || ttcVer == 131072)) {
            int numFontsTtc;
            for (int indexTtc = numFontsTtc = this.GetUInt32(8); indexTtc > 0; --indexTtc) {
                int offset = this.GetUInt32(12 + (indexTtc - 1) * 4);
                int tagTtc = this.GetUInt32(offset);
                if (tagTtc != 65536 && tagTtc != 0x4F54544F) continue;
                this.ReadFont(offset);
                if (!this.ttf.Name.FontNames.containsValue(fontName)) continue;
                return this.ttf;
            }
        }
        return null;
    }

    public static TtfInfo ScanFontFile(int[] data, String fontName) throws Exception {
        StiFontReader fontReader = new StiFontReader(data);
        TtfInfo font = fontReader.ScanFontFile(fontName);
        if (font != null) {
            font.FontReader = fontReader;
        }
        return font;
    }

    public StiFontReader(int[] data) {
        this.data = data;
    }

    public class TtfInfo {
        public int HeaderOffset;
        public int SfntVersion;
        public int NumTables;
        public Hashtable<String, Table> Tables;
        public Head Head;
        public Name Name;
        public Maxp Maxp;
        public Hhea Hhea;
        public Hmtx Hmtx;
        public Cmap Cmap;
        public OS2 OS2;
        public StiFontReader FontReader = null;

        public Hashtable<Integer, Integer> GetCmapHashTable() throws Exception {
            return this.FontReader.GetCmapHashTable();
        }

        public String GetFamilyName() {
            String name;
            block0: {
                Iterator<String> iterator;
                name = this.Name.FontNames.get("1033");
                if (!StiValidationUtil.isNullOrWhiteSpace((String)name) || !(iterator = this.Name.FontNames.keySet().iterator()).hasNext()) break block0;
                String de = iterator.next();
                name = this.Name.FontNames.get(de);
            }
            return name;
        }

        public int GetStyle() {
            int fs = 0;
            if (this.OS2 != null) {
                if ((this.OS2.FsSelection & 1) > 0) {
                    fs |= 2;
                }
                if (this.OS2.UsWeightClass >= 700) {
                    fs |= 1;
                }
            }
            return fs;
        }
    }

    public class OS2 {
        public int Version;
        public int XAvgCharWidth;
        public int UsWeightClass;
        public int UsWidthClass;
        public int FsType;
        public int YSubscriptXSize;
        public int YSubscriptYSize;
        public int YSubscriptXOffset;
        public int YSubscriptYOffset;
        public int YSuperscriptXSize;
        public int YSuperscriptYSize;
        public int YSuperscriptXOffset;
        public int YSuperscriptYOffset;
        public int YStrikeoutSize;
        public int YStrikeoutPosition;
        public int SFamilyClass;
        public byte[] Panose;
        public int UlUnicodeRange1;
        public int UlUnicodeRange2;
        public int UlUnicodeRange3;
        public int UlUnicodeRange4;
        public byte[] AchVendID;
        public int FsSelection;
        public int UsFirstCharIndex;
        public int UsLastCharIndex;
        public int STypoAscender;
        public int STypoDescender;
        public int STypoLineGap;
        public int UsWinAscent;
        public int UsWinDescent;
        public int UlCodePageRange1;
        public int UlCodePageRange2;
        public int SxHeight;
        public int SCapHeight;
        public int UsDefaultChar;
        public int UsBreakChar;
        public int UsMaxContext;
        public int UsLowerOpticalPointSize;
        public int UsUpperOpticalPointSize;
    }

    public class Glyph {
        public int X;
        public int Y;
        public int Width;
        public int Height;
        public int Lsb;
        public int Rsb;

        public int getAdvanceWidth() {
            return this.Lsb + this.Width + this.Rsb;
        }
    }

    public class GlyphHeader {
        public int NumberOfContours;
        public int XMin;
        public int YMin;
        public int XMax;
        public int YMax;
    }

    public class Hmtx {
        public ArrayList<LongHorMetric> HMetrics;
        public ArrayList<Integer> LeftSideBearing;
    }

    public class LongHorMetric {
        public int AdvanceWidth;
        public int LeftSideBearing;
    }

    public class Hhea {
        public int Version;
        public int Ascent;
        public int Descent;
        public int LineGap;
        public int AdvanceWidthMax;
        public int MinLeftSideBearing;
        public int MinRightSideBearing;
        public int XMaxExtent;
        public int CaretSlopeRise;
        public int CaretSlopeRun;
        public int CaretOffset;
        public int MetricDataFormat;
        public int NumOfLongHorMetrics;
    }

    public class Maxp {
        public int Version;
        public int NumGlyphs;
        public int MaxPoints;
        public int MaxContours;
        public int MaxCompositePoints;
        public int MaxCompositeContours;
        public int MaxZones;
        public int MaxTwilightPoints;
        public int MaxStorage;
        public int MaxFunctionDefs;
        public int MaxInstructionDefs;
        public int MaxStackElements;
        public int MaxSizeOfInstructions;
        public int MaxComponentElements;
        public int MaxComponentDepth;
    }

    public class Cmap {
        public int Version;
        public int NumTables;
        public ArrayList<EncodingRecord> EncodingRecords;
        public Hashtable<Integer, Integer> GlyphIndexMap;
    }

    public class Format12 {
        public int Format;
        public int Length;
        public int Language;
        public int NumGroups;
        public ArrayList<Integer> StartCharCode;
        public ArrayList<Integer> EndCharCode;
        public ArrayList<Integer> StartGlyphId;
        public Hashtable<Integer, Integer> GlyphIndexMap;
    }

    public class Format4 {
        public int Format;
        public int Length;
        public int Language;
        public int SegCountX2;
        public int SearchRange;
        public int EntrySelector;
        public int RangeShift;
        public ArrayList<Integer> EndCode;
        public ArrayList<Integer> StartCode;
        public ArrayList<Integer> IdDelta;
        public ArrayList<Integer> IdRangeOffset;
        public Hashtable<Integer, Integer> GlyphIndexMap;
    }

    public class EncodingRecord {
        public int PlatformID;
        public int EncodingID;
        public int Offset;
    }

    public class Name {
        public int Format = 1;
        public int Count;
        public int StringOffset;
        public ArrayList<NameRecord> NameRecord;
        public int LangTagCount;
        public ArrayList<LangTagRecord> LangTagRecord;
        public Hashtable<String, String> FontNames;
    }

    public class LangTagRecord {
        public int Length;
        public int Offset;
    }

    public class NameRecord {
        public int PlatformID;
        public int EncodingID;
        public int LanguageID;
        public int NameID;
        public int Length;
        public int Offset;
        public String String;
    }

    public class Head {
        public int MajorVersion;
        public int MinorVersion;
        public int FontRevision;
        public int ChecksumAdjustment;
        public int MagicNumber;
        public int Flags;
        public int UnitsPerEm;
        public StiDateTime Created;
        public StiDateTime Modified;
        public int YMin;
        public int XMin;
        public int XMax;
        public int YMax;
        public int MacStyle;
        public int LowestRecPPEM;
        public int FontDirectionHint;
        public int IndexToLocFormat;
        public int GlyphDataFormat;
    }

    public class Table {
        public int Tag;
        public String TagString;
        public int Checksum;
        public int Offset;
        public int Length;
    }
}

