/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.drawing;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;

public class StiColorUtils {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;

    public static StiColor light(StiColor baseColor, int value) {
        int r = baseColor.getR();
        int g = baseColor.getG();
        int b = baseColor.getB();
        r = r + value > 255 ? 255 : (r += value);
        g = g + value > 255 ? 255 : (g += value);
        b = b + value > 255 ? 255 : (b += value);
        return StiColor.fromArgb(r, g, b);
    }

    public static StiColor mixingColors(StiColor color1, StiColor color2, int alpha) {
        int r = color2.r * alpha / 255 + color1.r * (255 - alpha) / 255;
        int g = color2.g * alpha / 255 + color1.g * (255 - alpha) / 255;
        int b = color2.b * alpha / 255 + color1.b * (255 - alpha) / 255;
        return StiColor.fromArgb(255, r, g, b);
    }

    public static StiColor dark(StiColor baseColor, int value) {
        int r = baseColor.getR();
        int g = baseColor.getG();
        int b = baseColor.getB();
        r = r - value < 0 ? 0 : (r -= value);
        g = g - value < 0 ? 0 : (g -= value);
        b = b - value < 0 ? 0 : (b -= value);
        return StiColor.fromArgb(r, g, b);
    }

    public static StiColor dark(StiColorEnum color, int i) {
        return StiColorUtils.dark(color.color(), i);
    }

    public static StiColor changeLightness(StiColor color, byte correctionFactor) {
        float value = (float)correctionFactor / 255.0f;
        return StiColorUtils.changeLightness(color, value);
    }

    public static StiColor changeLightness(StiColor color, float correctionFactor) {
        float red = color.r;
        float green = color.g;
        float blue = color.b;
        if (correctionFactor < 0.0f) {
            correctionFactor = 1.0f + correctionFactor;
            red *= correctionFactor;
            green *= correctionFactor;
            blue *= correctionFactor;
        } else {
            red = (255.0f - red) * correctionFactor + red;
            green = (255.0f - green) * correctionFactor + green;
            blue = (255.0f - blue) * correctionFactor + blue;
        }
        return StiColor.fromArgb(color.a, (int)Math.min(red, 255.0f), (int)Math.min(green, 255.0f), (int)Math.min(blue, 255.0f));
    }
}

