/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.utils.StiConvertHelper;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;

public class StiObjectConverter {
    public static BigDecimal ConvertToDecimal(Object value) {
        if (value == null || StiValidationUtil.isNullOrEmpty((String)value.toString())) {
            return new BigDecimal(0);
        }
        try {
            return new BigDecimal(StiObjectConverter.normalize(value));
        }
        catch (Exception e) {
            return new BigDecimal("0");
        }
    }

    public static double ConvertToDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(StiObjectConverter.normalize(value));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private static String normalize(Object value) {
        String sval = value.toString();
        int posDot = sval.indexOf(".");
        int posComma = sval.indexOf(",");
        if (posDot == -1 && posComma == -1) {
            return sval;
        }
        if (posDot != -1 && posComma != -1) {
            sval = sval.replace(posDot > posComma ? "," : ".", "");
        }
        return sval.replace('.', ',').replace(',', StiConvertHelper.DECIMAL_SEPARATOR);
    }

    public static long ConvertToInt64(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Double) {
            Double valuDouble = (Double)value;
            return valuDouble.longValue();
        }
        return (Long)value;
    }

    public static String ConvertToString(byte[] bytes) {
        if (bytes != null) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        return "";
    }
}

