/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.TestEnum;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;

public class StiEnumSet<E extends Enum<E>> {
    private EnumSet<E> enumSet;

    protected StiEnumSet() {
    }

    public StiEnumSet(E e) {
        this.enumSet = EnumSet.of(e);
    }

    private StiEnumSet(E e1, E e2) {
        this.enumSet = EnumSet.of(e1, e2);
    }

    private StiEnumSet(E e1, E e2, E e3) {
        this.enumSet = EnumSet.of(e1, e2, e3);
    }

    private StiEnumSet(E e1, E e2, E e3, E e4) {
        this.enumSet = EnumSet.of(e1, e2, e3, e4);
    }

    private StiEnumSet(E e1, E e2, E e3, E e4, E e5) {
        this.enumSet = EnumSet.of(e1, e2, e3, e4, e5);
    }

    public StiEnumSet(E first, E ... rest) {
        this.enumSet = EnumSet.of(first, rest);
    }

    public StiEnumSet(Class<E> elementType) {
        this.enumSet = EnumSet.noneOf(elementType);
    }

    public static <E extends Enum<E>> StiEnumSet<E> of(E e) {
        return new StiEnumSet<E>(e);
    }

    public static <E extends Enum<E>> StiEnumSet<E> of(E e1, E e2) {
        return new StiEnumSet<E>(e1, e2);
    }

    public static <E extends Enum<E>> StiEnumSet<E> of(E e1, E e2, E e3) {
        return new StiEnumSet<E>(e1, e2, e3);
    }

    public static <E extends Enum<E>> StiEnumSet<E> of(E e1, E e2, E e3, E e4) {
        return new StiEnumSet<E>(e1, e2, e3, e4);
    }

    public static <E extends Enum<E>> StiEnumSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return new StiEnumSet<E>(e1, e2, e3, e4, e5);
    }

    public static <E extends Enum<E>> StiEnumSet<E> of(E first, E ... rest) {
        return new StiEnumSet<E[]>((E[])first, rest);
    }

    public static <E extends Enum<E>> StiEnumSet<E> noneOf(Class<E> elementType) {
        return new StiEnumSet<E>(elementType);
    }

    public static <T extends Enum<T>> StiEnumSet<T> stringToEnums(Class<T> enumType, String value) {
        return StiEnumSet.stringToEnums(enumType, value, ",");
    }

    public static <T extends Enum<T>> StiEnumSet<T> stringToEnums(Class<T> enumType, String value, String delimiter) {
        String convertedValue = value.replace(", ", ",");
        String[] names = convertedValue.split(delimiter);
        StiEnumSet<T> result = StiEnumSet.noneOf(enumType);
        for (String enumName : names) {
            if (!StiValidationUtil.isNotNullOrEmpty((String)enumName) || "0".equals(enumName)) continue;
            result.add((IStiEnum)Enum.valueOf(enumType, enumName.trim()));
        }
        return result;
    }

    public boolean contains(IStiEnum o) {
        int intValue = this.getIntValue();
        return (intValue & o.getValue()) > 0;
    }

    public boolean notContains(IStiEnum o) {
        return !this.contains(o);
    }

    public boolean containsOnly(IStiEnum o) {
        return this.enumSet.contains(o) && this.size() == 1;
    }

    public StiEnumSet<E> OR(IStiEnum o) {
        if (!this.contains(o)) {
            this.enumSet.add((Enum)((Object)o));
        }
        return this;
    }

    public StiEnumSet<E> exclusiveOR(IStiEnum o) {
        if (this.contains(o)) {
            this.enumSet.remove(o);
        } else {
            this.enumSet.add((Enum)((Object)o));
        }
        return this;
    }

    public StiEnumSet<E> add(IStiEnum o) {
        return this.OR(o);
    }

    public void remove(IStiEnum o) {
        this.enumSet.remove(o);
    }

    public Iterator<E> iterator() {
        return this.enumSet.iterator();
    }

    public int size() {
        if (this.enumSet == null) {
            return 0;
        }
        return this.enumSet.size();
    }

    public String toString() {
        return StiStringUtil.join(this.enumSet, (String)", ");
    }

    public int getIntValue() {
        int enumIndex = 0;
        for (Enum element : this.enumSet) {
            IStiEnum stienum = (IStiEnum)((Object)element);
            enumIndex += stienum.getValue();
        }
        return enumIndex;
    }

    public int getValue() {
        return this.getIntValue();
    }

    public boolean equals(Object obj) {
        String str1 = this.toString();
        return obj != null && str1.equals(obj.toString());
    }

    public static void main(String[] args) {
        StiEnumSet<TestEnum> enumik = StiEnumSet.of(TestEnum.All);
        System.out.println(enumik.contains(TestEnum.Left));
        boolean bol = true;
        System.out.println(bol);
        int qwer = 15;
        System.out.println(qwer);
        System.out.println(qwer &= 8);
    }

    public Collection<E> collection() {
        return this.enumSet;
    }
}

