/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.blockly.helpers;

import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.helpers.FontVHelper;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StiBlocklyFontHelper {
    public static List<String> loadFonts(StiReport report) {
        String[] envfonts;
        ArrayList<String> fontNames = new ArrayList<String>();
        if (report != null) {
            List fontResource = report.getDictionary().getResources().stream().filter(r -> FontVHelper.isFont((StiResourceType)r.getType()) && r.getContent() != null).collect(Collectors.toList());
            for (StiResource resource : fontResource) {
                String name = report.getResourceFontName(resource.getName());
                fontNames.add(name);
            }
        }
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String family : envfonts = gEnv.getAvailableFontFamilyNames()) {
            fontNames.add(family);
        }
        return fontNames;
    }
}

