/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.blockly;

import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiSystemVariablesHelper;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.web.helper.StiEncodingHelper;
import com.stimulsoft.webdesigner.blockly.helpers.StiBlocklyComponentHelper;
import com.stimulsoft.webdesigner.blockly.helpers.StiBlocklyDataSourceHelper;
import com.stimulsoft.webdesigner.blockly.helpers.StiBlocklyFontHelper;
import com.stimulsoft.webdesigner.blockly.helpers.StiBlocklyVariableHelper;
import com.stimulsoft.webdesigner.blockly.parser.StiFunctionBlocksParser;
import com.stimulsoft.webdesigner.blockly.parser.StiUserFunctionBlocksParser;
import com.stimulsoft.webdesigner.helper.StiDictionaryHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class StiBlocklyHelper {
    public static String getResourceFileText(String filename) {
        String result = "";
        InputStream stream = StiBlocklyHelper.class.getResourceAsStream(String.format("/com/stimulsoft/%s", filename));
        try {
            result = StiIOUtil.toString((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getToolboxXML(StiReport report, boolean showCurrentValue, StiUserFunction userFunction) {
        String toolboxXML = StiBlocklyHelper.getResourceFileText("webdesigner/blockly/xml/BlocklyToolbox.xml");
        toolboxXML = toolboxXML.replace("<!--CurrentValue-->", showCurrentValue ? StiBlocklyHelper.getResourceFileText("webdesigner/blockly/xml/BlocklyToolboxCurrentValue.xml") : "");
        String functionXML = StiFunctionBlocksParser.getFunctionsGrouppedInCategoriesBlocks(report.getDictionary().getUserFunctions());
        toolboxXML = toolboxXML.replace("<!--Functions-->", functionXML);
        if (userFunction != null) {
            String userFunctionXML = StiUserFunctionBlocksParser.getFunctionsGrouppedInCategoriesBlocks(userFunction);
            toolboxXML = toolboxXML.replace("<!--UserFunction-->", userFunctionXML);
        }
        return toolboxXML;
    }

    public static String getBlockyWorkspaceXML(String eventValue) {
        return StiValidationUtil.isNullOrEmpty((String)eventValue) ? StiBlocklyHelper.getResourceFileText("webdesigner/blockly/xml/BlocklyWorkspace.xml") : eventValue;
    }

    public static String getSampleXML() {
        return StiBlocklyHelper.getResourceFileText("webdesigner/blockly/xml/BlocklyToolbox.xml");
    }

    public static void getBlocklyInitParameters(StiReport report, HashMap<String, Object> param, HashMap<String, Object> callbackResult) {
        String eventValue = StiEncodingHelper.decodeString((String)((String)param.get("eventValue")));
        boolean showCurrentValue = Func.Convert.toBoolean((Object)param.get("showCurrentValue"));
        StiUserFunction userFunction = null;
        if (param.containsKey("userFunction")) {
            userFunction = new StiUserFunction();
            StiDictionaryHelper.applyUserFunctionProps(report, userFunction, (HashMap)param.get("userFunction"));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("toolboxXML", StiEncodingHelper.encode((String)StiBlocklyHelper.getToolboxXML(report, showCurrentValue, userFunction)));
        params.put("workspaceXML", StiEncodingHelper.encode((String)StiBlocklyHelper.getBlockyWorkspaceXML(eventValue)));
        params.put("initBlocksJsCode", StiEncodingHelper.encode((String)StiBlocklyHelper.getInitBlocksJsCode(report, userFunction)));
        callbackResult.put("params", params);
    }

    public static String getInitBlocksJsCode(StiReport report, StiUserFunction userFunction) {
        String jsCode = StiBlocklyHelper.getResourceFileText("webdesigner/blockly/js/init_blockly_blocks.js");
        String text = StiBlocklyHelper.getDrillDownFontList(report);
        if (!StiValidationUtil.isNullOrEmpty((String)text)) {
            jsCode = jsCode.replace("[\"empty\", \"EMPTY\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownComponentList(report)))) {
            jsCode = jsCode.replace("[\"Component\", \"EMPTYCOMPONENT\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownComponentGetComponentsList(report)))) {
            jsCode = jsCode.replace("[\"ComponentGetComponents\", \"EMPTYCOMPONENTGETCOMPONENTS\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownVariableList(report)))) {
            jsCode = jsCode.replace("[\"Variable\", \"EMPTYVARIABLE\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownDataSourceList(report)))) {
            jsCode = jsCode.replace("[\"DataSource\", \"EMPTYDATASOURCE\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownSystenVariableList(report)))) {
            jsCode = jsCode.replace("[\"empty\", \"EMPTYSYSTEMVARIABLE\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownDataSourcePropertyList()))) {
            jsCode = jsCode.replace("[\"empty\", \"EMPTYDATASOURCEPROPERTY\"]", text);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)(text = StiBlocklyHelper.getDrillDownDataSourceMethodsList()))) {
            jsCode = jsCode.replace("[\"empty\", \"EMPTYDATASOURCEMETHODS\"]", text);
        }
        jsCode = jsCode.replace("/*functions*/", StiFunctionBlocksParser.getInitFunctionBlocks(report.getDictionary().getUserFunctions()));
        if (userFunction != null) {
            jsCode = jsCode.replace("/*userFunction*/", StiUserFunctionBlocksParser.getInitFunctionBlocks(userFunction));
        }
        return jsCode;
    }

    private static String getDrillDownFontList(StiReport report) {
        List<String> list = StiBlocklyFontHelper.loadFonts(report);
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownComponentList(StiReport report) {
        List<String> list = StiBlocklyComponentHelper.LoadComponents(report);
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownComponentGetComponentsList(StiReport report) {
        List<String> list = StiBlocklyComponentHelper.LoadContainerComponents(report);
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownVariableList(StiReport report) {
        List<String> list = StiBlocklyVariableHelper.LoadVariables(report);
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownDataSourceList(StiReport report) {
        List<String> list = StiBlocklyDataSourceHelper.loadDataSource(report);
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownDataSourcePropertyList() {
        List<String> list = StiBlocklyDataSourceHelper.getDataSourceProperties();
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownDataSourceMethodsList() {
        List<String> list = StiBlocklyDataSourceHelper.getDataSourceMethods();
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownSystenVariableList(StiReport report) {
        List list = StiSystemVariablesHelper.getSystemVariables((StiReport)report);
        return StiBlocklyHelper.getDrillDownOptions(list);
    }

    private static String getDrillDownOptions(List<String> list) {
        String text = "";
        int index = 1;
        for (String name : list) {
            text = text + "[\"" + name + "\",\"" + name + "\"]";
            if (index != list.size()) {
                text = text + ",";
            }
            ++index;
        }
        return text;
    }
}

