/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.StiExportManager;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.enums.StiParametersPanelPosition;
import com.stimulsoft.web.enums.StiToolbarDisplayMode;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiRequestParamsHelper;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import com.stimulsoft.web.proxyee.StiServletContext;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.helper.StiReportEdit;
import com.stimulsoft.webviewer.StiWebViewerOptions;
import com.stimulsoft.webviewer.StiWebViewerRender;
import com.stimulsoft.webviewer.enums.StiWebViewerTheme;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class StiWebDesigner {
    protected static final Logger LOG = Logger.getLogger(StiWebDesigner.class.getName());
    public static final String ACTION_GET_REPORT_TEMPLATE = "ReportTemplate";
    public static final String ACTION_OPEN_REPORT_TEMPLATE = "OpenReportTemplate";
    public static final String ACTION_SAVE_REPORT_TEMPLATE = "SaveReportTemplate";
    public static final String ACTION_SAVE_AS_REPORT_TEMPLATE = "SaveAsReportTemplate";
    public static final String ACTION_GET_NEW_REPORT_DATA = "GetNewReportData";
    public static final String ACTION_DESIGNER_EVENT = "DesignerEvent";
    public static final String ACTION_REFRESH_SESSION = "RefreshSession";
    public static final String ACTION_EXIST_DESIGNER = "ExitDesigner";
    public static final String ACTION_GET_REPORT = "GetReport";
    public static final String ACTION_EXPORT_REPORT = "ExportReport";
    public static final String ACTION_PREVIEW_REPORT = "PreviewReport";
    private static final String SESSION_ATTRIBUTE_CACHED_REPORT = "webdesigner_cached_report";
    private static final String SESSION_ATTRIBUTE_PARAMETERS = "webdesigner_params";
    public static final String SESSION_ATTRIBUTE_HANDLER = "webdesigner_handler";
    private static StiCacheHelper cacheHelper = null;

    public static StiCacheHelper getCacheHelper() {
        if (cacheHelper == null) {
            cacheHelper = new StiCacheHelper();
        }
        return cacheHelper;
    }

    public static String createViewer(StiWebDesignerOptions options, URL url, StiServletContext context, String id) throws IOException, ParserConfigurationException {
        StiWebViewerOptions viewerOptions = new StiWebViewerOptions();
        viewerOptions.setViewerIDInternal(id + "Viewer");
        viewerOptions.setLocalization(options.getLocalization());
        viewerOptions.setLocalizationStream(options.getLocalizationStream());
        viewerOptions.setTheme(StiWebViewerTheme.valueOf((String)options.getTheme().toString()));
        viewerOptions.getServer().setController(options.getServer().getController());
        viewerOptions.getServer().setRequestTimeout(options.getServer().getRequestTimeout());
        viewerOptions.getServer().setUseRelativeUrls(options.getServer().isUseRelativeUrls());
        viewerOptions.getServer().setPassQueryParametersForResources(options.getServer().isPassQueryParametersForResources());
        viewerOptions.getServer().setPassFormValues(options.getServer().isPassFormValues());
        viewerOptions.getServer().setUseCompression(options.getServer().isUseCompression());
        viewerOptions.getAppearance().setCustomCss(options.getAppearance().getCustomCss());
        viewerOptions.getAppearance().setPageBorderColor(StiColor.fromArgb((int)198, (int)198, (int)198));
        viewerOptions.getAppearance().setBackgroundColor(StiColor.fromArgb((int)241, (int)241, (int)241));
        viewerOptions.getAppearance().setFullScreenMode(true);
        viewerOptions.getAppearance().setDatePickerFirstDayOfWeek(options.getAppearance().getDatePickerFirstDayOfWeek());
        viewerOptions.getAppearance().setShowTooltips(options.getAppearance().isShowTooltips());
        viewerOptions.getAppearance().setShowTooltipsHelp(options.getAppearance().isShowTooltipsHelp());
        viewerOptions.getAppearance().setInterfaceType(options.getAppearance().getInterfaceType());
        viewerOptions.getAppearance().setReportDisplayMode(options.getAppearance().getReportDisplayMode());
        viewerOptions.getAppearance().setShowPageShadow(false);
        viewerOptions.getAppearance().setParametersPanelPosition(StiParametersPanelPosition.Left);
        viewerOptions.getAppearance().setParametersPanelColumnsCount(1);
        viewerOptions.getEmail().setShowEmailDialog(options.Email.isShowEmailDialog());
        viewerOptions.getEmail().setShowExportDialog(options.Email.isShowExportDialog());
        viewerOptions.getEmail().setDefaultEmailAddress(options.Email.getDefaultEmailAddress());
        viewerOptions.getEmail().setDefaultEmailSubject(options.Email.getDefaultEmailSubject());
        viewerOptions.getEmail().setDefaultEmailMessage(options.Email.getDefaultEmailMessage());
        viewerOptions.getExports().setDefaultSettings(options.Exports.defaultSettings);
        viewerOptions.getExports().setStoreExportSettings(options.Exports.storeExportSettings);
        viewerOptions.getExports().setShowExportDialog(options.Exports.showExportDialog);
        viewerOptions.getExports().setShowExportToDocument(options.Exports.showExportToDocument);
        viewerOptions.getExports().setShowExportToPdf(options.Exports.showExportToPdf);
        viewerOptions.getExports().setShowExportToXps(options.Exports.showExportToXps);
        viewerOptions.getExports().setShowExportToHtml(options.Exports.showExportToHtml);
        viewerOptions.getExports().setShowExportToMht(options.Exports.showExportToMht);
        viewerOptions.getExports().setShowExportToText(options.Exports.showExportToText);
        viewerOptions.getExports().setShowExportToRtf(options.Exports.showExportToRtf);
        viewerOptions.getExports().setShowExportToWord2007(options.Exports.showExportToWord);
        viewerOptions.getExports().setShowExportToOpenDocumentWriter(options.Exports.showExportToOpenDocumentWriter);
        viewerOptions.getExports().setShowExportToExcel(options.Exports.showExportToExcel);
        viewerOptions.getExports().setShowExportToExcelXml(options.Exports.showExportToExcelXml);
        viewerOptions.getExports().setShowExportToExcelBiff(options.Exports.showExportToExcelBiff);
        viewerOptions.getExports().setShowExportToOpenDocumentCalc(options.Exports.showExportToOpenDocumentCalc);
        viewerOptions.getExports().setShowExportToCsv(options.Exports.showExportToCsv);
        viewerOptions.getExports().setShowExportToXml(options.Exports.showExportToXml);
        viewerOptions.getExports().setShowExportToSylk(options.Exports.showExportToSylk);
        viewerOptions.getExports().setShowExportToImageBmp(options.Exports.showExportToImageBmp);
        viewerOptions.getExports().setShowExportToImageJpeg(options.Exports.showExportToImageJpeg);
        viewerOptions.getExports().setShowExportToImagePcx(options.Exports.showExportToImagePcx);
        viewerOptions.getExports().setShowExportToImagePng(options.Exports.showExportToImagePng);
        viewerOptions.getExports().setShowExportToImageSvg(options.Exports.showExportToImageSvg);
        viewerOptions.getExports().setShowExportToImageSvgz(options.Exports.showExportToImageSvgz);
        viewerOptions.getToolbar().setDisplayMode(StiToolbarDisplayMode.Separated);
        viewerOptions.getToolbar().setVisible(options.PreviewToolbar.isVisible());
        viewerOptions.getToolbar().setBackgroundColor(options.PreviewToolbar.getBackgroundColor());
        viewerOptions.getToolbar().setBorderColor(options.PreviewToolbar.getBorderColor());
        viewerOptions.getToolbar().setFontColor(options.PreviewToolbar.getFontColor());
        viewerOptions.getToolbar().setFontFamily(options.PreviewToolbar.getFontFamily());
        viewerOptions.getToolbar().setAlignment(options.PreviewToolbar.getAlignment());
        viewerOptions.getToolbar().setShowButtonCaptions(options.PreviewToolbar.isShowButtonCaptions());
        viewerOptions.getToolbar().setShowPrintButton(options.PreviewToolbar.isShowPrintButton());
        viewerOptions.getToolbar().setShowOpenButton(options.PreviewToolbar.isShowOpenButton());
        viewerOptions.getToolbar().setShowSaveButton(options.PreviewToolbar.isShowSaveButton());
        viewerOptions.getToolbar().setShowSendEmailButton(options.PreviewToolbar.isShowSendEmailButton());
        viewerOptions.getToolbar().setShowFindButton(options.PreviewToolbar.isShowFindButton());
        viewerOptions.getToolbar().setShowBookmarksButton(options.PreviewToolbar.isShowBookmarksButton());
        viewerOptions.getToolbar().setShowParametersButton(options.PreviewToolbar.isShowParametersButton());
        viewerOptions.getToolbar().setShowEditorButton(options.PreviewToolbar.isShowEditorButton());
        viewerOptions.getToolbar().setShowDesignButton(false);
        viewerOptions.getToolbar().setShowAboutButton(false);
        viewerOptions.getToolbar().setShowFullScreenButton(false);
        viewerOptions.getToolbar().setShowFirstPageButton(options.PreviewToolbar.isShowFirstPageButton());
        viewerOptions.getToolbar().setShowPreviousPageButton(options.PreviewToolbar.isShowPreviousPageButton());
        viewerOptions.getToolbar().setShowCurrentPageControl(options.PreviewToolbar.isShowCurrentPageControl());
        viewerOptions.getToolbar().setShowNextPageButton(options.PreviewToolbar.isShowNextPageButton());
        viewerOptions.getToolbar().setShowLastPageButton(options.PreviewToolbar.isShowLastPageButton());
        viewerOptions.getToolbar().setShowZoomButton(options.PreviewToolbar.isShowZoomButton());
        viewerOptions.getToolbar().setShowViewModeButton(options.PreviewToolbar.isShowViewModeButton());
        viewerOptions.getToolbar().setPrintDestination(options.PreviewToolbar.getPrintDestination());
        viewerOptions.getToolbar().setViewMode(options.PreviewToolbar.getViewMode());
        StiWebViewerRender viewer = new StiWebViewerRender(viewerOptions, url, true);
        viewer.setReportDesignerMode(true);
        String result = viewer.getViewer(url, context);
        return result;
    }

    public static String getActionCommandName(StiHttpServletRequest httpContext, JSONObject jsonObject) throws JSONException {
        return (String)jsonObject.get("command");
    }

    public static StiReport saveReportObject(StiHttpServletRequest httpContext, StiReport report, String reportGuid) {
        if (report != null) {
            StiCacheOptions.cache.storeObject(httpContext, (Object)report, reportGuid);
        }
        return report;
    }

    public static StiReport getReportObject(StiHttpServletRequest httpContext, StiRequestParams requestParams) {
        if (requestParams != null && requestParams.id != null) {
            return (StiReport)StiCacheOptions.cache.getObject(httpContext, requestParams.id);
        }
        return null;
    }

    public static void setupDesign(StiReport report) {
        if (report != null) {
            report.getInfo().setForceDesigningMode(true);
            report.setIsSerializing(false);
            report.setIsRendered(false);
        }
    }

    public static Object getHandler(StiHttpServletRequest request, StiRequestParams requestParams) throws JSONException {
        return StiCacheOptions.cache.getObject(request, requestParams.id + SESSION_ATTRIBUTE_HANDLER);
    }

    public static HashMap<String, Object> getReportSnapshotCallbackResult(HashMap<String, Object> callbackResult, StiHttpServletRequest httpContext, StiReport report, HashMap<String, Object> parameters) throws StiException, IOException, SAXException, StiDeserializationException, JSONException {
        StiReportEdit.getPreviewPages(report, parameters, callbackResult);
        return callbackResult;
    }

    public static HashMap<String, Object> getNewReportCallbackResult(HashMap<String, Object> callbackResult, StiHttpServletRequest httpContext, StiReport report, HashMap<String, Object> parameters) throws Exception {
        String reportGuid = StiWebDesigner.getNewGuid();
        StiWebDesigner.saveReportObject(httpContext, report, reportGuid);
        callbackResult.put("reportGuid", reportGuid);
        String command = (String)parameters.get("command");
        if ("CreateReport".equals(command)) {
            callbackResult.put("reportObject", StiReportEdit.writeReportInObject(report));
        }
        return callbackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String previewAs(StiReport mainReport, JSONObject parameters, StiHttpServletResponse response) throws JSONException, StiException, IOException, SAXException, StiDeserializationException {
        StiReport report = StiReportEdit.cloneReport(mainReport, true);
        report.Render(false);
        report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        String result = null;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            if ("pdf".equals(parameters.getString("format"))) {
                StiExportManager.exportPdf((StiReport)report, (OutputStream)stream);
                new StiWebActionResult(stream, "Report.pdf", "application/pdf", false).writeFile(response);
            } else {
                StiHtmlExportSettings settings = new StiHtmlExportSettings();
                StiHtmlExportService service = new StiHtmlExportService();
                service.exportHtml(report, (OutputStream)stream, settings);
                result = new String(stream.toByteArray(), "UTF-8");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void previewReport(StiReport mainReport, String format, StiHttpServletResponse response) throws IOException, SAXException, StiDeserializationException, StiException {
        StiReport report = StiReportEdit.cloneReport(mainReport, true);
        report.Render(false);
        report = report.getCompiledReport() != null ? report.getCompiledReport() : report;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            if ("pdf".equals(format)) {
                StiExportManager.exportPdf((StiReport)report, (OutputStream)stream);
                new StiWebActionResult(stream, "Report.pdf", "application/pdf", true).writeFile(response);
            } else {
                StiHtmlExportSettings settings = new StiHtmlExportSettings();
                StiHtmlExportService service = new StiHtmlExportService();
                service.exportHtmlWithoutEvents(report, (OutputStream)stream, settings);
                StiIOUtil.writeString((OutputStream)response.getOutputStream(), (String)new String(stream.toByteArray(), "UTF-8"));
            }
        }
    }

    public static String getNewGuid() {
        return StiGuid.newGuidString().substring(0, 16);
    }

    public static StiRequestParams createRequestParams(StiWebDesignerOptions options, String id, String clientGuid) {
        StiRequestParams requestParams = new StiRequestParams();
        requestParams.action = StiAction.GetReport;
        requestParams.component = StiComponentType.Designer;
        requestParams.id = id;
        requestParams.cache.timeout = 1;
        requestParams.cache.clientGuid = clientGuid;
        requestParams.cache.helper = StiWebDesigner.getCacheHelper();
        requestParams.server.useRelativeUrls = options.getServer().isUseRelativeUrls();
        requestParams.server.useCompression = options.getServer().isUseCompression();
        requestParams.server.passQueryParametersForResources = options.getServer().isPassQueryParametersForResources();
        return requestParams;
    }

    public static StiRequestParams getRequestParams(StiHttpServletRequest httpContext, StiHttpServletResponse response) throws IOException, JSONException {
        StiRequestParams requestParams = StiRequestParamsHelper.get((StiHttpServletRequest)httpContext, (StiHttpServletResponse)response, null);
        return requestParams;
    }
}

