/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.stiblocks.functions;

import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import com.stimulsoft.blockly.stiblocks.functions.StiBlocklyFunctionBlockKeyCache;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiUserFunctionArgument;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import java.util.ArrayList;
import java.util.HashMap;

public class StiFunctionRun
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        Object functionObj = StiBlocklyFunctionBlockKeyCache.getFunction(this.getType(), context.getReport().getDictionary().getUserFunctions());
        if (functionObj instanceof StiFunction) {
            StiFunction function = (StiFunction)functionObj;
            return this.evaluateFunction(function, context);
        }
        if (functionObj instanceof StiUserFunction) {
            StiUserFunction userFunction = (StiUserFunction)functionObj;
            return this.evaluateUserFunction(userFunction, context);
        }
        return null;
    }

    private Object evaluateFunction(StiFunction function, Context context) {
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (int index = 0; index < function.getArgumentNames().length; ++index) {
            Object value;
            String arg = function.getArgumentNames()[index];
            StiSystemType type = function.getArgumentTypes()[index];
            Object valueArg = value = this.getValues().evaluate(arg, context);
            argValues.add(valueArg);
        }
        return function.invoke(argValues);
    }

    private Object evaluateUserFunction(StiUserFunction userFunction, Context context) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (int index = 0; index < userFunction.getArguments().size(); ++index) {
            Object value;
            StiUserFunctionArgument argument = (StiUserFunctionArgument)userFunction.getArguments().get(index);
            Object valueArg = value = this.getValues().evaluate(argument.getName(), context);
            arguments.put(argument.getName(), valueArg);
        }
        return StiBlocklyHelper.invokeUserFunctionBlockly((StiReport)context.getReport(), (StiUserFunction)userFunction, arguments);
    }
}

