/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.maths;

import com.stimulsoft.blockly.StiObjConverter;
import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;

public class MathSingle
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        String op = this.getFields().get("OP");
        double number = StiObjConverter.toDouble(this.getValues().evaluate("NUM", context));
        switch (op) {
            case "ROOT": {
                return Math.sqrt(number);
            }
            case "ABS": {
                return Math.abs(number);
            }
            case "NEG": {
                return -1.0 * number;
            }
            case "LN": {
                return Math.log(number);
            }
            case "LOG10": {
                return Math.log10(number);
            }
            case "EXP": {
                return Math.exp(number);
            }
            case "POW10": {
                return Math.pow(10.0, number);
            }
            case "SIN": {
                return Math.sin(number / 180.0 * Math.PI);
            }
            case "COS": {
                return Math.cos(number / 180.0 * Math.PI);
            }
            case "TAN": {
                return Math.tan(number / 180.0 * Math.PI);
            }
            case "ASIN": {
                return Math.asin(number);
            }
            case "ACOS": {
                return Math.acos(number);
            }
            case "ATAN": {
                return Math.atan(number);
            }
        }
        throw new RuntimeException(String.format("Unknown OP %1$s", op));
    }
}

