/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.maths;

import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;

public class MathOnList
extends IronBlock {
    private static Random rnd = new Random();

    @Override
    public Object evaluate(Context context) {
        String op = this.getFields().get("OP");
        Iterable list = (Iterable)this.getValues().evaluate("LIST", context);
        DoubleStream doubleList = StreamSupport.stream(list.spliterator(), false).mapToDouble(d -> (Double)d);
        switch (op) {
            case "SUM": {
                return doubleList.sum();
            }
            case "MIN": {
                return doubleList.min();
            }
            case "MAX": {
                return doubleList.max();
            }
            case "AVERAGE": {
                return doubleList.average();
            }
            case "MEDIAN": {
                return this.median(doubleList);
            }
            case "RANDOM": {
                return doubleList.findAny().isPresent() ? Double.valueOf(doubleList.toArray()[rnd.nextInt((int)doubleList.count())]) : null;
            }
            case "MODE": {
                if (doubleList.count() == 0L) {
                    return null;
                }
                Map counted = StreamSupport.stream(list.spliterator(), false).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                double max = counted.keySet().stream().mapToDouble(d -> (Double)d).max().getAsDouble();
                return counted.get(max);
            }
            case "STD_DEV": {
                throw new UnsupportedOperationException(String.format("OP %1$s not implemented", op));
            }
        }
        throw new RuntimeException(String.format("Unknown OP %1$s", op));
    }

    private Object median(DoubleStream values) {
        if (values.count() == 0L) {
            return null;
        }
        double[] sortedValues = values.sorted().toArray();
        double mid = (double)(sortedValues.length - 1) / 2.0;
        return (sortedValues[(int)mid] + sortedValues[(int)(mid + 0.5)]) / 2.0;
    }
}

