/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.maths;

import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;

public class MathNumberProperty
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        String op = this.getFields().get("PROPERTY");
        double number = (Double)this.getValues().evaluate("NUMBER_TO_CHECK", context);
        switch (op) {
            case "EVEN": {
                return 0.0 == number % 2.0;
            }
            case "ODD": {
                return 1.0 == number % 2.0;
            }
            case "PRIME": {
                return MathNumberProperty.isPrime((int)number);
            }
            case "WHOLE": {
                return 0.0 == number % 1.0;
            }
            case "POSITIVE": {
                return number > 0.0;
            }
            case "NEGATIVE": {
                return number < 0.0;
            }
            case "DIVISIBLE_BY": {
                return 0.0 == number % (Double)this.getValues().evaluate("DIVISOR", context);
            }
        }
        throw new RuntimeException(String.format("Unknown PROPERTY %1$s", op));
    }

    private static boolean isPrime(int number) {
        if (number == 1) {
            return false;
        }
        if (number == 2) {
            return true;
        }
        if (number % 2 == 0) {
            return false;
        }
        int boundary = (int)Math.floor(Math.sqrt(number));
        for (int i = 3; i <= boundary; i += 2) {
            if (number % i != 0) continue;
            return false;
        }
        return true;
    }
}

