/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.maths;

import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;

public class MathConstant
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        String constant = this.getFields().get("CONSTANT");
        return MathConstant.getValue(constant);
    }

    private static double getValue(String constant) {
        switch (constant) {
            case "PI": {
                return Math.PI;
            }
            case "E": {
                return Math.E;
            }
            case "GOLDEN_RATIO": {
                return (1.0 + Math.sqrt(5.0)) / 2.0;
            }
            case "SQRT2": {
                return Math.sqrt(2.0);
            }
            case "SQRT1_2": {
                return Math.sqrt(0.5);
            }
            case "INFINITY": {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw new RuntimeException(String.format("Unknown CONSTANT %1$s", constant));
    }
}

