/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly;

import com.stimulsoft.blockly.blocks.controls.ControlsFlowStatement;
import com.stimulsoft.blockly.blocks.controls.ControlsFor;
import com.stimulsoft.blockly.blocks.controls.ControlsForEach;
import com.stimulsoft.blockly.blocks.controls.ControlsIf;
import com.stimulsoft.blockly.blocks.controls.ControlsRepeatExt;
import com.stimulsoft.blockly.blocks.controls.ControlsWhileUntil;
import com.stimulsoft.blockly.blocks.lists.ListsCreateWith;
import com.stimulsoft.blockly.blocks.lists.ListsGetIndex;
import com.stimulsoft.blockly.blocks.lists.ListsIndexOf;
import com.stimulsoft.blockly.blocks.lists.ListsIsEmpty;
import com.stimulsoft.blockly.blocks.lists.ListsLength;
import com.stimulsoft.blockly.blocks.lists.ListsRepeat;
import com.stimulsoft.blockly.blocks.lists.ListsSplit;
import com.stimulsoft.blockly.blocks.logic.LogicBoolean;
import com.stimulsoft.blockly.blocks.logic.LogicCompare;
import com.stimulsoft.blockly.blocks.logic.LogicNegate;
import com.stimulsoft.blockly.blocks.logic.LogicNull;
import com.stimulsoft.blockly.blocks.logic.LogicOperation;
import com.stimulsoft.blockly.blocks.logic.LogicTernary;
import com.stimulsoft.blockly.blocks.maths.MathArithmetic;
import com.stimulsoft.blockly.blocks.maths.MathConstant;
import com.stimulsoft.blockly.blocks.maths.MathConstrain;
import com.stimulsoft.blockly.blocks.maths.MathModulo;
import com.stimulsoft.blockly.blocks.maths.MathNumber;
import com.stimulsoft.blockly.blocks.maths.MathNumberProperty;
import com.stimulsoft.blockly.blocks.maths.MathOnList;
import com.stimulsoft.blockly.blocks.maths.MathRandomFloat;
import com.stimulsoft.blockly.blocks.maths.MathRandomInt;
import com.stimulsoft.blockly.blocks.maths.MathRound;
import com.stimulsoft.blockly.blocks.maths.MathSingle;
import com.stimulsoft.blockly.blocks.procedures.ProceduresCallNoReturn;
import com.stimulsoft.blockly.blocks.procedures.ProceduresCallReturn;
import com.stimulsoft.blockly.blocks.procedures.ProceduresDef;
import com.stimulsoft.blockly.blocks.procedures.ProceduresIfReturn;
import com.stimulsoft.blockly.blocks.text.ColourBlend;
import com.stimulsoft.blockly.blocks.text.ColourPicker;
import com.stimulsoft.blockly.blocks.text.ColourRandom;
import com.stimulsoft.blockly.blocks.text.ColourRgb;
import com.stimulsoft.blockly.blocks.text.TextAppend;
import com.stimulsoft.blockly.blocks.text.TextBlock;
import com.stimulsoft.blockly.blocks.text.TextCaseChange;
import com.stimulsoft.blockly.blocks.text.TextIndexOf;
import com.stimulsoft.blockly.blocks.text.TextIsEmpty;
import com.stimulsoft.blockly.blocks.text.TextJoin;
import com.stimulsoft.blockly.blocks.text.TextLength;
import com.stimulsoft.blockly.blocks.text.TextPrompt;
import com.stimulsoft.blockly.blocks.text.TextTrim;
import com.stimulsoft.blockly.blocks.variables.VariablesGet;
import com.stimulsoft.blockly.blocks.variables.VariablesSet;
import com.stimulsoft.blockly.model.Field;
import com.stimulsoft.blockly.model.IronBlock;
import com.stimulsoft.blockly.model.Mutation;
import com.stimulsoft.blockly.model.Statement;
import com.stimulsoft.blockly.model.Value;
import com.stimulsoft.blockly.model.Workspace;
import com.stimulsoft.blockly.stiblocks.data.StiDataSourceGetData;
import com.stimulsoft.blockly.stiblocks.data.StiDataSourceGetDataByColumnName;
import com.stimulsoft.blockly.stiblocks.data.StiDataSourceMethod;
import com.stimulsoft.blockly.stiblocks.data.StiDataSourceProperty;
import com.stimulsoft.blockly.stiblocks.data.StiGetDataSource;
import com.stimulsoft.blockly.stiblocks.data.StiGetDataSourceByName;
import com.stimulsoft.blockly.stiblocks.data.StiRefreshViewer;
import com.stimulsoft.blockly.stiblocks.data.StiResetAllFilters;
import com.stimulsoft.blockly.stiblocks.data.StiSetDataSourceSqlCommand;
import com.stimulsoft.blockly.stiblocks.functions.StiBlocklyFunctionBlockKeyCache;
import com.stimulsoft.blockly.stiblocks.functions.StiFunctionRun;
import com.stimulsoft.blockly.stiblocks.objects.StiGetComponent;
import com.stimulsoft.blockly.stiblocks.objects.StiGetComponentByName;
import com.stimulsoft.blockly.stiblocks.objects.StiGetCurrentValue;
import com.stimulsoft.blockly.stiblocks.objects.StiGetPropertyOfObject;
import com.stimulsoft.blockly.stiblocks.objects.StiGetStyleByName;
import com.stimulsoft.blockly.stiblocks.objects.StiSetCurrentValue;
import com.stimulsoft.blockly.stiblocks.objects.StiSetPropertyOfObjectTo;
import com.stimulsoft.blockly.stiblocks.objects.StiSetPropertyToValue;
import com.stimulsoft.blockly.stiblocks.process.StiOpenLink;
import com.stimulsoft.blockly.stiblocks.report.StiAllComponents;
import com.stimulsoft.blockly.stiblocks.report.StiAllComponentsFrom;
import com.stimulsoft.blockly.stiblocks.report.StiThisComponent;
import com.stimulsoft.blockly.stiblocks.report.StiThisReport;
import com.stimulsoft.blockly.stiblocks.system.StiIsFirstPass;
import com.stimulsoft.blockly.stiblocks.system.StiIsSecondPass;
import com.stimulsoft.blockly.stiblocks.userfunctions.StiUserFunctionArgument;
import com.stimulsoft.blockly.stiblocks.userfunctions.StiUserFunctionReturn;
import com.stimulsoft.blockly.stiblocks.variables.StiGetVariable;
import com.stimulsoft.blockly.stiblocks.variables.StiGetVariableByName;
import com.stimulsoft.blockly.stiblocks.variables.StiSetVariable;
import com.stimulsoft.blockly.stiblocks.variables.StiSystemVariable;
import com.stimulsoft.blockly.stiblocks.visuals.StiColorARGB;
import com.stimulsoft.blockly.stiblocks.visuals.StiColorHex;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewBorder;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewBrush;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewCornerRadius;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewFont;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewGradientBrush;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewMargin;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewPadding;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewPenStyle;
import com.stimulsoft.blockly.stiblocks.visuals.StiNewSolidBrush;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiUserFunction;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Parser {
    private Map<String, Class<? extends IronBlock>> blocks = new HashMap<String, Class<? extends IronBlock>>();

    public final Parser addBlock(Class<? extends IronBlock> blockFactory, String type) {
        this.blocks.put(type, blockFactory);
        return this;
    }

    public final Workspace parse(String xml) {
        try {
            return this.parse(xml, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Workspace parse(String xml, boolean preserveWhitespace) throws ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xdoc = builder.parse(StiIOUtil.toInputStream((String)xml));
        Workspace workspace = new Workspace();
        NodeList childNodes = xdoc.getDocumentElement().getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            IronBlock block;
            Node node = childNodes.item(i);
            if (!"block".equals(node.getNodeName()) && !"shadow".equals(node.getNodeName()) || null == (block = this.parseBlock(node))) continue;
            workspace.getBlocks().add(block);
        }
        return workspace;
    }

    public final IronBlock parseBlock(Node node) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (node.getAttributes().getNamedItem("disabled") != null && !Boolean.parseBoolean(node.getAttributes().getNamedItem("disabled").getTextContent())) {
            return null;
        }
        String type = node.getAttributes().getNamedItem("type").getTextContent();
        if (!this.blocks.containsKey(type)) {
            throw new RuntimeException(String.format("block type not registered: '%s'", type));
        }
        IronBlock block = this.blocks.get(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        block.setType(type);
        block.setId(node.getAttributes().getNamedItem("id").getTextContent());
        NodeList childNodes = node.getChildNodes();
        block16: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            switch (childNode.getNodeName()) {
                case "mutation": {
                    this.parseMutation(childNode, block);
                    continue block16;
                }
                case "field": {
                    this.parseField(childNode, block);
                    continue block16;
                }
                case "value": {
                    this.parseValue(childNode, block);
                    continue block16;
                }
                case "statement": {
                    this.parseStatement(childNode, block);
                    continue block16;
                }
                case "comment": {
                    continue block16;
                }
                case "next": {
                    IronBlock nextBlock = this.parseBlock(childNode.getFirstChild());
                    if (null == nextBlock) continue block16;
                    block.setNext(nextBlock);
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unknown xml type: %s", childNode.getNodeName()));
                }
            }
        }
        return block;
    }

    public final void parseField(Node fieldNode, IronBlock block) {
        Field field = new Field();
        field.setName(fieldNode.getAttributes().getNamedItem("name").getTextContent());
        field.setValue(fieldNode.getTextContent());
        block.getFields().add(field);
    }

    public final void parseValue(Node valueNode, IronBlock block) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Node childNode = null;
        for (int i = 0; i < valueNode.getChildNodes().getLength(); ++i) {
            Node child = valueNode.getChildNodes().item(i);
            if ("block".equals(child.getNodeName())) {
                childNode = child;
            }
            if (!"shadow".equals(child.getNodeName()) || childNode != null) continue;
            childNode = child;
        }
        if (childNode == null) {
            return;
        }
        IronBlock childBlock = this.parseBlock(childNode);
        Value value = new Value();
        value.setName(valueNode.getAttributes().getNamedItem("name").getTextContent());
        value.setBlock(childBlock);
        block.getValues().add(value);
    }

    public final void parseStatement(Node statementNode, IronBlock block) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Node childNode = null;
        for (int i = 0; i < statementNode.getChildNodes().getLength(); ++i) {
            Node child = statementNode.getChildNodes().item(i);
            if ("block".equals(child.getNodeName())) {
                childNode = child;
            }
            if (!"shadow".equals(child.getNodeName()) || childNode != null) continue;
            childNode = child;
        }
        if (childNode == null) {
            return;
        }
        IronBlock childBlock = this.parseBlock(childNode);
        Statement statement = new Statement();
        statement.setName(statementNode.getAttributes().getNamedItem("name").getTextContent());
        statement.setBlock(childBlock);
        block.getStatements().add(statement);
    }

    public final void parseMutation(Node mutationNode, IronBlock block) {
        int i;
        for (i = 0; i < mutationNode.getAttributes().getLength(); ++i) {
            Node attribute = mutationNode.getAttributes().item(i);
            block.getMutations().add(new Mutation("mutation", attribute.getNodeName(), attribute.getNodeValue()));
        }
        for (i = 0; i < mutationNode.getChildNodes().getLength(); ++i) {
            Node node = mutationNode.getChildNodes().item(i);
            for (int j = 0; j < node.getAttributes().getLength(); ++j) {
                Node attribute = node.getAttributes().item(j);
                block.getMutations().add(new Mutation(node.getNodeName(), attribute.getNodeName(), attribute.getNodeValue()));
            }
        }
    }

    public Parser addStandardBlocks(StiReport report) {
        this.addBlock(ControlsRepeatExt.class, "controls_repeat_ext");
        this.addBlock(ControlsIf.class, "controls_if");
        this.addBlock(ControlsWhileUntil.class, "controls_whileUntil");
        this.addBlock(ControlsFlowStatement.class, "controls_flow_statements");
        this.addBlock(ControlsForEach.class, "controls_forEach");
        this.addBlock(ControlsFor.class, "controls_for");
        this.addBlock(LogicCompare.class, "logic_compare");
        this.addBlock(LogicBoolean.class, "logic_boolean");
        this.addBlock(LogicNegate.class, "logic_negate");
        this.addBlock(LogicOperation.class, "logic_operation");
        this.addBlock(LogicNull.class, "logic_null");
        this.addBlock(LogicTernary.class, "logic_ternary");
        this.addBlock(MathArithmetic.class, "math_arithmetic");
        this.addBlock(MathNumber.class, "math_number");
        this.addBlock(MathSingle.class, "math_single");
        this.addBlock(MathSingle.class, "math_trig");
        this.addBlock(MathRound.class, "math_round");
        this.addBlock(MathConstant.class, "math_constant");
        this.addBlock(MathNumberProperty.class, "math_number_property");
        this.addBlock(MathOnList.class, "math_on_list");
        this.addBlock(MathConstrain.class, "math_constrain");
        this.addBlock(MathModulo.class, "math_modulo");
        this.addBlock(MathRandomFloat.class, "math_random_float");
        this.addBlock(MathRandomInt.class, "math_random_int");
        this.addBlock(TextBlock.class, "text");
        this.addBlock(TextPrompt.class, "text_prompt_ext");
        this.addBlock(TextLength.class, "text_length");
        this.addBlock(TextIsEmpty.class, "text_isEmpty");
        this.addBlock(TextTrim.class, "text_trim");
        this.addBlock(TextCaseChange.class, "text_changeCase");
        this.addBlock(TextAppend.class, "text_append");
        this.addBlock(TextJoin.class, "text_join");
        this.addBlock(TextIndexOf.class, "text_indexOf");
        this.addBlock(VariablesGet.class, "variables_get");
        this.addBlock(VariablesSet.class, "variables_set");
        this.addBlock(ColourPicker.class, "colour_picker");
        this.addBlock(ColourRandom.class, "colour_random");
        this.addBlock(ColourRgb.class, "colour_rgb");
        this.addBlock(ColourBlend.class, "colour_blend");
        this.addBlock(ProceduresDef.class, "procedures_defnoreturn");
        this.addBlock(ProceduresDef.class, "procedures_defreturn");
        this.addBlock(ProceduresCallNoReturn.class, "procedures_callnoreturn");
        this.addBlock(ProceduresCallReturn.class, "procedures_callreturn");
        this.addBlock(ProceduresIfReturn.class, "procedures_ifreturn");
        this.addBlock(ListsSplit.class, "lists_split");
        this.addBlock(ListsCreateWith.class, "lists_create_with");
        this.addBlock(ListsLength.class, "lists_length");
        this.addBlock(ListsRepeat.class, "lists_repeat");
        this.addBlock(ListsIsEmpty.class, "lists_isEmpty");
        this.addBlock(ListsGetIndex.class, "lists_getIndex");
        this.addBlock(ListsIndexOf.class, "lists_indexOf");
        this.addBlock(StiColorHex.class, "sti_color_hex");
        this.addBlock(StiColorARGB.class, "sti_color_argb");
        this.addBlock(StiNewFont.class, "sti_new_font");
        this.addBlock(StiNewBrush.class, "sti_new_brush");
        this.addBlock(StiNewSolidBrush.class, "sti_new_solid_brush");
        this.addBlock(StiNewGradientBrush.class, "sti_new_gradient_brush");
        this.addBlock(StiNewBorder.class, "sti_new_border");
        this.addBlock(StiNewPenStyle.class, "sti_new_pen_style");
        this.addBlock(StiNewMargin.class, "sti_new_margin");
        this.addBlock(StiNewPadding.class, "sti_new_padding");
        this.addBlock(StiNewCornerRadius.class, "sti_new_corner_radius");
        this.addBlock(StiGetDataSource.class, "sti_get_data_source");
        this.addBlock(StiGetDataSourceByName.class, "sti_get_data_source_by_name");
        this.addBlock(StiDataSourceProperty.class, "sti_data_source_property");
        this.addBlock(StiDataSourceMethod.class, "sti_data_source_method");
        this.addBlock(StiSetDataSourceSqlCommand.class, "sti_set_data_source_sql_command");
        this.addBlock(StiDataSourceGetDataByColumnName.class, "sti_data_source_get_data_by_column_name");
        this.addBlock(StiDataSourceGetData.class, "sti_data_source_get_data");
        this.addBlock(StiGetVariable.class, "sti_get_variable");
        this.addBlock(StiGetVariableByName.class, "sti_get_variable_by_name");
        this.addBlock(StiSetVariable.class, "sti_set_variable");
        this.addBlock(StiSystemVariable.class, "sti_system_variable");
        this.addBlock(StiThisReport.class, "sti_this_report");
        this.addBlock(StiThisComponent.class, "sti_this_component");
        this.addBlock(StiAllComponents.class, "sti_all_components");
        this.addBlock(StiAllComponentsFrom.class, "sti_all_components_from");
        this.addBlock(StiGetCurrentValue.class, "sti_get_current_value");
        this.addBlock(StiSetCurrentValue.class, "sti_set_current_value");
        this.addBlock(StiGetComponentByName.class, "sti_get_component_by_name");
        this.addBlock(StiSetPropertyToValue.class, "sti_set_property_to_value");
        this.addBlock(StiOpenLink.class, "sti_open_link");
        this.addBlock(StiRefreshViewer.class, "sti_refresh_viewer");
        this.addBlock(StiResetAllFilters.class, "sti_reset_all_filters");
        this.addBlock(StiIsFirstPass.class, "sti_is_first_pass");
        this.addBlock(StiIsSecondPass.class, "sti_is_second_pass");
        this.addBlock(StiGetComponent.class, "sti_get_component");
        this.addBlock(StiSetPropertyOfObjectTo.class, "sti_set_property_of_object_to");
        this.addBlock(StiGetPropertyOfObject.class, "sti_get_property_of_object");
        this.addBlock(StiGetStyleByName.class, "sti_get_style_by_name");
        for (String key : StiBlocklyFunctionBlockKeyCache.getBlockKeyTable(report.getDictionary().getUserFunctions()).keySet()) {
            this.addBlock(StiFunctionRun.class, key);
        }
        return this;
    }

    public Parser addUserFunctionBlocks(StiUserFunction userFunction) {
        this.addBlock(StiUserFunctionReturn.class, "sti_return_user_function_block");
        for (com.stimulsoft.report.dictionary.StiUserFunctionArgument arg : userFunction.getArguments()) {
            this.addBlock(StiUserFunctionArgument.class, String.format("sti_user_function_argument_%s", arg.getName()));
        }
        return this;
    }

    public Parser addUserFunctionBlocks(Map<String, Object> arguments) {
        this.addBlock(StiUserFunctionReturn.class, "sti_return_user_function_block");
        for (String arg : arguments.keySet()) {
            this.addBlock(StiUserFunctionArgument.class, String.format("sti_user_function_argument_%s", arg));
        }
        return this;
    }
}

