/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.print;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiGraphicsHelper;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiMargins;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.painters.StiPaintArgs;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class StiPagePrintable
implements Printable {
    private StiPage page;
    private double pageWidth;
    private double pageHeight;
    private int segmentX = -1;
    private int segmentY = -1;

    public StiPagePrintable(StiPage page) {
        this.page = page;
    }

    public StiPagePrintable(StiPage page, int segmentX, int segmentY, double pageWidth, double pageHeight) {
        this(page);
        this.segmentX = segmentX;
        this.segmentY = segmentY;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.page != null) {
            StiGraphics stiGraphics = new StiGraphics(graphics);
            Graphics2D graphics2d = (Graphics2D)graphics;
            graphics2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            StiGraphicsHelper.setRenderingHints((Graphics2D)graphics2d);
            graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.page.getReport().getInfo().setPageZoom(1.0);
            this.page.getReport().getInfo().setZoom(StiAttribute.RENDER_QUALITY);
            if (this.segmentX >= 0 || this.segmentY >= 0) {
                Double widthStep = this.page.getUnit().ConvertToHInches(this.page.getWidth() / (double)this.page.getSegmentPerWidth());
                Double heightStep = this.page.getUnit().ConvertToHInches(this.page.getHeight() / (double)this.page.getSegmentPerHeight());
                graphics2d.translate(-widthStep.doubleValue() * (double)this.segmentX, -heightStep.doubleValue() * (double)this.segmentY);
                StiMargins margins = this.page.getMargins();
                Double clipTop = this.segmentY == 0 ? 0.0 : this.page.getUnit().ConvertToHInches(margins.getTop());
                Double clipLeft = this.segmentX == 0 ? 0.0 : this.page.getUnit().ConvertToHInches(margins.getLeft());
                Double clipBottom = this.page.getUnit().ConvertToHInches((this.segmentY == this.page.getSegmentPerHeight() - 1 || this.segmentY == 0 ? margins.getTop() : 0.0) + (this.segmentY == this.page.getSegmentPerHeight() - 1 ? margins.getBottom() : 0.0));
                Double clipRight = this.page.getUnit().ConvertToHInches((this.segmentX == this.page.getSegmentPerWidth() - 1 || this.segmentX == 0 ? margins.getLeft() : 0.0) + (this.segmentX == this.page.getSegmentPerWidth() - 1 ? margins.getRight() : 0.0));
                stiGraphics.setClip(new StiRectangle(widthStep * (double)this.segmentX + clipLeft, heightStep * (double)this.segmentY + clipTop, widthStep + clipRight, heightStep + clipBottom));
            }
            double scale = Math.min(pageFormat.getImageableWidth() / this.pageWidth, pageFormat.getImageableHeight() / this.pageHeight);
            graphics2d.scale(scale / StiAttribute.RENDER_QUALITY, scale / StiAttribute.RENDER_QUALITY);
            this.page.paint(new StiPaintArgs(stiGraphics, this.segmentX, this.segmentY));
            graphics2d.scale(StiAttribute.RENDER_QUALITY / scale, StiAttribute.RENDER_QUALITY / scale);
        }
        return 0;
    }
}

