/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.cell;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiRectangle;

public class StiColumnSparklinesCellPainter {
    public static void draw(StiContext context, StiRectangle rect, double[] array, StiColor positiveColor, StiColor negativeColor) {
        if (array == null || array.length == 0) {
            return;
        }
        rect.inflate(-2, -2);
        double[] values = array;
        double min = values[0];
        for (double i : values) {
            min = Math.min(i, min);
        }
        double max = values[0];
        for (double i : values) {
            max = Math.max(i, max);
        }
        double rMin = min;
        if (min > 0.0) {
            double[] svalues = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                svalues[i] = values[i] - min;
            }
            values = svalues;
            max -= min;
            min = 0.0;
        }
        if (max < 0.0) {
            double[] svalues = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                svalues[i] = values[i] + -max;
            }
            values = svalues;
            min += -max;
            max = 0.0;
        }
        double stepWidth = rect.width / (double)values.length;
        double totalHeight = max + Math.abs(min);
        double maxPart = rect.height * max / totalHeight;
        double x = rect.x;
        double barWidth = stepWidth;
        if (barWidth < 1.0) {
            barWidth = 1.0;
        }
        for (double value : values) {
            StiColor color = positiveColor;
            if (value < 0.0) {
                color = negativeColor;
            }
            double valuePart = rect.height * Math.abs(value) / totalHeight;
            StiRectangle barRect = new StiRectangle(x, rect.y + (value > 0.0 ? maxPart - valuePart : maxPart), barWidth, valuePart);
            if (value == 0.0) {
                if (rMin > 0.0) {
                    barRect.y -= 1.0;
                }
                barRect.height = 1.0;
            }
            if (barRect.width > 5.0) {
                barRect.inflate(-1, 0);
            }
            x += stepWidth;
            context.FillRectangle((Object)color, (double)((float)barRect.x), (double)((float)barRect.y), (double)((float)barRect.width), (double)((float)barRect.height), null);
        }
    }
}

