/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.drawing.path.StiPathClose;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathCubicBezier;
import com.stimulsoft.base.helper.StiSvgHelper;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.helpers.StiAbbreviationNumberFormatHelper;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapData;
import com.stimulsoft.report.maps.StiMapLoader;
import com.stimulsoft.report.maps.StiMapSvg;
import com.stimulsoft.report.maps.StiMapSvgContainer;
import com.stimulsoft.report.maps.enums.StiDisplayNameType;
import com.stimulsoft.report.maps.enums.StiMapSource;
import com.stimulsoft.report.maps.enums.StiMapType;
import com.stimulsoft.report.maps.helpers.StiMapHelper;
import com.stimulsoft.report.painters.context.map.StiBezierMapGeom;
import com.stimulsoft.report.painters.context.map.StiBeziersMapGeom;
import com.stimulsoft.report.painters.context.map.StiLineMapGeom;
import com.stimulsoft.report.painters.context.map.StiMapGeom;
import com.stimulsoft.report.painters.context.map.StiMapGeomsContainer;
import com.stimulsoft.report.painters.context.map.StiMapGeomsObject;
import com.stimulsoft.report.painters.context.map.StiMoveToMapGeom;
import com.stimulsoft.report.styles.StiMapStyle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class StiGdiMapContextPainter {
    public float individualStep = 0.0f;
    private StiMap map;
    private double pageZoom;
    private double zoom;
    private StiBrush DefaultBrush;
    private StiBrush DefaultBrush1;
    private HeatmapInfo heatmapInfo;
    private HeatmapWithGroupInfo heatmapWithGroupInfo;
    private NoneInfo noneInfo;
    private HashMap<String, StiMapGroup> hashGroup = new HashMap();
    private StiStyleColorsContainer colorsContainer = new StiStyleColorsContainer();
    public List<StiMapData> mapData;
    public boolean isBorderEmpty;
    public StiMapStyle mapStyle;
    public DataTable dataTable;
    public List<String> checkedMapKeys;
    public String mouseOverKey;

    public void render(StiGraphics graphics, boolean useZoom) throws Exception {
        StiRectangle rect = this.map.getPaintRectangle(true, true);
        this.render(graphics, useZoom, rect, true);
    }

    public StiBrush getGeomBrush(StiMapData data) {
        if (this.map.getMapType() == StiMapType.Individual) {
            if (this.map.isColorEach()) {
                if (data == null) {
                    return new StiSolidBrush(this.mapStyle.getDefaultColor());
                }
                StiBrush brush = StiGdiMapContextPainter.parseHexColor(data.getColor());
                if (brush != null) {
                    return brush;
                }
                return new StiSolidBrush(this.noneInfo.GetBrush().getColor());
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)this.mapStyle.getIndividualColor(), (float)this.individualStep));
        }
        switch (this.map.getMapType()) {
            case Individual: {
                return this.DefaultBrush;
            }
            case Heatmap: {
                if (data == null || data.getValue() == null) {
                    return this.DefaultBrush;
                }
                return this.heatmapInfo.getBrush(data);
            }
            case Group: {
                return data != null && data.getGroup() != null && this.hashGroup.containsKey(data.getGroup()) ? this.hashGroup.get((Object)data.getGroup()).Fill : new StiSolidBrush(this.mapStyle.getDefaultColor());
            }
            case HeatmapWithGroup: {
                if (data == null || data.getGroup() == null) {
                    return new StiSolidBrush(this.mapStyle.getDefaultColor());
                }
                return this.heatmapWithGroupInfo.getBrush(data);
            }
        }
        return this.DefaultBrush;
    }

    public StiBrush GetGeomBrush1(StiMapData data) {
        if (this.map.getMapType() == StiMapType.Individual) {
            if (this.map.isColorEach()) {
                if (data == null) {
                    return new StiSolidBrush(this.mapStyle.getDefaultColor());
                }
                StiBrush brush = StiGdiMapContextPainter.parseHexColor(data.getColor());
                if (brush != null) {
                    return brush;
                }
                return new StiSolidBrush(this.noneInfo.GetBrush().getColor());
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)this.mapStyle.getIndividualColor(), (float)this.individualStep));
        }
        switch (this.map.getMapType()) {
            case Individual: {
                return this.DefaultBrush1;
            }
            case Heatmap: {
                if (data.getValue() == null) {
                    return this.DefaultBrush1;
                }
                return this.heatmapInfo.getBrush1(data);
            }
            case Group: {
                return data.getGroup() != null && this.hashGroup.containsKey(data.getGroup()) ? this.hashGroup.get((Object)data.getGroup()).Fill1 : new StiSolidBrush(this.mapStyle.getDefaultColor());
            }
            case HeatmapWithGroup: {
                if (data.getGroup() == null) {
                    return new StiSolidBrush(this.mapStyle.getDefaultColor());
                }
                return this.heatmapWithGroupInfo.getBrush1(data);
            }
        }
        return this.DefaultBrush1;
    }

    private List<Object> getDataTableValues(int column) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (DataRow row : this.dataTable.getRows()) {
            list.add(row.getValue(column));
        }
        return list;
    }

    public void prepareDataColumns() throws UnsupportedEncodingException, JSONException, IOException {
        if (this.map.getDataFrom() == StiMapSource.Manual) {
            this.mapData = this.map.GetMapData();
            return;
        }
        this.mapData = StiMap.getDefaultMapData(this.map.getMapID());
        List<Object> keyValues = null;
        List<Object> nameValues = null;
        List<Object> valueValues = null;
        List<Object> groupValues = null;
        List<Object> colorValues = null;
        if (this.dataTable != null) {
            int index = 0;
            if (!StiValidationUtil.isNullOrEmpty((String)this.map.getKeyDataColumn())) {
                keyValues = this.getDataTableValues(index);
                ++index;
            }
            if (!StiValidationUtil.isNullOrEmpty((String)this.map.getNameDataColumn())) {
                nameValues = this.getDataTableValues(index);
                ++index;
            }
            if (!StiValidationUtil.isNullOrEmpty((String)this.map.getValueDataColumn())) {
                valueValues = this.getDataTableValues(index);
                ++index;
            }
            if (!StiValidationUtil.isNullOrEmpty((String)this.map.getGroupDataColumn())) {
                groupValues = this.getDataTableValues(index);
                ++index;
            }
            if (!StiValidationUtil.isNullOrEmpty((String)this.map.getColorDataColumn())) {
                colorValues = this.getDataTableValues(index);
                ++index;
            }
        } else {
            try {
                if (!this.map.getReport().getIsDesigning()) {
                    this.map.getReport().getDictionary().connect();
                }
            }
            catch (Exception index) {
                // empty catch block
            }
        }
        if (keyValues == null) {
            return;
        }
        try {
            int min = 0;
            if (keyValues != null) {
                if (min == 0) {
                    min = keyValues.size();
                } else if (keyValues.size() < min) {
                    min = keyValues.size();
                }
            }
            if (nameValues != null) {
                if (min == 0) {
                    min = nameValues.size();
                } else if (nameValues.size() < min) {
                    min = nameValues.size();
                }
            }
            if (valueValues != null) {
                if (min == 0) {
                    min = valueValues.size();
                } else if (valueValues.size() < min) {
                    min = valueValues.size();
                }
            }
            if (groupValues != null) {
                if (min == 0) {
                    min = groupValues.size();
                } else if (groupValues.size() < min) {
                    min = groupValues.size();
                }
            }
            if (colorValues != null) {
                if (min == 0) {
                    min = colorValues.size();
                } else if (colorValues.size() < min) {
                    min = colorValues.size();
                }
            }
            if (keyValues != null) {
                for (StiMapData data : this.mapData) {
                    data.setGroup(null);
                    data.setValue(null);
                    if (colorValues == null) continue;
                    data.setColor(null);
                }
                for (int index = 0; index < min; ++index) {
                    String key = null;
                    if (keyValues.get(index) == null || StiValidationUtil.isNullOrEmpty((String)(key = keyValues.get(index).toString()))) continue;
                    key = key.toLowerCase();
                    StiMapData data = null;
                    for (StiMapData md : this.mapData) {
                        if (!StiValidationUtil.equals((Object)md.getKey().toLowerCase(), (Object)key)) continue;
                        data = md;
                    }
                    if (data == null) continue;
                    if (nameValues != null && nameValues.get(index) != null) {
                        String name = nameValues.get(index).toString();
                        data.setName(name);
                    }
                    if (valueValues != null && valueValues.get(index) != null) {
                        String value = valueValues.get(index).toString();
                        data.setValue(value);
                    }
                    if (groupValues != null && groupValues.get(index) != null) {
                        String group = groupValues.get(index).toString();
                        data.setGroup(group);
                    }
                    if (colorValues == null || colorValues.get(index) == null) continue;
                    String color = colorValues.get(index).toString();
                    data.setColor(color);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawState(StiGraphics g, List<StiPathCommand> path, String key, double zoom, double pageZoom) {
        if (this.checkedMapKeys != null && this.checkedMapKeys.contains(key)) {
            StiHatchBrush fill = new StiHatchBrush(StiHatchStyle.WideUpwardDiagonal, StiColor.FromArgb((int)100, (StiColor)StiColor.White), StiColor.Transparent);
            g.drawPath(path, null, (StiBrush)fill, zoom, pageZoom);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void render(StiGraphics g, boolean useZoom, StiRectangle rect, boolean center) throws Exception {
        float individualStepValue;
        this.mapStyle = StiMap.getMapStyle(this.map);
        this.prepareDataColumns();
        this.updateGroupedData();
        this.heatmapInfo = new HeatmapInfo(this, this.map, this.mapData);
        this.noneInfo = new NoneInfo();
        this.updateHeatmapWithGroup();
        StiMapGeomsContainer geomContainer = StiMapLoader.getGeomsObject(this.map.getMapID().toString());
        boolean skipLabels = false;
        AffineTransform transform = (AffineTransform)g.getG().getTransform().clone();
        double zoom = 1.0;
        if (useZoom && this.map.isStretch()) {
            zoom = Math.min(rect.width / geomContainer.Width, rect.height / geomContainer.Height);
            if (zoom == 0.0) {
                zoom = 1.0;
            }
            if (zoom < (double)0.2f) {
                skipLabels = true;
            }
            g.getG().translate(g.getOffsetX(), g.getOffsetY());
            g.getG().scale(zoom, zoom);
            g.setOffset(-g.getOffsetX().doubleValue(), -g.getOffsetY().doubleValue());
            if (center) {
                double destWidth = rect.width / zoom;
                double destHeight = rect.height / zoom;
                g.getG().translate((float)((destWidth - geomContainer.Width) / 2.0), (float)((destHeight - geomContainer.Height) / 2.0));
            }
        }
        this.DefaultBrush = new StiSolidBrush(this.mapStyle.getDefaultColor());
        this.DefaultBrush1 = new StiSolidBrush(this.mapStyle.getDefaultColor());
        ArrayList<String> hashLabels = new ArrayList<String>();
        this.individualStep = individualStepValue = 0.5f / (float)geomContainer.Geoms.size();
        Collections.sort(geomContainer.Geoms, new Comparator<StiMapGeomsObject>(){

            @Override
            public int compare(StiMapGeomsObject o1, StiMapGeomsObject o2) {
                return o1 != null && o1.Key != null ? o1.Key.compareTo(o2.Key) : -1;
            }
        });
        for (StiMapGeomsObject geoms : geomContainer.Geoms) {
            ArrayList<Object> path = new ArrayList<StiPathCommand>();
            StiPoint lastPoint = StiPoint.getEmpty();
            StiMapData data = null;
            for (StiMapData stiMapData : this.mapData) {
                if (!StiValidationUtil.equals((Object)stiMapData.getKey(), (Object)geoms.Key)) continue;
                data = stiMapData;
            }
            StiBrush fill = this.getGeomBrush(data);
            this.individualStep += individualStepValue;
            block23: for (StiMapGeom geom : geoms.Geoms) {
                switch (geom.getGeomType()) {
                    case MoveTo: {
                        StiPen pen;
                        if (path.size() > 0) {
                            path.add(new StiPathClose());
                            pen = null;
                            if (!this.isBorderEmpty) {
                                pen = new StiPen(this.mapStyle.getBorderColor(), this.mapStyle.getBorderSize() / zoom);
                            }
                            g.drawPath(path, pen, fill, zoom, this.pageZoom);
                            path.clear();
                        }
                        StiMoveToMapGeom moveTo = (StiMoveToMapGeom)geom;
                        lastPoint = new StiPoint(moveTo.X, moveTo.Y);
                        path.add((StiPathCommand)StiPathCommand.moveTo((Double)moveTo.X, (Double)moveTo.Y));
                        break;
                    }
                    case Line: {
                        StiLineMapGeom line = (StiLineMapGeom)geom;
                        StiPoint point = new StiPoint(line.X, line.Y);
                        path.add(StiPathCommand.lineTo((Double)point.x, (Double)point.y));
                        lastPoint = point;
                        break;
                    }
                    case Bezier: {
                        StiBezierMapGeom bezier = (StiBezierMapGeom)geom;
                        StiPoint point1 = new StiPoint(bezier.X1, bezier.Y1);
                        StiPoint point2 = new StiPoint(bezier.X2, bezier.Y2);
                        StiPoint point3 = new StiPoint(bezier.X3, bezier.Y3);
                        path.add((StiPathCommand)new StiPathCubicBezier(lastPoint.x, lastPoint.y, point1.x, point1.y, point2.x, point2.y, point3.x, point3.y));
                        lastPoint = point3;
                        break;
                    }
                    case Beziers: {
                        StiBeziersMapGeom beziers = (StiBeziersMapGeom)geom;
                        ArrayList<StiPoint> list = new ArrayList<StiPoint>();
                        list.add(lastPoint);
                        StiPoint p = StiPoint.getEmpty();
                        for (int index = 0; index < beziers.Array.length; index += 2) {
                            p = new StiPoint(beziers.Array[index].doubleValue(), beziers.Array[index + 1].doubleValue());
                            list.add(p);
                        }
                        list.add(p);
                        lastPoint = p;
                        for (int i = 0; i < list.size(); i += 4) {
                            if (i == 0) {
                                path.add(new StiPathCubicBezier(((StiPoint)list.get((int)i)).x, ((StiPoint)list.get((int)i)).y, ((StiPoint)list.get((int)(i + 1))).x, ((StiPoint)list.get((int)(i + 1))).y, ((StiPoint)list.get((int)(i + 2))).x, ((StiPoint)list.get((int)(i + 2))).y, ((StiPoint)list.get((int)(i + 3))).x, ((StiPoint)list.get((int)(i + 3))).y));
                                continue;
                            }
                            double dx = ((StiPoint)list.get((int)(i - 1))).x - ((StiPoint)list.get((int)(i - 2))).x;
                            double dy = ((StiPoint)list.get((int)(i - 1))).y - ((StiPoint)list.get((int)(i - 2))).y;
                            path.add(new StiPathCubicBezier(((StiPoint)list.get((int)(i - 1))).x, ((StiPoint)list.get((int)(i - 1))).y, ((StiPoint)list.get((int)(i - 1))).x + dx, ((StiPoint)list.get((int)(i - 1))).y + dy, ((StiPoint)list.get((int)i)).x, ((StiPoint)list.get((int)i)).y, ((StiPoint)list.get((int)(i + 1))).x, ((StiPoint)list.get((int)(i + 1))).y));
                        }
                        continue block23;
                    }
                    case Close: {
                        path.add(new StiPathClose());
                        StiPen pen = null;
                        if (!this.isBorderEmpty) {
                            pen = new StiPen(this.mapStyle.getBorderColor(), this.mapStyle.getBorderSize() / zoom);
                        }
                        g.drawPath(path, pen, fill, zoom, this.pageZoom);
                        path = null;
                        path = new ArrayList();
                    }
                }
            }
            if (path.size() > 0) {
                void var18_25;
                path.add(new StiPathClose());
                Object var18_23 = null;
                if (!this.isBorderEmpty) {
                    StiPen stiPen = new StiPen(this.mapStyle.getBorderColor(), this.mapStyle.getBorderSize() / zoom);
                }
                g.drawPath(path, (StiPen)var18_25, fill, zoom, this.pageZoom);
                this.drawState(g, path, geoms.Key, zoom, this.pageZoom);
            }
            if (!this.map.isShowValue() && this.map.getDisplayNameType() == StiDisplayNameType.None) continue;
            hashLabels.add(geoms.Key);
        }
        if (hashLabels.size() > 0 && !skipLabels) {
            StiMapSvgContainer svgContainer = StiMapLoader.loadResource(this.map.getMapID().toString());
            StiFont typeface = new StiFont("Calibri", 18.0);
            StiSolidBrush foregroundDark = new StiSolidBrush(StiColor.fromArgb((int)255, (int)37, (int)37, (int)37));
            StiSolidBrush foregroundLight = new StiSolidBrush(StiColor.fromArgb((int)180, (int)251, (int)251, (int)251));
            for (String key : hashLabels) {
                StiMapSvg stiMapSvg = svgContainer.hashPaths.get(key);
                if (stiMapSvg.skipText) continue;
                String text = null;
                StiMapData info = null;
                for (StiMapData md : this.mapData) {
                    if (!StiValidationUtil.equals((Object)md.getKey(), (Object)key)) continue;
                    info = md;
                }
                switch (this.map.getDisplayNameType()) {
                    case Full: {
                        text = info != null ? info.getName() : stiMapSvg.englishName;
                        break;
                    }
                    case Short: {
                        text = StiMapHelper.prepareIsoCode(stiMapSvg.ISOCode);
                    }
                }
                if (!this.map.isShowValue()) continue;
                if (info != null && info.getValue() != null) {
                    String valueStr = null;
                    if (this.map.isShortValue()) {
                        double resValue = 0.0;
                        try {
                            resValue = Double.parseDouble(info.getValue());
                            valueStr = StiAbbreviationNumberFormatHelper.format(resValue);
                        }
                        catch (Exception dx) {
                            // empty catch block
                        }
                        if (valueStr == null) {
                            valueStr = info.getValue();
                        }
                        if (text == null) {
                            text = valueStr;
                        } else {
                            text = text + "\n";
                            text = text + valueStr;
                        }
                    }
                }
                if (StiValidationUtil.isNullOrEmpty((String)text)) continue;
                StiRectangle bounds = stiMapSvg.rect;
                StiSize textSize = stiMapSvg.setMaxWidth ? StiTextUtil.measureString((double)bounds.width, (StiFont)typeface, (String)text, (float)1.0f, (float)0.0f) : StiTextUtil.measureString((double)bounds.width, (StiFont)typeface, (String)text, (float)1.0f, (float)0.0f);
                int x = (int)(bounds.x + (double)((int)((bounds.width - textSize.width) / 2.0)));
                int y = (int)(bounds.y + (double)((int)((bounds.height - textSize.height) / 2.0)));
                if (stiMapSvg.horAlignment != null) {
                    switch (stiMapSvg.horAlignment) {
                        case Left: {
                            x = (int)bounds.x;
                            break;
                        }
                        case Right: {
                            x = (int)bounds.getRight() - (int)textSize.width;
                        }
                    }
                }
                if (stiMapSvg.vertAlignment != null) {
                    switch (stiMapSvg.vertAlignment) {
                        case Top: {
                            y = (int)bounds.y;
                            break;
                        }
                        case Bottom: {
                            y = (int)bounds.getBottom() - (int)textSize.height;
                        }
                    }
                }
                if (stiMapSvg.setMaxWidth) {
                    StiRectangle rectDark = new StiRectangle((double)x, (double)y, textSize.width + 20.0, textSize.height);
                    StiRectangle rectLight = new StiRectangle((double)(x + 1), (double)(y + 1), textSize.width + 20.0, textSize.height);
                    g.drawText(text, rectLight, typeface, (StiBrush)foregroundLight, StiTextHorAlignment.Left, StiVertAlignment.Top, Boolean.valueOf(false), 1.0f, Double.valueOf(zoom), StiPenStyle.None, null, null);
                    g.drawText(text, rectDark, typeface, (StiBrush)foregroundDark, StiTextHorAlignment.Left, StiVertAlignment.Top, Boolean.valueOf(false), 1.0f, Double.valueOf(zoom), StiPenStyle.None, null, null);
                    continue;
                }
                g.drawText(text, new StiRectangle((long)(x + 1), (long)(y + 1), 100000L, 100000L), typeface, (StiBrush)foregroundLight, StiTextHorAlignment.Left, StiVertAlignment.Top, Boolean.valueOf(false), 1.0f, Double.valueOf(zoom), StiPenStyle.None, null, null);
                g.drawText(text, new StiRectangle((long)x, (long)y, 100000L, 100000L), typeface, (StiBrush)foregroundDark, StiTextHorAlignment.Left, StiVertAlignment.Top, Boolean.valueOf(false), 1.0f, Double.valueOf(zoom), StiPenStyle.None, null, null);
            }
        }
        g.getG().setTransform(transform);
        if (useZoom && this.map.isStretch()) {
            g.clearOffset();
        }
    }

    private void fillGroupColors() {
        this.colorsContainer.Init(this.map);
        ArrayList<String> keys = new ArrayList<String>(this.hashGroup.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            StiMapGroup value = this.hashGroup.get(key);
            value.Fill = this.colorsContainer.getColor();
            value.Fill1 = this.colorsContainer.getColor();
        }
    }

    public void updateHeatmapWithGroup() {
        if (this.map.getMapType() == StiMapType.HeatmapWithGroup) {
            this.heatmapWithGroupInfo = new HeatmapWithGroupInfo(this, this.map, this.mapData);
        }
    }

    public void updateGroupedData() {
        if (this.mapData != null) {
            for (StiMapData data : this.mapData) {
                if (StiValidationUtil.isNullOrEmpty((String)data.getGroup())) continue;
                Double value = null;
                double result = 0.0;
                if (data.getValue() != null) {
                    try {
                        result = Double.parseDouble(data.getValue());
                        value = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                StiMapGroup group = null;
                if (!this.hashGroup.containsKey(data.getGroup())) {
                    group = new StiMapGroup();
                    group.MinValue = value;
                    group.MaxValue = value;
                    this.hashGroup.put(data.getGroup(), group);
                    continue;
                }
                group = this.hashGroup.get(data.getGroup());
                if (value == null) continue;
                if (group.MinValue == null || group.MaxValue == null) {
                    group.MinValue = 0.0;
                    group.MaxValue = 0.0;
                }
                if (group.MinValue > value) {
                    group.MinValue = value;
                    continue;
                }
                if (!(group.MaxValue < value)) continue;
                group.MaxValue = value;
            }
            this.fillGroupColors();
        }
    }

    private static StiBrush parseHexColor(String color) {
        try {
            if (!StiValidationUtil.isNullOrEmpty((String)color)) {
                if (color.startsWith("#")) {
                    return new StiSolidBrush(StiColor.fromHtml((String)color));
                }
                return new StiSolidBrush(StiSvgHelper.getColor((String)color));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public StiGdiMapContextPainter(StiMap map, double zoom, double pageZoom) {
        this.map = map;
        this.pageZoom = pageZoom;
        this.zoom = zoom;
    }

    private class NoneInfo {
        private List<StiColor> colors = StiMapHelper.getColors();
        private int index = 0;

        public StiSolidBrush GetBrush() {
            StiColor color = this.colors.get(this.index);
            ++this.index;
            if (this.index >= this.colors.size()) {
                this.index = 0;
            }
            return new StiSolidBrush(color);
        }
    }

    private class HeatmapWithGroupInfo {
        private StiGdiMapContextPainter painter;
        private HashMap<String, double[]> hash = new HashMap();
        private HashMap<String, StiColor> hashColors = new HashMap();

        public StiBrush getBrush(StiMapData data) {
            if (data.getGroup() == null) {
                return null;
            }
            if (!this.hash.containsKey(data.getGroup())) {
                return this.painter.DefaultBrush;
            }
            double[] values = this.hash.get(data.getGroup());
            StiColor color = this.hashColors.get(data.getGroup());
            if (values[0] == values[1]) {
                return new StiSolidBrush(color);
            }
            double value = 0.0;
            if (data.getValue() == null) {
                return this.painter.DefaultBrush;
            }
            try {
                value = Double.parseDouble(data.getValue());
            }
            catch (Exception e) {
                return this.painter.DefaultBrush;
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)color, (float)((float)((double)0.85f * (values[1] - value) / (values[1] - values[0])))));
        }

        public StiBrush getBrush1(StiMapData data) {
            if (data.getGroup() == null) {
                return null;
            }
            if (!this.hash.containsKey(data.getGroup())) {
                return this.painter.DefaultBrush1;
            }
            double[] values = this.hash.get(data.getGroup());
            StiColor color = this.hashColors.get(data.getGroup());
            if (values[0] == values[1]) {
                return new StiSolidBrush(color);
            }
            double value = 0.0;
            if (data.getValue() == null) {
                return this.painter.DefaultBrush1;
            }
            try {
                value = Double.parseDouble(data.getValue());
            }
            catch (Exception e) {
                return this.painter.DefaultBrush1;
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)color, (float)((float)((double)0.85f * (values[1] - value) / (values[1] - values[0])))));
        }

        public HeatmapWithGroupInfo(StiGdiMapContextPainter painter, StiMap map, List<StiMapData> mapData) {
            this.painter = painter;
            List<StiColor> colors = StiMap.getMapStyle(map).getHeatmapColors();
            int index = 0;
            for (StiMapData data : mapData) {
                double[] values;
                String key = data.getGroup();
                if (key == null || data.getValue() == null) continue;
                double value = 0.0;
                try {
                    value = Double.parseDouble(data.getValue());
                }
                catch (Exception e) {
                    continue;
                }
                if (!this.hash.containsKey(key)) {
                    values = new double[]{value, value};
                    this.hash.put(key, values);
                } else {
                    values = this.hash.get(key);
                    if (value < values[0]) {
                        values[0] = value;
                    } else if (value > values[1]) {
                        values[1] = value;
                    }
                }
                if (this.hashColors.containsKey(key)) continue;
                StiColor color = colors.get(index);
                if (++index >= colors.size()) {
                    index = 0;
                }
                this.hashColors.put(key, color);
            }
        }
    }

    private class HeatmapInfo {
        private StiGdiMapContextPainter painter;
        private double min;
        private double max;
        private List<StiColor> colors;

        public StiBrush getBrush(StiMapData data) {
            if (this.min == this.max) {
                return new StiSolidBrush(this.colors.get(0));
            }
            double value = 0.0;
            if (data.getValue() == null) {
                return this.painter.DefaultBrush;
            }
            try {
                value = Double.parseDouble(data.getValue());
            }
            catch (Exception e) {
                return this.painter.DefaultBrush;
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)this.colors.get(0), (float)((float)(0.85 * (this.max - value) / (this.max - this.min)))));
        }

        public StiBrush getBrush1(StiMapData data) {
            if (this.min == this.max) {
                return new StiSolidBrush(this.colors.get(0));
            }
            double value = 0.0;
            if (data.getValue() == null) {
                return this.painter.DefaultBrush1;
            }
            try {
                value = Double.parseDouble(data.getValue());
            }
            catch (Exception e) {
                return this.painter.DefaultBrush1;
            }
            return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)this.colors.get(0), (float)((float)(0.85 * (this.max - value) / (this.max - this.min)))));
        }

        public HeatmapInfo(StiGdiMapContextPainter painter, StiMap map, List<StiMapData> mapData) {
            this.painter = painter;
            boolean isFirst = true;
            for (StiMapData data : mapData) {
                if (data.getValue() == null) continue;
                double value = 0.0;
                try {
                    value = Double.parseDouble(data.getValue());
                }
                catch (Exception e) {
                    continue;
                }
                if (isFirst) {
                    isFirst = false;
                    this.min = value;
                    this.max = value;
                    continue;
                }
                if (value < this.min) {
                    this.min = value;
                    continue;
                }
                if (!(value > this.max)) continue;
                this.max = value;
            }
            StiMapStyle mapStyle = StiMap.getMapStyle(map);
            this.colors = mapStyle.getHeatmapColors();
        }
    }

    private class StiStyleColorsContainer {
        private List<StiColor> stackColors = new ArrayList<StiColor>();
        private int index = 0;

        private StiStyleColorsContainer() {
        }

        public StiBrush getColor() {
            StiSolidBrush brush = new StiSolidBrush(this.stackColors.get(this.index));
            ++this.index;
            if (this.index >= this.stackColors.size()) {
                this.index = 0;
            }
            return brush;
        }

        public StiBrush getColor1() {
            StiSolidBrush brush = new StiSolidBrush(this.stackColors.get(this.index));
            ++this.index;
            if (this.index >= this.stackColors.size()) {
                this.index = 0;
            }
            return brush;
        }

        public void Init(StiMap map) {
            this.stackColors.clear();
            List<StiColor> colors = map.getCurrentStyleColors();
            this.index = 0;
            for (StiColor color : colors) {
                this.stackColors.add(color);
            }
        }
    }

    private class StiMapGroup {
        public Double MinValue;
        public Double MaxValue;
        public StiBrush Fill;
        public StiBrush Fill1;

        private StiMapGroup() {
        }
    }
}

