/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.path.StiPathArc;
import com.stimulsoft.base.drawing.path.StiPathClose;
import com.stimulsoft.base.drawing.path.StiPathCommand;
import com.stimulsoft.base.drawing.path.StiPathLine;
import com.stimulsoft.base.drawing.path.StiPathPie;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.helpers.StiDrawingHelper;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.StiGaugeGeomType;
import com.stimulsoft.report.painters.context.gauge.geoms.StiEllipseGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsArcGeometryGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathArcGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLineGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPieGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiPushMatrixGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRadialRangeGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRectangleGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiRoundedRectangleGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiTextGaugeGeom;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class StiGdiGaugeContextPainter
extends StiGaugeContextPainter {
    private StiGraphics g;
    private Stack<AffineTransform> states = new Stack();
    private int t = 0;

    @Override
    public StiSize measureString(String text, StiFont font) {
        return StiTextUtil.measureString((StiFont)font, (String)text, (float)1.0f);
    }

    @Override
    public void render() {
        for (StiGaugeGeom geom : this.geoms) {
            switch (geom.getType()) {
                case RoundedRectangle: {
                    this.drawRoundedRectangle((StiRoundedRectangleGaugeGeom)geom);
                    break;
                }
                case Rectangle: {
                    this.drawRectangle((StiRectangleGaugeGeom)geom);
                    break;
                }
                case GraphicsPath: {
                    this.drawGraphicsPath((StiGraphicsPathGaugeGeom)geom);
                    break;
                }
                case Pie: {
                    this.drawPie((StiPieGaugeGeom)geom);
                    break;
                }
                case Ellipse: {
                    this.drawEllipse((StiEllipseGaugeGeom)geom);
                    break;
                }
                case GraphicsArcGeometry: {
                    this.drawGraphicsPathArcGeometry((StiGraphicsArcGeometryGaugeGeom)geom);
                    break;
                }
                case PushMatrix: {
                    this.pushMatrix((StiPushMatrixGaugeGeom)geom);
                    break;
                }
                case PopTranform: {
                    this.popState();
                    break;
                }
                case Text: {
                    this.drawString((StiTextGaugeGeom)geom);
                    break;
                }
                case RadialRange: {
                    this.radialRange((StiRadialRangeGaugeGeom)geom);
                }
            }
        }
    }

    private void drawRoundedRectangle(StiRoundedRectangleGaugeGeom geom) {
        List<StiPathCommand> path = StiDrawingHelper.getRoundedPath(geom.Rect, 1, geom.LeftTop, geom.RightTop, geom.RightBottom, geom.LeftBottom);
        this.g.drawPath(path, new StiPen(geom.BorderWidth, this.getColor(geom.BorderBrush)), geom.Background, this.zoom, this.pageZoom);
    }

    private void drawRectangle(StiRectangleGaugeGeom geom) {
        this.g.drawRectangle(geom.Rect, geom.BorderBrush != null && geom.BorderWidth > 0.0 ? new StiPen(geom.BorderWidth, this.getColor(geom.BorderBrush)) : null, geom.Background, Double.valueOf(this.zoom), Double.valueOf(this.pageZoom));
    }

    private void drawGraphicsPath(StiGraphicsPathGaugeGeom geom) {
        ArrayList<Object> gp = new ArrayList<Object>();
        for (StiGaugeGeom gm : geom.getGeoms()) {
            if (gm.getType() == StiGaugeGeomType.GraphicsPathArc) {
                StiGraphicsPathArcGaugeGeom arcGeom = (StiGraphicsPathArcGaugeGeom)gm;
                gp.add(new StiPathArc(arcGeom.x, arcGeom.y, arcGeom.width, arcGeom.height, arcGeom.startAngle <= 180.0 ? arcGeom.startAngle : -arcGeom.startAngle, -arcGeom.sweepAngle));
                continue;
            }
            if (gm.getType() == StiGaugeGeomType.GraphicsPathLines) {
                StiGraphicsPathLinesGaugeGeom linesGeom = (StiGraphicsPathLinesGaugeGeom)gm;
                gp.add(StiPathCommand.moveTo((Double)linesGeom.points[0].x, (Double)linesGeom.points[0].y));
                for (int i = 1; i < linesGeom.points.length; ++i) {
                    gp.add(StiPathCommand.lineTo((Double)linesGeom.points[i].x, (Double)linesGeom.points[i].y));
                }
                continue;
            }
            if (gm.getType() == StiGaugeGeomType.GraphicsPathLine) {
                StiGraphicsPathLineGaugeGeom lineGeom = (StiGraphicsPathLineGaugeGeom)gm;
                gp.add(new StiPathLine(lineGeom.p1.x, lineGeom.p1.y, lineGeom.p2.x, lineGeom.p2.y));
                continue;
            }
            if (gm.getType() != StiGaugeGeomType.GraphicsPathCloseFigure) continue;
            gp.add(new StiPathClose());
        }
        this.g.drawPath(gp, geom.BorderBrush != null && geom.BorderWidth > 0.0 ? new StiPen(geom.BorderWidth, this.getColor(geom.BorderBrush)) : null, geom.Background, Boolean.valueOf(true), this.zoom, this.pageZoom);
    }

    private void drawPie(StiPieGaugeGeom geom) {
        ArrayList<StiPathPie> gp = new ArrayList<StiPathPie>();
        gp.add(new StiPathPie(geom.rect.x, geom.rect.y, geom.rect.width, geom.rect.height, geom.startAngle, geom.sweepAngle));
        this.g.drawPath(gp, geom.borderBrush != null && geom.borderWidth > 0.0 ? new StiPen(geom.borderWidth, this.getColor(geom.borderBrush)) : null, geom.background, Boolean.valueOf(true), this.zoom, this.pageZoom);
    }

    private void drawEllipse(StiEllipseGaugeGeom geom) {
        this.g.drawEllise(geom.Rect, geom.BorderBrush != null && geom.BorderWidth > 0.0 ? new StiPen(geom.BorderWidth, this.getColor(geom.BorderBrush)) : null, geom.Background, Double.valueOf(this.zoom), Double.valueOf(this.pageZoom));
    }

    private void drawGraphicsPathArcGeometry(StiGraphicsArcGeometryGaugeGeom geom) {
        List<StiPathCommand> gp = StiDrawingHelper.getArcGeometry(geom.rect, geom.startAngle, geom.sweepAngle, geom.startWidth, geom.endWidth);
        this.g.drawPath(gp, geom.borderBrush != null && geom.borderWidth > 0.0 ? new StiPen(geom.borderWidth, this.getColor(geom.borderBrush)) : null, geom.background, this.zoom, this.pageZoom);
    }

    private void drawString(StiTextGaugeGeom geom) {
        geom.Font.size /= this.zoom;
        this.g.drawText(geom.Text, geom.Rect, geom.Font, StiBrush.getBrush((StiBrush)geom.Foreground, (StiRectangle)geom.Rect), geom.StringFormat.getHorAlignment(), geom.StringFormat.getVertsAlignment(), Boolean.valueOf(false), 1.0f, Double.valueOf(this.zoom), StiPenStyle.Solid, null, null);
    }

    private void radialRange(StiRadialRangeGaugeGeom geom) {
        List<StiPathCommand> gp = StiDrawingHelper.getRadialRangeGeometry(geom.centerPoint, geom.startAngle, geom.sweepAngle, geom.radius1, geom.radius2, geom.radius3, geom.radius4);
        this.g.drawPath(gp, geom.borderBrush != null && geom.borderWidth > 0.0 ? new StiPen(geom.borderWidth, this.getColor(geom.borderBrush)) : null, geom.background, this.zoom, this.pageZoom);
    }

    private void pushMatrix(StiPushMatrixGaugeGeom geom) {
        this.states.push((AffineTransform)this.g.getG().getTransform().clone());
        this.g.getG().rotate(Math.toRadians(geom.Angle), geom.CenterPoint.x + this.g.getOffsetX(), geom.CenterPoint.y + this.g.getOffsetY());
    }

    private void popState() {
        this.g.getG().setTransform(this.states.pop());
    }

    private StiColor getColor(StiBrush brush) {
        if (brush instanceof StiSolidBrush) {
            return ((StiSolidBrush)brush).getColor();
        }
        return StiColorEnum.Transparent.color();
    }

    public StiGdiGaugeContextPainter(StiGraphics g, StiGauge gauge, StiRectangle rect, double zoom, double pageZoom) {
        super(gauge, rect, zoom, pageZoom);
        this.g = g;
    }
}

