/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.report.maps.gis.StiGisPoint;
import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import com.stimulsoft.report.maps.gis.StiGisProjection;
import com.stimulsoft.report.maps.gis.StiGisRectLatLng;
import com.stimulsoft.report.maps.gis.StiGisSize;

public final class StiMercatorGisProjection
extends StiGisProjection {
    private static final double MinLatitude = -85.05112878;
    private static final double MaxLatitude = 85.05112878;
    private static final double MinLongitude = -180.0;
    private static final double MaxLongitude = 180.0;

    public static final StiMercatorGisProjection instance() {
        return new StiMercatorGisProjection();
    }

    public StiGisRectLatLng getBounds() {
        return StiGisRectLatLng.fromLTRB(-180.0, 85.05112878, 180.0, -85.05112878);
    }

    public double getAxis() {
        return 6378137.0;
    }

    public double getFlattening() {
        return 0.0033528106647474805;
    }

    @Override
    public StiGisPoint fromLatLngToPixel(double lat, double lng, int zoom) {
        lat = StiMercatorGisProjection.clip(lat, -85.05112878, 85.05112878);
        lng = StiMercatorGisProjection.clip(lng, -180.0, 180.0);
        double x = (lng + 180.0) / 360.0;
        double sinLatitude = Math.sin(lat * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        StiGisSize s = this.getTileMatrixSizePixel(zoom);
        int mapSizeX = s.getWidth();
        int mapSizeY = s.getHeight();
        StiGisPoint ret = StiGisPoint.empty();
        ret.setX((int)StiMercatorGisProjection.clip(x * (double)mapSizeX + 0.5, 0.0, mapSizeX - 1));
        ret.setY((int)StiMercatorGisProjection.clip(y * (double)mapSizeY + 0.5, 0.0, mapSizeY - 1));
        return ret;
    }

    @Override
    public StiGisPointLatLng fromPixelToLatLng(int x, int y, int zoom) {
        StiGisSize s = this.getTileMatrixSizePixel(zoom);
        double mapSizeX = s.getWidth();
        double mapSizeY = s.getHeight();
        double xx = StiMercatorGisProjection.clip(x, 0.0, mapSizeX - 1.0) / mapSizeX - 0.5;
        double yy = 0.5 - StiMercatorGisProjection.clip(y, 0.0, mapSizeY - 1.0) / mapSizeY;
        StiGisPointLatLng ret = StiGisPointLatLng.empty();
        ret.setLat(90.0 - 360.0 * Math.atan(Math.exp(-yy * 2.0 * Math.PI)) / Math.PI);
        ret.setLng(360.0 * xx);
        return ret;
    }

    @Override
    public StiGisSize getTileMatrixMinXY(int zoom) {
        return new StiGisSize(0, 0);
    }

    @Override
    public StiGisSize getTileMatrixMaxXY(int zoom) {
        int xy = 1 << zoom;
        return new StiGisSize(xy - 1, xy - 1);
    }
}

