/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.report.maps.gis.StiGisPointLatLng;

public final class StiGisSizeLatLng {
    public static final StiGisSizeLatLng empty = new StiGisSizeLatLng();
    private double widthLng;
    private double heightLat;

    public StiGisSizeLatLng() {
    }

    public StiGisSizeLatLng(StiGisSizeLatLng size) {
        this.setWidthLng(size.getWidthLng());
        this.setHeightLat(size.getHeightLat());
    }

    public StiGisSizeLatLng(StiGisPointLatLng pt) {
        this.setHeightLat(pt.getLat());
        this.setWidthLng(pt.getLng());
    }

    public StiGisSizeLatLng(double heightLat, double widthLng) {
        this.setHeightLat(heightLat);
        this.setWidthLng(widthLng);
    }

    public boolean isEmpty() {
        return this.getWidthLng() == 0.0 && this.getHeightLat() == 0.0;
    }

    public double getWidthLng() {
        return this.widthLng;
    }

    public void setWidthLng(double value) {
        this.widthLng = value;
    }

    public double getHeightLat() {
        return this.heightLat;
    }

    public void setHeightLat(double value) {
        this.heightLat = value;
    }

    public static boolean opEquals(StiGisSizeLatLng sz1, StiGisSizeLatLng sz2) {
        return sz1.getWidthLng() == sz2.getWidthLng() && sz1.getHeightLat() == sz2.getHeightLat();
    }

    public static boolean opNotEquals(StiGisSizeLatLng sz1, StiGisSizeLatLng sz2) {
        return !StiGisSizeLatLng.opEquals(sz1, sz2);
    }

    public static StiGisPointLatLng toStiGisPointLatLng(StiGisSizeLatLng size) {
        return new StiGisPointLatLng(size.getHeightLat(), size.getWidthLng());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StiGisSizeLatLng)) {
            return false;
        }
        StiGisSizeLatLng ef = (StiGisSizeLatLng)obj;
        return ef.getWidthLng() == this.getWidthLng() && ef.getHeightLat() == this.getHeightLat() && ef.getClass().equals(super.getClass());
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return new Double(this.getWidthLng()).hashCode() ^ new Double(this.getHeightLat()).hashCode();
    }

    public String toString() {
        return String.format("WidthLng=%1$s, HeightLng=%2$s", this.getWidthLng(), this.getHeightLat());
    }
}

