/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import com.stimulsoft.report.maps.gis.StiGisPointLatLng;
import com.stimulsoft.report.maps.gis.StiGisSizeLatLng;

public final class StiGisRectLatLng {
    public static final StiGisRectLatLng empty = new StiGisRectLatLng();
    private double lng;
    private double lat;
    private double widthLng;
    private double heightLat;

    public StiGisRectLatLng() {
    }

    public StiGisRectLatLng(double lat, double lng, double widthLng, double heightLat) {
        this.setLng(lng);
        this.setLat(lat);
        this.setWidthLng(widthLng);
        this.setHeightLat(heightLat);
    }

    public StiGisRectLatLng(StiGisPointLatLng location, StiGisSizeLatLng size) {
        this.setLng(location.getLng());
        this.setLat(location.getLat());
        this.setWidthLng(size.getWidthLng());
        this.setHeightLat(size.getHeightLat());
    }

    public StiGisPointLatLng getLocationTopLeft() {
        return new StiGisPointLatLng(this.getLat(), this.getLng());
    }

    public void setLocationTopLeft(StiGisPointLatLng value) {
        this.setLng(value.getLng());
        this.setLat(value.getLat());
    }

    public StiGisPointLatLng getLocationRightBottom() {
        StiGisPointLatLng ret = new StiGisPointLatLng(this.getLat(), this.getLng());
        ret.offset(this.getHeightLat(), this.getWidthLng());
        return ret;
    }

    public StiGisPointLatLng getLocationMiddle() {
        StiGisPointLatLng ret = new StiGisPointLatLng(this.getLat(), this.getLng());
        ret.offset(this.getHeightLat() / 2.0, this.getWidthLng() / 2.0);
        return ret;
    }

    public StiGisSizeLatLng getSize() {
        return new StiGisSizeLatLng(this.getHeightLat(), this.getWidthLng());
    }

    public void setSize(StiGisSizeLatLng value) {
        this.setWidthLng(value.getWidthLng());
        this.setHeightLat(value.getHeightLat());
    }

    public double getLng() {
        return this.lng;
    }

    public void setLng(double value) {
        this.lng = value;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double value) {
        this.lat = value;
    }

    public double getWidthLng() {
        return this.widthLng;
    }

    public void setWidthLng(double value) {
        this.widthLng = value;
    }

    public double getHeightLat() {
        return this.heightLat;
    }

    public void setHeightLat(double value) {
        this.heightLat = value;
    }

    public StiGisRectLatLng clone() {
        return new StiGisRectLatLng(this.lat, this.lng, this.widthLng, this.heightLat);
    }

    public static StiGisRectLatLng fromLTRB(double leftLng, double topLat, double rightLng, double bottomLat) {
        return new StiGisRectLatLng(topLat, leftLng, rightLng - leftLng, topLat - bottomLat);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StiGisRectLatLng)) {
            return false;
        }
        StiGisRectLatLng ef = (StiGisRectLatLng)obj;
        return ef.getLng() == this.getLng() && ef.getLat() == this.getLat() && ef.getWidthLng() == this.getWidthLng() && ef.getHeightLat() == this.getHeightLat();
    }

    public int hashCode() {
        return new Double(this.getLng()).hashCode() ^ new Double(this.getLat()).hashCode() ^ new Double(this.getWidthLng()).hashCode() ^ new Double(this.getHeightLat()).hashCode();
    }

    public String toString() {
        return "{Lat=" + String.valueOf(this.getLat()) + ",Lng=" + String.valueOf(this.getLng()) + ",WidthLng=" + String.valueOf(this.getWidthLng()) + ",HeightLat=" + String.valueOf(this.getHeightLat()) + "}";
    }

    public static boolean opEquals(StiGisRectLatLng left, StiGisRectLatLng right) {
        return left.getLng() == right.getLng() && left.getLat() == right.getLat() && left.getWidthLng() == right.getWidthLng() && left.getHeightLat() == right.getHeightLat();
    }

    public static boolean opNotEquals(StiGisRectLatLng left, StiGisRectLatLng right) {
        return !StiGisRectLatLng.opEquals(left, right);
    }

    public boolean contains(double lat, double lng) {
        return this.getLng() <= lng && lng < this.getLng() + this.getWidthLng() && this.getLat() >= lat && lat > this.getLat() - this.getHeightLat();
    }

    public boolean contains(StiGisPointLatLng pt) {
        return this.contains(pt.getLat(), pt.getLng());
    }
}

