/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.gis;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import javax.imageio.ImageIO;

public final class StiGisMapImage
implements Closeable {
    public byte[] data;
    public BufferedImage bitmapGdi;

    public StiGisMapImage(byte[] data) {
        this.data = data;
    }

    public static StiGisMapImage fromBufferedImage(BufferedImage bi) {
        try {
            StiGisMapImage image = new StiGisMapImage(new byte[1]);
            image.bitmapGdi = bi;
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static StiGisMapImage fromByteArray(byte[] buffer) {
        try {
            StiGisMapImage image = new StiGisMapImage(buffer);
            image.bitmapGdi = ImageIO.read(new ByteArrayInputStream(buffer));
            return image;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void close() {
        if (this.bitmapGdi != null) {
            this.bitmapGdi = null;
        }
        this.data = null;
    }
}

