/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps;

import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.maps.StiMapSvg;
import com.stimulsoft.report.painters.context.map.StiMapGeomsObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiMapSvgContainer {
    public String name;
    public int width;
    public int height;
    public List<StiMapSvg> paths = new ArrayList<StiMapSvg>();
    public List<StiMapGeomsObject> geoms;
    public HashMap<String, StiMapSvg> hashPaths;

    public void populateObject(String jsonText) throws JSONException {
        JSONObject json = new JSONObject(jsonText);
        if (json.has("Name")) {
            this.name = json.getString("Name");
        }
        if (json.has("Width")) {
            this.width = json.getInt("Width");
        }
        if (json.has("Height")) {
            this.height = json.getInt("Height");
        }
        if (json.has("Paths")) {
            JSONArray jpaths = json.getJSONArray("Paths");
            for (int i = 0; i < jpaths.length(); ++i) {
                JSONObject jpath = jpaths.getJSONObject(i);
                StiMapSvg path = new StiMapSvg();
                path.data = jpath.tryGetString("Data");
                path.key = jpath.tryGetString("Key");
                path.englishName = jpath.tryGetString("EnglishName");
                path.horAlignment = StiValidationUtil.isNotNullOrEmpty((String)jpath.tryGetString("HorAlignment")) ? StiTextHorAlignment.valueOf((String)jpath.tryGetString("HorAlignment")) : StiTextHorAlignment.Center;
                path.ISOCode = jpath.tryGetString("ISOCode");
                if (jpath.has("Rect")) {
                    String[] rect = jpath.tryGetString("Rect").split(",");
                    path.rect = new StiRectangle(Double.parseDouble(rect[0]), Double.parseDouble(rect[1]), Double.parseDouble(rect[2]), Double.parseDouble(rect[3]));
                }
                path.setMaxWidth = Boolean.parseBoolean(jpath.tryGetString("SetMaxWidth").toLowerCase());
                path.skipText = Boolean.parseBoolean(jpath.tryGetString("SkipText").toLowerCase());
                path.vertAlignment = StiValidationUtil.isNotNullOrEmpty((String)jpath.tryGetString("VertAlignment")) ? StiVertAlignment.valueOf((String)jpath.tryGetString("VertAlignment")) : StiVertAlignment.Center;
                this.paths.add(path);
            }
        }
    }

    public void prepare() {
        if (this.hashPaths == null) {
            this.hashPaths = new HashMap();
            for (StiMapSvg pt : this.paths) {
                this.hashPaths.put(pt.key, pt);
            }
            this.paths.clear();
            this.paths = null;
        }
    }
}

