/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.tick.linear.mark;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiLinearTickMarkBase;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import java.util.TreeMap;

public class StiLinearTickMarkMinor
extends StiLinearTickMarkBase {
    private boolean skipMajorValues = true;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("SkipMajorValues", this.skipMajorValues, true);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (!"SkipMajorValues".equals(property.Name)) continue;
            this.setSkipMajorValues((Boolean)property.Value);
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearTickMarkMinor;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        if (this.isAllowApplyStyle()) {
            this.setBorderBrush(style.getCore().getTickMarkMinorBorder());
            this.setBrush(style.getCore().getTickMarkMinorBrush());
            this.setBorderWidth(style.getCore().getTickMarkMinorBorderWidth());
        }
    }

    @Override
    @StiSerializable
    public boolean isSkipMajorValues() {
        return this.skipMajorValues;
    }

    public void setSkipMajorValues(boolean skipMajorValues) {
        this.skipMajorValues = skipMajorValues;
    }

    @Override
    public String getLocalizeName() {
        return "LinearTickMarkMinor";
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiLinearTickMarkMinor();
    }

    @Override
    protected TreeMap<Double, Double> getPointCollection() {
        return this.getMinorCollections();
    }
}

