/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.tick.linear.mark;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.collections.StiCustomValuesCollection;
import com.stimulsoft.report.infographics.gauge.expressions.StiValueExpression;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.interfaces.IStiTickCustom;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.tick.StiLinearTickMarkBase;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.infographics.gauge.tick.StiCustomValueBase;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkCustomValue;
import com.stimulsoft.report.painters.StiGaugeContextPainter;

public class StiLinearTickMarkCustom
extends StiLinearTickMarkBase
implements IStiTickCustom {
    private double valueObj = 0.0;
    private StiCustomValuesCollection values = new StiCustomValuesCollection();
    private StiGetValueEvent getValueEvent = new StiGetValueEvent();
    private StiValueExpression value = new StiValueExpression();

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyJObject("GetValueEvent", this.getValueEvent.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Value", this.value.SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Values", this.values.SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("GetSkipValuesEvent".equals(property.Name)) {
                StiGetValueEvent _getSkipValuesEvent = new StiGetValueEvent();
                _getSkipValuesEvent.LoadFromJsonObject((JSONObject)property.Value);
                this.getValueEvent = _getSkipValuesEvent;
                continue;
            }
            if ("GetSkipIndicesEvent".equals(property.Name)) {
                StiValueExpression _valueExpression = new StiValueExpression();
                _valueExpression.LoadFromJsonObject((JSONObject)property.Value);
                this.value = _valueExpression;
                continue;
            }
            if (!"Values".equals(property.Name)) continue;
            this.values.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearTickMarkCustom;
    }

    @Override
    public Object clone() {
        StiLinearTickMarkCustom tickMark = (StiLinearTickMarkCustom)super.clone();
        tickMark.value = this.value != null ? (StiValueExpression)this.value.clone() : null;
        tickMark.values = new StiCustomValuesCollection();
        for (StiCustomValueBase customValue : this.values) {
            tickMark.values.add((StiCustomValueBase)customValue.clone());
        }
        tickMark.valueObj = this.valueObj;
        tickMark.getValueEvent = (StiGetValueEvent)this.getValueEvent.clone();
        return tickMark;
    }

    @Override
    @StiSerializable
    public double getValueObj() {
        return this.valueObj;
    }

    @Override
    public void setValueObj(double valueObj) {
        this.valueObj = valueObj;
    }

    @Override
    @StiSerializable
    public StiCustomValuesCollection getValues() {
        return this.values;
    }

    @Override
    public void setValues(StiCustomValuesCollection values) {
        this.values = values;
    }

    @Override
    public String getLocalizeName() {
        return "LinearTickMarkCustom";
    }

    @StiSerializable
    public StiGetValueEvent getGetValueEvent() {
        return this.getValueEvent;
    }

    public void setGetValueEvent(StiGetValueEvent getValueEvent) {
        this.getValueEvent = getValueEvent;
    }

    @StiSerializable
    public StiValueExpression getValue() {
        return this.value;
    }

    public void setValue(StiValueExpression value) {
        this.value = value;
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiLinearTickMarkCustom();
    }

    @Override
    public void prepareGaugeElement() {
        super.prepareGaugeElement();
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        this.InvokeGetValue(this, e);
        this.setValueObj(StiGaugeHelper.getFloatValueFromObject((Object)e.getValue(), 0.0));
    }

    public void InvokeGetValue(StiGaugeElement sender, StiGetValueEventArgs e) {
        try {
            Object parserResult = StiParser.ParseTextValue(this.value.getValue(), sender.getScale().getGauge());
            e.setValue(sender.getScale().gauge.getReport().ToString(parserResult));
        }
        catch (Exception ex) {
            String str = String.format("Expression in GetValue property of '%s' series from '%s' chart can't be evaluated!", "Indicator", this.scale.gauge.getName());
            System.out.println(str);
            ex.printStackTrace();
            this.scale.gauge.getReport().WriteToReportRenderingMessages(str);
        }
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiLinearScale linearScale;
        StiLinearScale stiLinearScale = linearScale = this.scale instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
        if (linearScale == null) {
            return;
        }
        StiSize size = linearScale.barGeometry.getSize();
        StiRectangle rect = linearScale.barGeometry.getRectGeometry();
        double rest = this.scale.barGeometry.getRestToLenght();
        double scaleOffset = linearScale.getOrientation() == StiOrientation.Horizontal ? size.height : size.width;
        scaleOffset *= super.getOffset();
        double startValue = this.scale.scaleHelper.ActualMinimum;
        double endValue = this.scale.scaleHelper.ActualMaximum;
        StiGaugeElementSkin actualSkin = this.getActualSkin();
        double[] skipValues = super.getSkipValuesObj();
        double[] skipIndices = super.getSkipIndicesObj();
        StiCustomValuesCollection coll = this.values;
        if (coll == null || coll.size() == 0) {
            coll = new StiCustomValuesCollection();
            coll.add(new StiLinearTickMarkCustomValue(this.valueObj, this.getOffset(), this.getRelativeWidth(), this.getRelativeHeight(), this.getPlacement(), actualSkin));
        }
        int index = -1;
        for (StiCustomValueBase kk : coll) {
            double top;
            double left;
            double offset;
            StiLinearTickMarkCustomValue key = (StiLinearTickMarkCustomValue)kk;
            if (key.value < startValue || key.value > endValue || this.checkTickValue(skipValues, skipIndices, key.value, ++index) || this.getMinimumValue() != null && key.value < this.getMinimumValue() || this.getMaximumValue() != null && key.value > this.getMaximumValue()) continue;
            double position = this.scale.getPosition(key.value);
            double tickWidth = size.width * this.getRelativeWidth(key.getRelativeWidth());
            double tickHeight = size.height * this.getRelativeHeight(key.getRelativeHeight());
            if (linearScale.getOrientation() == StiOrientation.Horizontal) {
                double d = offset = linearScale.getIsReversed() ? rect.width - rect.width * position : rect.width * position;
                if (this.getPlacement(key.getPlacement()) == StiPlacement.Overlay) {
                    left = rect.getLeft() + offset - tickWidth / 2.0;
                    top = StiRectangleHelper.centerY(rect) - tickHeight / 2.0 - scaleOffset;
                } else {
                    double restValue;
                    double d2 = restValue = linearScale.getStartWidth() < linearScale.getEndWidth() ? (1.0 - position) * rest : rest * position;
                    if (this.getPlacement(key.getPlacement()) == StiPlacement.Outside) {
                        left = rect.getLeft() + offset - tickWidth / 2.0;
                        top = rect.getTop() - tickHeight - scaleOffset + restValue;
                    } else {
                        left = rect.getLeft() + offset - tickWidth / 2.0;
                        top = rect.getBottom() + scaleOffset - restValue;
                    }
                }
            } else {
                double d = offset = linearScale.getIsReversed() ? rect.height * position : rect.height - rect.height * position;
                if (this.getPlacement(key.getPlacement()) == StiPlacement.Overlay) {
                    left = StiRectangleHelper.centerX(rect) - tickWidth / 2.0;
                    top = rect.getTop() + offset - tickHeight / 2.0;
                } else {
                    double restValue;
                    double d3 = restValue = linearScale.getStartWidth() < linearScale.getEndWidth() ? (1.0 - position) * rest : rest * position;
                    if (this.getPlacement(key.getPlacement()) == StiPlacement.Outside) {
                        left = rect.getLeft() - tickWidth - 1.0 - scaleOffset + restValue;
                        top = rect.getTop() + offset - tickHeight / 2.0;
                    } else {
                        left = rect.getRight() + 1.0 + scaleOffset - restValue;
                        top = rect.getTop() + offset - tickHeight / 2.0;
                    }
                }
            }
            StiGaugeElementSkin skin = key.getSkin() == null ? actualSkin : key.getSkin();
            skin.draw(context, this, new StiRectangle(left, top, tickWidth, tickHeight));
        }
    }
}

