/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.indicators;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiScaleAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.infographics.gauge.StiBarRangeListType;
import com.stimulsoft.report.infographics.gauge.StiLinearBarSkin;
import com.stimulsoft.report.infographics.gauge.StiLinearRangeColorMode;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiMathHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiMixedColorHelper;
import com.stimulsoft.report.infographics.gauge.helpers.StiRectangleHelper;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearIndicatorRangeInfo;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiBarBase;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathLinesGaugeGeom;
import java.util.ArrayList;

public class StiLinearBar
extends StiBarBase {
    private LinearColorModeHelper colorModeHelper = new LinearColorModeHelper();
    private StiBrush actualBackground;
    private StiLinearBarSkin skin = StiLinearBarSkin.Default;
    private StiLinearRangeColorMode rangeColorMode = StiLinearRangeColorMode.Default;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyEnum("Skin", (Enum)this.skin);
        jObject.AddPropertyEnum("RangeColorMode", (Enum)this.rangeColorMode);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Skin".equals(property.Name)) {
                this.setSkin(StiLinearBarSkin.valueOf(property.Value.toString()));
                continue;
            }
            if (!"RangeColorMode".equals(property.Name)) continue;
            this.setRangeColorMode(StiLinearRangeColorMode.valueOf(property.Value.toString()));
        }
    }

    @Override
    public Object clone() {
        StiLinearBar bar = (StiLinearBar)super.clone();
        bar.actualBackground = this.actualBackground != null ? (StiBrush)this.actualBackground.clone() : null;
        bar.colorModeHelper = this.colorModeHelper;
        bar.rangeColorMode = this.rangeColorMode;
        bar.skin = this.skin;
        return bar;
    }

    @Override
    protected void onRangeColorChanged() {
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearBar;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        if (this.isAllowApplyStyle()) {
            this.setBrush(style.getCore().getLinearBarBrush());
            this.setBorderBrush(style.getCore().getLinearBarBorderBrush());
            this.setEmptyBrush(style.getCore().getLinearBarEmptyBrush());
            this.setEmptyBorderBrush(style.getCore().getLinearBarEmptyBorderBrush());
            this.setStartWidth(style.getCore().getLinearBarStartWidth());
            this.setEndWidth(style.getCore().getLinearBarEndWidth());
        }
    }

    @StiSerializable
    public StiLinearBarSkin getSkin() {
        return this.skin;
    }

    public void setSkin(StiLinearBarSkin skin) {
        this.skin = skin;
    }

    @StiSerializable
    public StiLinearRangeColorMode getRangeColorMode() {
        return this.rangeColorMode;
    }

    public void setRangeColorMode(StiLinearRangeColorMode rangeColorMode) {
        this.rangeColorMode = rangeColorMode;
    }

    protected void pnRangeColorChanged() {
        this.colorModeHelper.Reset();
    }

    @Override
    protected StiBarRangeListType getBarType() {
        return StiBarRangeListType.LinearBar;
    }

    @Override
    public String getLocalizeName() {
        return "LinearBar";
    }

    @Override
    protected void checkActualBrushForTopGeometry() {
        if (this.isUseRangeColor()) {
            this.actualBackground = this.GetRangeBrush();
        } else if (!this.colorModeHelper.standardBackground) {
            this.colorModeHelper.standardBackground = true;
            this.actualBackground = this.getBrush();
        }
    }

    private StiBrush GetRangeBrush() {
        Double value = this.getActualValue();
        if (value == null) {
            return null;
        }
        block0 : switch (this.rangeColorMode) {
            case Default: {
                for (int index = this.getRangeList().size() - 1; index >= 0; --index) {
                    StiLinearIndicatorRangeInfo info = (StiLinearIndicatorRangeInfo)this.getRangeList().get(index);
                    if (!(value >= info.getValue()) || this.colorModeHelper.defaultIndex == index) continue;
                    this.colorModeHelper.defaultIndex = index;
                    return info.getBrush() != null ? info.getBrush() : new StiSolidBrush(info.getColor());
                }
                break;
            }
            case MixedColor: {
                for (int index = this.getRangeList().size() - 1; index >= 0; --index) {
                    StiLinearIndicatorRangeInfo info = (StiLinearIndicatorRangeInfo)this.getRangeList().get(index);
                    if (!(value >= info.getValue())) continue;
                    if (this.colorModeHelper.mixedColorIndex == index) break block0;
                    this.colorModeHelper.mixedColorIndex = index;
                    ArrayList<StiColor> colors = new ArrayList<StiColor>();
                    for (int index1 = 0; index1 <= index; ++index1) {
                        colors.add(((StiLinearIndicatorRangeInfo)this.getRangeList().get(index1)).getColor());
                    }
                    return new StiSolidBrush(StiMixedColorHelper.colorMixed(colors));
                }
                break;
            }
        }
        return null;
    }

    @Override
    public StiGaugeElement createNew() {
        return new StiLinearBar();
    }

    @Override
    protected void interactiveClick(StiRectangle rect, StiPoint p) {
    }

    @Override
    public double getValueObj() {
        if (this.getScale().getGauge().getReport() == null) {
            return this.getValueObj();
        }
        Double nullValue = this.getActualValue();
        if (nullValue == null) {
            return 0.0;
        }
        return nullValue;
    }

    @Override
    public void drawElement(StiGaugeContextPainter context) {
        StiRefObject rect1;
        Double valueTemp;
        LinearBarGeometryHelper geomHelper;
        StiGraphicsPathLinesGaugeGeom lines1Geom;
        if (this.scale == null) {
            return;
        }
        switch (this.skin) {
            case HorizontalThermometer: {
                this.drawHorizontalThermometer(context);
                break;
            }
            case VerticalThermometer: {
                this.drawVerticalThermometer(context);
            }
        }
        StiRefObject rect = new StiRefObject((Object)StiRectangle.empty());
        StiGraphicsPathLinesGaugeGeom linesGeom = this.scale.barGeometry.drawGeometry(context, this.scale.getMinimum(), this.scale.getMaximum(), this.getStartWidth(), this.getEndWidth(), this.getOffset(), this.getPlacement(), (StiRefObject<StiRectangle>)rect, false);
        if (linesGeom != null) {
            StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom((StiRectangle)rect.argvalue, linesGeom.points[0], this.getEmptyBrush(), this.getEmptyBorderBrush(), this.getEmptyBorderWidth());
            pathGeom.getGeoms().add(linesGeom);
            pathGeom.addGraphicsPathCloseFigureGaugeGeom();
            context.addGraphicsPathGaugeGeom(pathGeom);
        }
        if ((lines1Geom = this.getTopGeometry(geomHelper = this.getGeometryHelperForTopIndicator(valueTemp = Double.valueOf(this.getValueObj())), (StiRefObject<StiRectangle>)(rect1 = new StiRefObject((Object)new StiRectangle())))) != null) {
            StiLinearScale lineScale;
            this.checkActualBrushForTopGeometry();
            StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom((StiRectangle)rect1.argvalue, lines1Geom.points[0], this.actualBackground, this.getBorderBrush(), this.getBorderWidth());
            pathGeom.getGeoms().add(lines1Geom);
            pathGeom.addGraphicsPathCloseFigureGaugeGeom();
            double startScaleX = 0.0;
            double endScaleX = 1.0;
            double startScaleY = 1.0;
            double endScaleY = 1.0;
            double centerX = ((StiRectangle)rect.argvalue).x;
            double centerY = ((StiRectangle)rect.argvalue).y + ((StiRectangle)rect.argvalue).height / 2.0;
            StiLinearScale stiLinearScale = lineScale = this.scale instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
            if (lineScale != null && lineScale.getOrientation() == StiOrientation.Vertical) {
                startScaleX = 1.0;
                endScaleX = 1.0;
                startScaleY = 0.0;
                endScaleY = 1.0;
                centerX = ((StiRectangle)rect.argvalue).x + ((StiRectangle)rect.argvalue).width / 2.0;
                centerY = ((StiRectangle)rect.argvalue).y + ((StiRectangle)rect.argvalue).height;
            }
            pathGeom.setAnimation((StiAnimation)new StiScaleAnimation(startScaleX, endScaleX, startScaleY, endScaleY, centerX, centerY, Integer.valueOf(StiGaugeHelper.GlobalDurationElement), Integer.valueOf(0)));
            context.addGraphicsPathGaugeGeom(pathGeom);
        }
    }

    private void drawHorizontalThermometer(StiGaugeContextPainter context) {
        StiRefObject rect = new StiRefObject((Object)StiRectangle.empty());
        this.scale.barGeometry.drawGeometry(context, this.scale.getMinimum(), this.scale.getMaximum(), this.getStartWidth(), this.getEndWidth(), this.getOffset(), this.getPlacement(), (StiRefObject<StiRectangle>)rect, false);
        ((StiRectangle)rect.argvalue).y -= 2.0;
        ((StiRectangle)rect.argvalue).height += 4.0;
        ((StiRectangle)rect.argvalue).x -= 3.0;
        ((StiRectangle)rect.argvalue).width += 3.0;
        StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom((StiRectangle)rect.argvalue, ((StiRectangle)rect.argvalue).getLocation(), (StiBrush)new StiGradientBrush(StiColor.fromArgb((int)225, (int)230, (int)233), StiColor.fromArgb((int)242, (int)243, (int)244), 90.0), (StiBrush)new StiSolidBrush(StiColor.fromArgb((int)157, (int)157, (int)157)), 0.4);
        pathGeom.addGraphicsPathLineGaugeGeom(((StiRectangle)rect.argvalue).getLocation(), new StiPoint(((StiRectangle)rect.argvalue).getRight(), ((StiRectangle)rect.argvalue).getTop()));
        pathGeom.addGraphicsPathArcGaugeGeom(((StiRectangle)rect.argvalue).getRight(), ((StiRectangle)rect.argvalue).getTop(), 4.0, ((StiRectangle)rect.argvalue).height, 270.0, 180.0);
        pathGeom.addGraphicsPathLineGaugeGeom(new StiPoint(((StiRectangle)rect.argvalue).getRight(), ((StiRectangle)rect.argvalue).getBottom()), new StiPoint(((StiRectangle)rect.argvalue).getLeft(), ((StiRectangle)rect.argvalue).getBottom()));
        pathGeom.addGraphicsPathCloseFigureGaugeGeom();
        context.addGraphicsPathGaugeGeom(pathGeom);
    }

    private void drawVerticalThermometer(StiGaugeContextPainter context) {
        StiRefObject rect = new StiRefObject((Object)StiRectangle.getEmpty());
        this.scale.barGeometry.drawGeometry(context, this.scale.getMinimum(), this.scale.getMaximum(), this.getStartWidth(), this.getEndWidth(), this.getOffset(), this.getPlacement(), (StiRefObject<StiRectangle>)rect, false);
        ((StiRectangle)rect.argvalue).x -= 2.0;
        ((StiRectangle)rect.argvalue).width += 4.0;
        ((StiRectangle)rect.argvalue).y -= 3.0;
        ((StiRectangle)rect.argvalue).height += 3.0;
        StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom((StiRectangle)rect.argvalue, ((StiRectangle)rect.argvalue).getLocation(), (StiBrush)new StiGradientBrush(StiColor.fromArgb((int)225, (int)230, (int)233), StiColor.fromArgb((int)242, (int)243, (int)244), 90.0), (StiBrush)new StiSolidBrush(StiColor.fromArgb((int)157, (int)157, (int)157)), 0.4f);
        pathGeom.addGraphicsPathArcGaugeGeom(((StiRectangle)rect.argvalue).getLeft(), ((StiRectangle)rect.argvalue).getTop() - 4.0, ((StiRectangle)rect.argvalue).width, 4.0, 180.0, 180.0);
        pathGeom.addGraphicsPathLineGaugeGeom(new StiPoint(((StiRectangle)rect.argvalue).getRight(), ((StiRectangle)rect.argvalue).getTop()), new StiPoint(((StiRectangle)rect.argvalue).getRight(), ((StiRectangle)rect.argvalue).getBottom()));
        pathGeom.addGraphicsPathLineGaugeGeom(new StiPoint(((StiRectangle)rect.argvalue).getRight(), ((StiRectangle)rect.argvalue).getBottom()), new StiPoint(((StiRectangle)rect.argvalue).getLeft(), ((StiRectangle)rect.argvalue).getBottom()));
        pathGeom.addGraphicsPathCloseFigureGaugeGeom();
        context.addGraphicsPathGaugeGeom(pathGeom);
    }

    private LinearBarGeometryHelper getGeometryHelperForTopIndicator(double value) {
        StiLinearScale linearScale = this.scale instanceof StiLinearScale ? (StiLinearScale)this.scale : null;
        LinearBarGeometryHelper geomHelper = new LinearBarGeometryHelper();
        StiSize size = this.scale.barGeometry.getSize();
        StiRectangle rect = this.scale.barGeometry.getRectGeometry();
        double parentRest = StiMathHelper.maxMinusMin(this.scale.getStartWidth(), this.scale.getEndWidth());
        parentRest = linearScale.getOrientation() == StiOrientation.Horizontal ? parentRest * size.height : (parentRest /= 2.0) * size.width;
        StiRectangle centerRect = linearScale.getOrientation() == StiOrientation.Horizontal ? new StiRectangle(rect.x, rect.y + parentRest, rect.width, rect.height - 2.0 * parentRest) : new StiRectangle(rect.x + parentRest, rect.y, rect.width - 2.0 * parentRest, rect.height);
        double minimum = this.scale.getMinimum() > this.scale.getMaximum() ? this.scale.getMaximum() : this.scale.getMinimum();
        double fullLength = Math.abs(this.scale.getMinimum()) + Math.abs(this.scale.getMaximum());
        double length = StiMathHelper.length(minimum, value);
        if (length < 0.0) {
            length = 0.0;
        } else if (length > fullLength) {
            length = fullLength;
        }
        double percentOffset = length / fullLength;
        Double geomMaxWidth = null;
        Double geomMinWidth = null;
        StiRectangle finishRect = new StiRectangle(0L, 0L, 0L, 0L);
        boolean isStartGreaterEnd = this.scale.getStartWidth() > this.scale.getEndWidth();
        boolean isThisStartGreaterEnd = this.getStartWidth() > this.getEndWidth();
        double actualWidth = linearScale.getOrientation() == StiOrientation.Horizontal ? rect.width * percentOffset : rect.height * percentOffset;
        double maxOffsetThisWidth = 0.0;
        double minOffsetThisWidth = 0.0;
        double maxThisWidth = 0.0;
        double minThisWidth = 0.0;
        if (this.getStartWidth() > this.getEndWidth()) {
            maxOffsetThisWidth = this.getStartWidth();
            minOffsetThisWidth = this.getEndWidth();
        } else {
            minOffsetThisWidth = this.getStartWidth();
            maxOffsetThisWidth = this.getEndWidth();
        }
        double thisOffsetRest = maxOffsetThisWidth - minOffsetThisWidth;
        if (linearScale.getOrientation() == StiOrientation.Horizontal) {
            maxThisWidth = maxOffsetThisWidth * size.height;
            minThisWidth = minOffsetThisWidth * size.height;
            if (this.scale.getIsReversed()) {
                if (isStartGreaterEnd) {
                    switch (this.getPlacement()) {
                        case Outside: {
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(rect.x + (centerRect.width - actualWidth), centerRect.y - parentRest - maxThisWidth, actualWidth, parentRest + maxThisWidth - parentRest * (1.0 - percentOffset));
                                geomMinWidth = finishRect.height - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                                break;
                            }
                            if (maxThisWidth > parentRest + minThisWidth) {
                                double y = (maxThisWidth - parentRest - minThisWidth) * (1.0 - percentOffset);
                                finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), centerRect.y - maxThisWidth + y, actualWidth, maxThisWidth - parentRest * (1.0 - percentOffset) - y);
                                geomHelper.offset = parentRest * percentOffset;
                                break;
                            }
                            double y = parentRest * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), centerRect.y - parentRest - minThisWidth, actualWidth, parentRest + minThisWidth - y);
                            geomMaxWidth = finishRect.height - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                        case Overlay: {
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0, actualWidth, maxThisWidth);
                                geomMinWidth = finishRect.height - (maxThisWidth - minThisWidth) * percentOffset;
                                break;
                            }
                            double y = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0 + y, actualWidth, maxThisWidth - 2.0 * y);
                            break;
                        }
                        default: {
                            if (isThisStartGreaterEnd) {
                                double y = parentRest * (1.0 - percentOffset);
                                finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), centerRect.getBottom() + y, actualWidth, parentRest + maxThisWidth - y);
                                geomMinWidth = finishRect.height - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                                break;
                            }
                            if (maxThisWidth > parentRest + minThisWidth) {
                                double y = parentRest * (1.0 - percentOffset);
                                double y1 = (maxThisWidth - parentRest - minThisWidth) * (1.0 - percentOffset);
                                finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), centerRect.getBottom() + y, actualWidth, maxThisWidth - y - y1);
                                geomHelper.offset = maxThisWidth - parentRest - minThisWidth - y1;
                                break;
                            }
                            double y = parentRest * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), centerRect.getBottom() + y, actualWidth, parentRest + minThisWidth - y);
                            geomMaxWidth = finishRect.height - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                    }
                } else {
                    switch (this.getPlacement()) {
                        case Outside: {
                            if (isThisStartGreaterEnd) {
                                if (maxThisWidth > parentRest + minThisWidth) {
                                    finishRect = new StiRectangle(centerRect.x + (centerRect.width - actualWidth), centerRect.y - maxThisWidth, actualWidth, maxThisWidth);
                                    geomHelper.offset = (maxThisWidth - parentRest - minThisWidth) * percentOffset;
                                    geomMinWidth = finishRect.height - geomHelper.offset - parentRest * percentOffset;
                                    break;
                                }
                                double y = (parentRest + minThisWidth - maxThisWidth) * (1.0 - percentOffset);
                                finishRect = new StiRectangle(rect.x + (rect.width - actualWidth), rect.y - minThisWidth + y, actualWidth, parentRest + minThisWidth - y);
                                geomMinWidth = finishRect.height - parentRest * percentOffset;
                                geomHelper.state = true;
                                break;
                            }
                            double y = (parentRest + maxThisWidth - minThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(rect.x + (rect.width - actualWidth), rect.y - maxThisWidth + y, actualWidth, maxThisWidth + parentRest - y);
                            geomMaxWidth = finishRect.height - parentRest * percentOffset;
                            break;
                        }
                        case Overlay: {
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(centerRect.x + (rect.width - actualWidth), StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0, actualWidth, maxThisWidth);
                                geomMinWidth = finishRect.height - 2.0 * ((maxThisWidth - minThisWidth) / 2.0 * percentOffset);
                                break;
                            }
                            double y = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x + (rect.width - actualWidth), StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0 + y, actualWidth, maxThisWidth - 2.0 * y);
                            break;
                        }
                        default: {
                            if (isThisStartGreaterEnd) {
                                if (maxThisWidth > parentRest + minThisWidth) {
                                    finishRect = new StiRectangle(centerRect.x + (rect.width - actualWidth), centerRect.getBottom(), actualWidth, maxThisWidth);
                                    geomHelper.offset = parentRest * percentOffset;
                                    geomMinWidth = finishRect.height - (maxThisWidth - parentRest - minThisWidth) * percentOffset - geomHelper.offset;
                                    break;
                                }
                                double y = (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                                finishRect = new StiRectangle(centerRect.x + (rect.width - actualWidth), centerRect.getBottom(), actualWidth, maxThisWidth + y);
                                geomMinWidth = finishRect.height - parentRest * percentOffset;
                                geomHelper.state = true;
                                break;
                            }
                            double y = (parentRest + maxThisWidth - minThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x + (rect.width - actualWidth), centerRect.getBottom(), actualWidth, parentRest + maxThisWidth - y);
                            geomMaxWidth = finishRect.height - parentRest * percentOffset;
                            break;
                        }
                    }
                }
            } else if (isStartGreaterEnd) {
                switch (this.getPlacement()) {
                    case Outside: {
                        if (isThisStartGreaterEnd) {
                            finishRect = new StiRectangle(rect.x, rect.y - maxThisWidth, actualWidth, maxThisWidth + parentRest * percentOffset);
                            geomMinWidth = finishRect.height - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                            break;
                        }
                        finishRect = new StiRectangle(rect.x, rect.y - minThisWidth, actualWidth, parentRest + minThisWidth - parentRest * (1.0 - percentOffset));
                        geomMaxWidth = finishRect.height - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                        break;
                    }
                    case Overlay: {
                        if (isThisStartGreaterEnd) {
                            finishRect = new StiRectangle(centerRect.x, StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0, actualWidth, maxThisWidth);
                            geomMinWidth = minThisWidth + (maxThisWidth - minThisWidth) / 2.0 * percentOffset;
                            break;
                        }
                        double y = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                        finishRect = new StiRectangle(centerRect.x, StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0 + y, actualWidth, maxThisWidth - 2.0 * y);
                        break;
                    }
                    default: {
                        if (isThisStartGreaterEnd) {
                            double y = parentRest * percentOffset;
                            finishRect = new StiRectangle(rect.x, rect.getBottom() - y, actualWidth, y + maxThisWidth);
                            geomMinWidth = finishRect.height - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                            break;
                        }
                        if (maxThisWidth > parentRest + minThisWidth) {
                            double y = parentRest * (1.0 - percentOffset);
                            geomHelper.offset = parentRest - y;
                            finishRect = new StiRectangle(centerRect.x, centerRect.getBottom() + y, actualWidth, maxThisWidth - y - (maxThisWidth - parentRest - minThisWidth) * (1.0 - percentOffset));
                            break;
                        }
                        double y = parentRest * percentOffset;
                        finishRect = new StiRectangle(rect.x, rect.getBottom() - y, actualWidth, y + minThisWidth);
                        geomMaxWidth = finishRect.height - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                        geomHelper.state = true;
                        break;
                    }
                }
            } else {
                double offset = (parentRest + maxThisWidth - minThisWidth) * percentOffset + minThisWidth;
                switch (this.getPlacement()) {
                    case Outside: {
                        if (isThisStartGreaterEnd) {
                            if (maxThisWidth > parentRest + minThisWidth) {
                                finishRect = new StiRectangle(centerRect.x, centerRect.y - maxThisWidth, actualWidth, maxThisWidth);
                                geomHelper.offset = (finishRect.height - parentRest - minThisWidth) * percentOffset;
                                geomMinWidth = finishRect.height - geomHelper.offset - parentRest * percentOffset;
                                break;
                            }
                            double y = (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            finishRect = new StiRectangle(centerRect.x, centerRect.y - maxThisWidth - y, actualWidth, maxThisWidth + y);
                            geomMinWidth = finishRect.height - parentRest * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                        finishRect = new StiRectangle(centerRect.x, centerRect.y - offset, actualWidth, offset);
                        geomMaxWidth = finishRect.height - parentRest * percentOffset;
                        break;
                    }
                    case Overlay: {
                        double y = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                        if (isThisStartGreaterEnd) {
                            finishRect = new StiRectangle(rect.x, StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0, actualWidth, maxThisWidth);
                            geomMinWidth = minThisWidth + (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                            break;
                        }
                        finishRect = new StiRectangle(rect.x, StiRectangleHelper.centerY(centerRect) - maxThisWidth / 2.0 + y, actualWidth, maxThisWidth - 2.0 * y);
                        break;
                    }
                    default: {
                        if (isThisStartGreaterEnd) {
                            if (maxThisWidth > parentRest + minThisWidth) {
                                finishRect = new StiRectangle(centerRect.x, centerRect.getBottom(), actualWidth, maxThisWidth);
                                geomHelper.offset = parentRest * percentOffset;
                                geomMinWidth = finishRect.height - (maxThisWidth - parentRest - minThisWidth) * percentOffset - geomHelper.offset;
                                break;
                            }
                            double y = (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            finishRect = new StiRectangle(centerRect.x, centerRect.getBottom(), actualWidth, maxThisWidth + y);
                            geomMinWidth = finishRect.height - parentRest * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                        finishRect = new StiRectangle(centerRect.x, centerRect.getBottom(), actualWidth, offset);
                        geomMaxWidth = minThisWidth + (maxThisWidth - minThisWidth) * percentOffset;
                        break;
                    }
                }
            }
        } else {
            maxThisWidth = maxOffsetThisWidth * size.width;
            minThisWidth = minOffsetThisWidth * size.width;
            if (this.scale.getIsReversed()) {
                if (isStartGreaterEnd) {
                    switch (this.getPlacement()) {
                        case Outside: {
                            double x = parentRest * (1.0 - percentOffset);
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(centerRect.x - parentRest - maxThisWidth, centerRect.y, parentRest + maxThisWidth - x, actualWidth);
                                geomMinWidth = finishRect.width - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                                break;
                            }
                            if (maxThisWidth > parentRest + minThisWidth) {
                                double x1 = (maxThisWidth - minThisWidth - parentRest) * (1.0 - percentOffset);
                                finishRect = new StiRectangle(centerRect.x - maxThisWidth + x1, centerRect.y, maxThisWidth - x - x1, actualWidth);
                                geomHelper.offset = parentRest * percentOffset;
                                break;
                            }
                            finishRect = new StiRectangle(rect.x - minThisWidth, rect.y, parentRest + minThisWidth - x, actualWidth);
                            geomMaxWidth = finishRect.width - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                        case Overlay: {
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0, centerRect.y, maxThisWidth, actualWidth);
                                geomHelper.offset = (maxThisWidth - minThisWidth) / 2.0 * percentOffset;
                                break;
                            }
                            double x = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                            finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0 + x, centerRect.y, maxThisWidth - 2.0 * x, actualWidth);
                            break;
                        }
                        default: {
                            double x = parentRest * (1.0 - percentOffset);
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(centerRect.getRight() + x, centerRect.y, parentRest + maxThisWidth - x, actualWidth);
                                geomMinWidth = finishRect.width - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                                break;
                            }
                            if (maxThisWidth > parentRest + minThisWidth) {
                                double x1 = (maxThisWidth - parentRest - minThisWidth) * (1.0 - percentOffset);
                                finishRect = new StiRectangle(centerRect.getRight() + x, centerRect.y, maxThisWidth - x - x1, actualWidth);
                                geomMaxWidth = (maxThisWidth - parentRest - minThisWidth) * percentOffset;
                                geomHelper.offset = parentRest * percentOffset;
                                break;
                            }
                            finishRect = new StiRectangle(centerRect.getRight() + x, centerRect.y, parentRest + minThisWidth - x, actualWidth);
                            geomMaxWidth = finishRect.width - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                    }
                } else {
                    switch (this.getPlacement()) {
                        case Outside: {
                            if (isThisStartGreaterEnd) {
                                if (maxThisWidth > parentRest + minThisWidth) {
                                    finishRect = new StiRectangle(centerRect.x - maxThisWidth, centerRect.y, maxThisWidth, actualWidth);
                                    geomHelper.offset = parentRest * percentOffset;
                                    geomMinWidth = finishRect.width - geomHelper.offset - (maxThisWidth - minimum - parentRest) * (1.0 - percentOffset);
                                    break;
                                }
                                double x = (parentRest + minThisWidth - maxThisWidth) * (1.0 - percentOffset);
                                finishRect = new StiRectangle(centerRect.x - parentRest - minThisWidth + x, centerRect.y, parentRest + minThisWidth - x, actualWidth);
                                geomMinWidth = finishRect.width - parentRest * percentOffset;
                                geomHelper.state = true;
                                break;
                            }
                            double x = (parentRest + maxThisWidth - minThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x - parentRest - maxThisWidth + x, centerRect.y, parentRest + maxThisWidth - x, actualWidth);
                            geomMaxWidth = finishRect.width - parentRest * percentOffset;
                            break;
                        }
                        case Overlay: {
                            if (isThisStartGreaterEnd) {
                                finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0, centerRect.y, maxThisWidth, actualWidth);
                                geomHelper.offset = (maxThisWidth - minThisWidth) / 2.0 * percentOffset;
                                break;
                            }
                            double x = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                            finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0 + x, centerRect.y, maxThisWidth - 2.0 * x, actualWidth);
                            break;
                        }
                        default: {
                            if (isThisStartGreaterEnd) {
                                if (maxThisWidth > parentRest + minThisWidth) {
                                    finishRect = new StiRectangle(centerRect.getRight(), centerRect.y, maxThisWidth, actualWidth);
                                    geomHelper.offset = parentRest * percentOffset;
                                    geomMinWidth = finishRect.width - geomHelper.offset - (maxThisWidth - minThisWidth - parentRest) * percentOffset;
                                    break;
                                }
                                double x = (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                                finishRect = new StiRectangle(centerRect.getRight(), centerRect.y, parentRest + minThisWidth - x, actualWidth);
                                geomMinWidth = finishRect.width - parentRest * percentOffset;
                                geomHelper.state = true;
                                break;
                            }
                            double x = (parentRest + maxThisWidth - minThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.getRight(), rect.y, parentRest + maxThisWidth - x, actualWidth);
                            geomMaxWidth = finishRect.width - parentRest * percentOffset;
                            break;
                        }
                    }
                }
            } else if (isStartGreaterEnd) {
                switch (this.getPlacement()) {
                    case Outside: {
                        if (isThisStartGreaterEnd) {
                            double x = parentRest * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x - parentRest - maxThisWidth, centerRect.y + (rect.height - actualWidth), parentRest + maxThisWidth - x, actualWidth);
                            geomMinWidth = finishRect.width - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                            break;
                        }
                        double x = parentRest * (1.0 - percentOffset);
                        if (maxThisWidth > parentRest + minThisWidth) {
                            double x1 = (maxThisWidth - parentRest - minThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.x - maxThisWidth + x1, centerRect.y + (rect.height - actualWidth), maxThisWidth - x - x1, actualWidth);
                            geomHelper.offset = parentRest * percentOffset;
                            break;
                        }
                        finishRect = new StiRectangle(centerRect.x - parentRest - minThisWidth, centerRect.y + (rect.height - actualWidth), parentRest + minThisWidth - x, actualWidth);
                        geomMaxWidth = finishRect.width - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                        geomHelper.state = true;
                        break;
                    }
                    case Overlay: {
                        if (isThisStartGreaterEnd) {
                            finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0, centerRect.y + (rect.height - actualWidth), maxThisWidth, actualWidth);
                            geomHelper.offset = (maxThisWidth - minThisWidth) / 2.0 * percentOffset;
                            break;
                        }
                        double x = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                        finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0 + x, centerRect.y + (rect.height - actualWidth), maxThisWidth - 2.0 * x, actualWidth);
                        break;
                    }
                    default: {
                        double x = parentRest * (1.0 - percentOffset);
                        if (isThisStartGreaterEnd) {
                            finishRect = new StiRectangle(centerRect.getRight() + x, centerRect.y + (rect.height - actualWidth), maxThisWidth + parentRest - x, actualWidth);
                            geomMinWidth = finishRect.width - (parentRest + maxThisWidth - minThisWidth) * percentOffset;
                            break;
                        }
                        if (maxThisWidth >= parentRest + minThisWidth) {
                            double x1 = (maxThisWidth - parentRest - minThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(centerRect.getRight() + x, centerRect.y + (rect.height - actualWidth), maxThisWidth - x - x1, actualWidth);
                            geomHelper.offset = (maxThisWidth - parentRest - minThisWidth) * percentOffset;
                            break;
                        }
                        finishRect = new StiRectangle(centerRect.getRight() + x, centerRect.y + (rect.height - actualWidth), parentRest + minThisWidth - x, actualWidth);
                        geomMaxWidth = finishRect.width - (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                        geomHelper.state = true;
                        break;
                    }
                }
            } else {
                switch (this.getPlacement()) {
                    case Outside: {
                        if (isThisStartGreaterEnd) {
                            if (maxThisWidth > parentRest + minThisWidth) {
                                finishRect = new StiRectangle(centerRect.x - maxThisWidth, centerRect.y + (rect.height - actualWidth), maxThisWidth, actualWidth);
                                geomHelper.offset = parentRest * percentOffset;
                                double x = (maxThisWidth - minThisWidth - parentRest) * percentOffset;
                                geomMinWidth = finishRect.width - geomHelper.offset - x;
                                break;
                            }
                            double x = (parentRest + minThisWidth - maxThisWidth) * (1.0 - percentOffset);
                            finishRect = new StiRectangle(rect.x - minThisWidth + x, rect.y + (rect.height - actualWidth), parentRest + minThisWidth - x, actualWidth);
                            geomMinWidth = finishRect.width - parentRest * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                        double x = (parentRest + maxThisWidth - minThisWidth) * (1.0 - percentOffset);
                        finishRect = new StiRectangle(rect.x - maxThisWidth + x, rect.y + (rect.height - actualWidth), maxThisWidth + parentRest - x, actualWidth);
                        geomMaxWidth = finishRect.width - parentRest * percentOffset;
                        break;
                    }
                    case Overlay: {
                        if (isThisStartGreaterEnd) {
                            finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0, rect.y + (rect.height - actualWidth), maxThisWidth, actualWidth);
                            geomHelper.offset = (maxThisWidth - minThisWidth) * percentOffset / 2.0;
                            break;
                        }
                        double x = (maxThisWidth - minThisWidth) / 2.0 * (1.0 - percentOffset);
                        finishRect = new StiRectangle(StiRectangleHelper.centerX(centerRect) - maxThisWidth / 2.0 + x, rect.y + (rect.height - actualWidth), maxThisWidth - 2.0 * x, actualWidth);
                        break;
                    }
                    default: {
                        if (isThisStartGreaterEnd) {
                            if (maxThisWidth > parentRest + minThisWidth) {
                                finishRect = new StiRectangle(centerRect.getRight(), rect.y + (rect.height - actualWidth), maxThisWidth, actualWidth);
                                geomHelper.offset = parentRest * percentOffset;
                                geomMinWidth = finishRect.width - geomHelper.offset - (maxThisWidth - parentRest - minThisWidth) * percentOffset;
                                break;
                            }
                            double x = (parentRest + minThisWidth - maxThisWidth) * percentOffset;
                            finishRect = new StiRectangle(centerRect.getRight(), rect.y + (rect.height - actualWidth), parentRest + minThisWidth - x, actualWidth);
                            geomMinWidth = finishRect.width - parentRest * percentOffset;
                            geomHelper.state = true;
                            break;
                        }
                        double x = (parentRest + maxThisWidth - minThisWidth) * (1.0 - percentOffset);
                        finishRect = new StiRectangle(centerRect.getRight(), rect.y + (rect.height - actualWidth), parentRest + maxThisWidth - x, actualWidth);
                        geomMaxWidth = finishRect.width - parentRest * percentOffset;
                    }
                }
            }
        }
        geomHelper.rect = finishRect;
        geomHelper.isStartGreaterEnd = isStartGreaterEnd;
        geomHelper.isThisStartGreaterEnd = isThisStartGreaterEnd;
        geomHelper.scale = linearScale;
        geomHelper.maxWidth = geomMaxWidth == null ? maxThisWidth : geomMaxWidth;
        geomHelper.minWidth = geomMinWidth == null ? minThisWidth : geomMinWidth;
        return geomHelper;
    }

    private StiGraphicsPathLinesGaugeGeom getTopGeometry(LinearBarGeometryHelper helper, StiRefObject<StiRectangle> rect) {
        rect.argvalue = new StiRectangle(0.0, 0.0, helper.rect.width, helper.rect.height);
        StiPoint[] points = new StiPoint[4];
        if (helper.scale.getOrientation() == StiOrientation.Horizontal) {
            if (helper.scale.getIsReversed()) {
                if (helper.isStartGreaterEnd) {
                    if (helper.isThisStartGreaterEnd) {
                        switch (this.getPlacement()) {
                            case Outside: {
                                points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.maxWidth);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            case Overlay: {
                                points[0] = new StiPoint(0.0, (((StiRectangle)rect.argvalue).height - helper.minWidth) / 2.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - (((StiRectangle)rect.argvalue).height - helper.minWidth) / 2.0);
                                break;
                            }
                            default: {
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                                points[3] = new StiPoint(0.0, helper.minWidth);
                                break;
                            }
                        }
                    } else {
                        switch (this.getPlacement()) {
                            case Outside: {
                                if (helper.state) {
                                    points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                                    points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                                    points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.minWidth);
                                    points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                    break;
                                }
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.offset - helper.minWidth);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.offset);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            case Overlay: {
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            default: {
                                if (helper.state) {
                                    points[0] = new StiPoint(0.0, 0.0);
                                    points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                                    points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                                    points[3] = new StiPoint(0.0, helper.maxWidth);
                                    break;
                                }
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.offset - helper.minWidth);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.offset);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                        }
                    }
                } else if (helper.isThisStartGreaterEnd) {
                    switch (this.getPlacement()) {
                        case Outside: {
                            if (helper.state) {
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                                points[3] = new StiPoint(0.0, helper.minWidth);
                                break;
                            }
                            points[0] = new StiPoint(0.0, helper.offset);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.minWidth + helper.offset);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                            break;
                        }
                        default: {
                            if (helper.state) {
                                points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.maxWidth);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            points[0] = new StiPoint(0.0, helper.offset);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.offset + helper.minWidth);
                            break;
                        }
                    }
                } else {
                    switch (this.getPlacement()) {
                        case Outside: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.maxWidth);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.minWidth);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                    }
                }
            } else if (helper.isStartGreaterEnd) {
                if (helper.isThisStartGreaterEnd) {
                    switch (this.getPlacement()) {
                        case Outside: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.maxWidth);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.minWidth);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                    }
                } else {
                    switch (this.getPlacement()) {
                        case Outside: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.minWidth);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                            break;
                        }
                        default: {
                            if (helper.state) {
                                points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.maxWidth);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            points[0] = new StiPoint(0.0, helper.offset);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.offset + helper.minWidth);
                            break;
                        }
                    }
                }
            } else if (helper.isThisStartGreaterEnd) {
                switch (this.getPlacement()) {
                    case Outside: {
                        if (helper.state) {
                            points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.minWidth);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.offset);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.offset + helper.minWidth);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    default: {
                        if (helper.state) {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, helper.maxWidth);
                            break;
                        }
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.offset);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.offset + helper.minWidth);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                }
            } else {
                switch (this.getPlacement()) {
                    case Outside: {
                        points[0] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height - helper.minWidth);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, helper.maxWidth);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(0.0, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) - helper.minWidth / 2.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, StiRectangleHelper.centerY((StiRectangle)rect.argvalue) + helper.minWidth / 2.0);
                        break;
                    }
                    default: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height - helper.maxWidth);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, helper.minWidth);
                        break;
                    }
                }
            }
        } else if (helper.scale.getIsReversed()) {
            if (helper.isStartGreaterEnd) {
                if (helper.isThisStartGreaterEnd) {
                    switch (this.getPlacement()) {
                        case Outside: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(helper.maxWidth, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(helper.offset, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        default: {
                            points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(helper.minWidth, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                    }
                } else {
                    switch (this.getPlacement()) {
                        case Outside: {
                            if (helper.state) {
                                points[0] = new StiPoint(0.0, 0.0);
                                points[1] = new StiPoint(helper.minWidth, 0.0);
                                points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                                points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset - helper.minWidth, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        case Overlay: {
                            points[0] = new StiPoint((((StiRectangle)rect.argvalue).width - helper.minWidth) / 2.0, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width - (((StiRectangle)rect.argvalue).width - helper.minWidth) / 2.0, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        default: {
                            if (helper.state) {
                                points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, 0.0);
                                points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                                points[2] = new StiPoint(helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                                points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                                break;
                            }
                            points[0] = new StiPoint(helper.offset, 0.0);
                            points[1] = new StiPoint(helper.offset + helper.minWidth, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                    }
                }
            } else if (helper.isThisStartGreaterEnd) {
                switch (this.getPlacement()) {
                    case Outside: {
                        if (helper.state) {
                            points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(helper.minWidth, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(helper.offset, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    default: {
                        if (helper.state) {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(helper.maxWidth, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(helper.offset + helper.minWidth, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(helper.offset, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                }
            } else {
                switch (this.getPlacement()) {
                    case Outside: {
                        points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint((((StiRectangle)rect.argvalue).width - helper.minWidth) / 2.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width - (((StiRectangle)rect.argvalue).width - helper.minWidth) / 2.0, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    default: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(helper.minWidth, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                }
            }
        } else if (helper.isStartGreaterEnd) {
            if (helper.isThisStartGreaterEnd) {
                switch (this.getPlacement()) {
                    case Outside: {
                        points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(helper.offset, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    default: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(helper.minWidth, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                }
            } else {
                switch (this.getPlacement()) {
                    case Outside: {
                        if (helper.state) {
                            points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, 0.0);
                            points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                            points[2] = new StiPoint(helper.minWidth, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    case Overlay: {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width - (((StiRectangle)rect.argvalue).width - helper.minWidth) / 2.0, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint((((StiRectangle)rect.argvalue).width - helper.minWidth) / 2.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    default: {
                        if (helper.state) {
                            points[0] = new StiPoint(0.0, 0.0);
                            points[1] = new StiPoint(helper.maxWidth, 0.0);
                            points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                            points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                            break;
                        }
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                }
            }
        } else if (helper.isThisStartGreaterEnd) {
            switch (this.getPlacement()) {
                case Outside: {
                    if (helper.state) {
                        points[0] = new StiPoint(0.0, 0.0);
                        points[1] = new StiPoint(helper.minWidth, 0.0);
                        points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset - helper.minWidth, 0.0);
                    points[1] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, 0.0);
                    points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                    points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                    break;
                }
                case Overlay: {
                    points[0] = new StiPoint(helper.offset, 0.0);
                    points[1] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.offset, 0.0);
                    points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                    points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                    break;
                }
                default: {
                    if (helper.state) {
                        points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, 0.0);
                        points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                        points[2] = new StiPoint(helper.maxWidth, ((StiRectangle)rect.argvalue).height);
                        points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                        break;
                    }
                    points[0] = new StiPoint(helper.offset, 0.0);
                    points[1] = new StiPoint(helper.offset + helper.minWidth, 0.0);
                    points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                    points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                    break;
                }
            }
        } else {
            switch (this.getPlacement()) {
                case Outside: {
                    points[0] = new StiPoint(0.0, 0.0);
                    points[1] = new StiPoint(helper.maxWidth, 0.0);
                    points[2] = new StiPoint(((StiRectangle)rect.argvalue).width, ((StiRectangle)rect.argvalue).height);
                    points[3] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.minWidth, ((StiRectangle)rect.argvalue).height);
                    break;
                }
                case Overlay: {
                    points[0] = new StiPoint(0.0, 0.0);
                    points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                    points[2] = new StiPoint(StiRectangleHelper.centerX((StiRectangle)rect.argvalue) + helper.minWidth / 2.0, ((StiRectangle)rect.argvalue).height);
                    points[3] = new StiPoint(StiRectangleHelper.centerX((StiRectangle)rect.argvalue) - helper.minWidth / 2.0, ((StiRectangle)rect.argvalue).height);
                    break;
                }
                default: {
                    points[0] = new StiPoint(((StiRectangle)rect.argvalue).width - helper.maxWidth, 0.0);
                    points[1] = new StiPoint(((StiRectangle)rect.argvalue).width, 0.0);
                    points[2] = new StiPoint(helper.minWidth, ((StiRectangle)rect.argvalue).height);
                    points[3] = new StiPoint(0.0, ((StiRectangle)rect.argvalue).height);
                }
            }
        }
        double left = helper.rect.getLeft();
        double top = helper.rect.getTop();
        double value = this.scale.barGeometry.getSize().width * this.getOffset();
        if (helper.scale.getOrientation() == StiOrientation.Horizontal) {
            top = this.getPlacement() == StiPlacement.Outside ? (top -= value) : (top += value);
        } else {
            left = this.getPlacement() == StiPlacement.Outside ? (left -= value) : (left += value);
        }
        points[0].x += left;
        points[1].x += left;
        points[2].x += left;
        points[3].x += left;
        points[0].y += top;
        points[1].y += top;
        points[2].y += top;
        points[3].y += top;
        return new StiGraphicsPathLinesGaugeGeom(points);
    }

    private class LinearBarGeometryHelper {
        public StiRectangle rect;
        public double maxWidth;
        public double minWidth;
        public boolean isStartGreaterEnd;
        public boolean isThisStartGreaterEnd;
        public StiLinearScale scale;
        public boolean state = false;
        public double offset = 0.0;

        private LinearBarGeometryHelper() {
        }
    }

    private class LinearColorModeHelper {
        public boolean standardBackground = false;
        public int defaultIndex = -99;
        public int mixedColorIndex = -99;

        private LinearColorModeHelper() {
        }

        public void Reset() {
            this.standardBackground = false;
            this.defaultIndex = -99;
            this.mixedColorIndex = -99;
        }
    }
}

