/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.helpers;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.infographics.gauge.StiGauge;
import com.stimulsoft.report.infographics.gauge.StiGaugeCalculationMode;
import com.stimulsoft.report.infographics.gauge.StiGaugeType;
import com.stimulsoft.report.infographics.gauge.StiPlacement;
import com.stimulsoft.report.infographics.gauge.StiRadiusMode;
import com.stimulsoft.report.infographics.gauge.StiScaleMode;
import com.stimulsoft.report.infographics.gauge.StiTickMarkSkin;
import com.stimulsoft.report.infographics.gauge.helpers.StiGaugeHelper;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearBar;
import com.stimulsoft.report.infographics.gauge.indicators.StiLinearMarker;
import com.stimulsoft.report.infographics.gauge.indicators.StiNeedle;
import com.stimulsoft.report.infographics.gauge.indicators.StiRadialBar;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.indicators.StiIndicatorBase;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiRangeBase;
import com.stimulsoft.report.infographics.gauge.primitives.range.StiScaleRangeList;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.range.StiLinearRange;
import com.stimulsoft.report.infographics.gauge.range.StiLinearRangeList;
import com.stimulsoft.report.infographics.gauge.scales.StiLinearScale;
import com.stimulsoft.report.infographics.gauge.scales.StiRadialScale;
import com.stimulsoft.report.infographics.gauge.tick.linear.label.StiLinearTickLabelMajor;
import com.stimulsoft.report.infographics.gauge.tick.linear.mark.StiLinearTickMarkMajor;
import com.stimulsoft.report.infographics.gauge.tick.radial.label.StiRadialTickLabelMajor;
import com.stimulsoft.report.infographics.gauge.tick.radial.mark.StiRadialTickMarkMajor;

public class StiGaugeV2InitHelper {
    public static boolean isGaugeV2(StiGauge gauge) {
        if (gauge.getMode() == StiScaleMode.V1) {
            return false;
        }
        if (gauge.getScales().size() != 1) {
            return false;
        }
        StiScaleBase scale = (StiScaleBase)gauge.getScales().get(0);
        switch (gauge.getType()) {
            case FullCircular: {
                return StiGaugeV2InitHelper.isFullCircularScale(scale);
            }
            case HalfCircular: {
                return StiGaugeV2InitHelper.isHalfCircularScale(scale);
            }
            case Linear: 
            case HorizontalLinear: {
                return StiGaugeV2InitHelper.isLinearScale(scale);
            }
            case Bullet: {
                return StiGaugeV2InitHelper.isBulletScale(scale);
            }
        }
        return false;
    }

    public static void init(StiGauge gauge, StiGaugeType type, boolean addRange, boolean skipText) {
        String indicatorValue = null;
        StiIndicatorBase indicator = null;
        if (gauge.getScales().size() > 0) {
            StiGaugeElement tempVar = ((StiScaleBase)gauge.getScales().get(0)).getItems().stream().filter(x -> x instanceof StiIndicatorBase).findFirst().orElseGet(null);
            StiIndicatorBase stiIndicatorBase = indicator = tempVar instanceof StiIndicatorBase ? (StiIndicatorBase)tempVar : null;
            if (indicator != null && indicator.getValue() != null) {
                indicatorValue = indicator.getValue().getValue();
            }
        }
        StiScaleBase scale = null;
        switch (type) {
            case FullCircular: {
                scale = StiGaugeV2InitHelper.createFullCircularScale(skipText);
                break;
            }
            case HalfCircular: {
                scale = StiGaugeV2InitHelper.createHalfCircularScale(skipText);
                break;
            }
            case Linear: {
                scale = StiGaugeV2InitHelper.createLinearScale(skipText, false);
                break;
            }
            case HorizontalLinear: {
                scale = StiGaugeV2InitHelper.createLinearScale(skipText, true);
                break;
            }
            case Bullet: {
                scale = StiGaugeV2InitHelper.createBullet(gauge, addRange, skipText);
            }
        }
        if (!StiValidationUtil.isNullOrEmpty(indicatorValue)) {
            StiIndicatorBase tempVar2 = (StiIndicatorBase)scale.getItems().stream().filter(x -> x instanceof StiIndicatorBase).findFirst().orElseGet(null);
            indicator = tempVar2 instanceof StiIndicatorBase ? tempVar2 : null;
            indicator.getValue().setValue(indicatorValue);
        }
        gauge.getScales().clear();
        gauge.getScales().add(scale);
    }

    public static void getScaleMinMax(StiGaugeType type, StiRefObject<Double> min, StiRefObject<Double> max) {
        switch (type) {
            case FullCircular: {
                min.argvalue = 0.0;
                max.argvalue = 180.0;
                break;
            }
            case HalfCircular: {
                min.argvalue = 0.0;
                max.argvalue = 150.0;
                break;
            }
            case Linear: 
            case HorizontalLinear: 
            case Bullet: {
                min.argvalue = 0.0;
                max.argvalue = 100.0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static void prepare(StiGauge gauge) {
        if (StiGaugeV2InitHelper.isGaugeV2(gauge)) {
            StiScaleBase scale = (StiScaleBase)gauge.getScales().get(0);
            StiIndicatorBase indicator = (StiIndicatorBase)scale.getItems().stream().filter(x -> x instanceof StiIndicatorBase).findFirst().orElseGet(null);
            if (indicator != null) {
                StiGetValueEventArgs e = new StiGetValueEventArgs();
                indicator.InvokeGetValue(indicator, e);
                double value = StiGaugeHelper.getFloatValueFromObject((Object)e.getValue(), scale);
                scale.getItems().stream().filter(x -> x instanceof StiIndicatorBase).forEach(x -> ((StiIndicatorBase)x).setValueObj(value));
                if (gauge.getCalculationMode() == StiGaugeCalculationMode.Auto) {
                    if (value == 0.0) {
                        scale.setMinimum(0.0);
                        scale.setMaximum(100.0);
                    } else {
                        scale.setMinimum(value - Math.abs(value));
                        scale.setMaximum(value + Math.abs(value));
                    }
                } else {
                    scale.setMinimum(gauge.getMinimum());
                    scale.setMaximum(gauge.getMaximum());
                }
                StiScaleRangeList rangeList = null;
                for (StiGaugeElement item : scale.getItems()) {
                    if (!(item instanceof StiScaleRangeList)) continue;
                    rangeList = (StiScaleRangeList)item;
                    break;
                }
                if (rangeList != null && rangeList.getRanges().size() > 0) {
                    double min = scale.getMinimum();
                    double totalLength = Math.max(scale.getMaximum(), scale.getMinimum()) - Math.min(scale.getMaximum(), scale.getMinimum());
                    double step = Math.rint(totalLength / (double)rangeList.getRanges().size());
                    double startValue = min;
                    for (StiRangeBase range : rangeList.getRanges()) {
                        range.setStartValue(startValue);
                        range.setEndValue(startValue += step);
                    }
                    ((StiRangeBase)rangeList.getRanges().get(rangeList.getRanges().size() - 1)).setEndValue(scale.getMaximum());
                }
                double sum = scale.getMaximum() - scale.getMinimum();
                scale.setMajorInterval(Math.abs(Math.rint(sum / 10.0)));
                scale.setMinorInterval(Math.abs(scale.getMajorInterval() / 2.0));
                scale.calculateMinMaxScaleHelper();
                scale.calculateWidthScaleHelper();
            }
        } else {
            for (StiScaleBase scale : gauge.getScales()) {
                scale.calculateMinMaxScaleHelper();
                scale.calculateWidthScaleHelper();
            }
        }
    }

    private static boolean isFullCircularScale(StiScaleBase scale) {
        if (!(scale instanceof StiRadialScale)) {
            return false;
        }
        return scale.getItems().size() >= 3;
    }

    private static StiScaleBase createFullCircularScale(boolean skipText) {
        StiRadialScale scale = new StiRadialScale();
        scale.setStartAngle(120.0);
        scale.setSweepAngle(300.0);
        scale.setStartWidth(0.05);
        scale.setEndWidth(0.05);
        scale.setMinimum(0.0);
        scale.setMaximum(180.0);
        scale.setMajorInterval(90.0);
        scale.setMinorInterval(10.0);
        scale.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        if (!skipText) {
            StiRadialTickMarkMajor tempVar = new StiRadialTickMarkMajor();
            tempVar.setPlacement(StiPlacement.Inside);
            tempVar.setRelativeWidth(0.05);
            tempVar.setRelativeHeight(0.015);
            tempVar.setSkin(StiTickMarkSkin.Rectangle);
            tempVar.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Black.color()));
            scale.getItems().add(tempVar);
        }
        if (!skipText) {
            StiRadialTickLabelMajor tempVar2 = new StiRadialTickLabelMajor();
            tempVar2.setOffset(0.1);
            tempVar2.setPlacement(StiPlacement.Inside);
            scale.getItems().add(tempVar2);
        }
        StiNeedle needle = new StiNeedle();
        needle.setRelativeHeight(0.3);
        needle.setRelativeWidth(0.4);
        needle.setStartWidth(0.1);
        needle.setEndWidth(1.0);
        needle.setCapBrush((StiBrush)new StiEmptyBrush());
        needle.setBrush((StiBrush)new StiEmptyBrush());
        needle.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle.setValueObj(85.0);
        needle.getValue().setValue("85");
        scale.getItems().add(needle);
        StiRadialBar radialBar = new StiRadialBar();
        radialBar.setStartWidth(0.1);
        radialBar.setEndWidth(0.1);
        radialBar.setOffset(0.1);
        radialBar.setPlacement(StiPlacement.Outside);
        radialBar.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Red.color()));
        radialBar.setValueObj(85.0);
        radialBar.getValue().setValue("85");
        scale.getItems().add(radialBar);
        return scale;
    }

    private static boolean isHalfCircularScale(StiScaleBase scale) {
        StiRadialBar radialBar;
        if (!(scale instanceof StiRadialScale)) {
            return false;
        }
        if (scale.getItems().size() == 2) {
            if (!(scale.getItems().get(0) instanceof StiNeedle)) {
                return false;
            }
            if (!(scale.getItems().get(1) instanceof StiRadialBar)) {
                return false;
            }
        } else if (scale.getItems().size() == 4) {
            if (!(scale.getItems().get(2) instanceof StiNeedle)) {
                return false;
            }
            if (!(scale.getItems().get(3) instanceof StiRadialBar)) {
                return false;
            }
        } else {
            return false;
        }
        StiRadialBar stiRadialBar = radialBar = scale.getItems().size() == 2 ? (StiRadialBar)scale.getItems().get(1) : (StiRadialBar)scale.getItems().get(3);
        return radialBar.getRangeList().size() == 0;
    }

    private static StiScaleBase createHalfCircularScale(boolean skipText) {
        StiRadialScale scale = new StiRadialScale();
        scale.setStartAngle(180.0);
        scale.setSweepAngle(180.0);
        scale.setStartWidth(0.05);
        scale.setEndWidth(0.05);
        scale.setMinimum(0.0);
        scale.setMaximum(180.0);
        scale.setRadius(0.8);
        scale.setMajorInterval(90.0);
        scale.setMinorInterval(10.0);
        scale.setCenter(new StiPoint(0.5, 0.7));
        scale.setRadiusMode(StiRadiusMode.Auto);
        scale.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)238, (int)238, (int)238)));
        if (!skipText) {
            StiRadialTickMarkMajor tickMark = new StiRadialTickMarkMajor();
            tickMark.setOffset(0.05);
            tickMark.setRelativeWidth(0.03);
            tickMark.setRelativeHeight(0.006);
            tickMark.setSkin(StiTickMarkSkin.Rectangle);
            tickMark.setPlacement(StiPlacement.Inside);
            scale.getItems().add(tickMark);
            StiRadialTickLabelMajor radialTickLabelMajor = new StiRadialTickLabelMajor();
            radialTickLabelMajor.setPlacement(StiPlacement.Inside);
            radialTickLabelMajor.setOffset(0.12);
            radialTickLabelMajor.setAllowApplyStyle(false);
            scale.getItems().add(radialTickLabelMajor);
        }
        StiNeedle needle = new StiNeedle();
        needle.setRelativeHeight(0.05);
        needle.setRelativeWidth(0.4);
        needle.setStartWidth(0.1);
        needle.setEndWidth(0.2);
        needle.setCapBrush((StiBrush)new StiSolidBrush(StiColorEnum.White.color()));
        needle.setCapBorderBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle.setCapBorderWidth(2.0);
        needle.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle.setBorderWidth(0.0);
        needle.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)0, (int)150, (int)136)));
        needle.setValueObj(85.0);
        needle.getValue().setValue("85");
        scale.getItems().add(needle);
        StiRadialBar radialBar = new StiRadialBar();
        radialBar.setStartWidth(0.05);
        radialBar.setEndWidth(0.0);
        radialBar.setOffset(0.1);
        radialBar.setPlacement(StiPlacement.Overlay);
        radialBar.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Red.color()));
        radialBar.setValueObj(85.0);
        radialBar.getValue().setValue("85");
        scale.getItems().add(radialBar);
        return scale;
    }

    private static boolean isBulletScale(StiScaleBase scale) {
        if (!(scale instanceof StiLinearScale)) {
            return false;
        }
        if (scale.getItems().size() != 3) {
            return false;
        }
        if (!(scale.getItems().get(0) instanceof StiLinearRangeList)) {
            return false;
        }
        if (!(scale.getItems().get(1) instanceof StiLinearTickLabelMajor)) {
            return false;
        }
        return scale.getItems().get(2) instanceof StiLinearBar;
    }

    private static boolean isLinearScale(StiScaleBase scale) {
        if (!(scale instanceof StiLinearScale)) {
            return false;
        }
        if (scale.getItems().size() != 3) {
            return false;
        }
        if (!(scale.getItems().get(0) instanceof StiLinearTickLabelMajor)) {
            return false;
        }
        if (!(scale.getItems().get(1) instanceof StiLinearTickMarkMajor)) {
            return false;
        }
        return scale.getItems().get(2) instanceof StiLinearMarker;
    }

    private static StiScaleBase createLinearScale(boolean skipText, boolean isHorizontal) {
        StiLinearScale scale = new StiLinearScale();
        scale.setOrientation(isHorizontal ? StiOrientation.Horizontal : StiOrientation.Vertical);
        scale.setStartWidth(0.1);
        scale.setEndWidth(0.1);
        scale.setMaximum(100.0);
        scale.setMinorInterval(5.0);
        scale.setBorderBrush((StiBrush)new StiEmptyBrush());
        scale.setBrush((StiBrush)new StiEmptyBrush());
        if (!skipText) {
            StiLinearTickLabelMajor tempVar = new StiLinearTickLabelMajor();
            tempVar.setPlacement(StiPlacement.Inside);
            tempVar.setFont(new StiFont("Arial", 8.0));
            tempVar.setTextBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
            scale.getItems().add(tempVar);
            StiLinearTickMarkMajor tempVar2 = new StiLinearTickMarkMajor();
            tempVar2.setBorderBrush((StiBrush)new StiEmptyBrush());
            tempVar2.setBorderWidth(0.0);
            tempVar2.setRelativeHeight(isHorizontal ? 0.05 : 0.005);
            tempVar2.setRelativeWidth(isHorizontal ? 0.005 : 0.05);
            tempVar2.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)158, (int)158, (int)158)));
            scale.getItems().add(tempVar2);
        }
        StiLinearMarker marker = new StiLinearMarker();
        marker.setRelativeWidth(0.1);
        marker.setRelativeHeight(0.04);
        marker.setPlacement(StiPlacement.Overlay);
        marker.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)205, (int)220, (int)57)));
        marker.setValueObj(85.0);
        marker.getValue().setValue("85");
        scale.getItems().add(marker);
        if (skipText) {
            marker.setRelativeWidth(0.07);
            marker.setRelativeHeight(0.08);
        }
        return scale;
    }

    private static StiScaleBase createBullet(StiGauge gauge, boolean addRange, boolean skipText) {
        StiLinearScale scale = new StiLinearScale();
        scale.setOrientation(StiOrientation.Horizontal);
        scale.setRelativeHeight(0.85);
        scale.setStartWidth(0.01);
        scale.setEndWidth(0.01);
        scale.setMaximum(100.0);
        scale.setBorderBrush((StiBrush)new StiEmptyBrush());
        scale.setBrush((StiBrush)new StiEmptyBrush());
        if (addRange) {
            StiGaugeV2InitHelper.addLinearRanges(0.0, 100.0, scale);
        }
        if (!skipText) {
            StiLinearTickLabelMajor tempVar = new StiLinearTickLabelMajor();
            tempVar.formatService = gauge.valueFormat;
            tempVar.setPlacement(StiPlacement.Outside);
            tempVar.setOffset(0.25);
            scale.getItems().add(tempVar);
        }
        StiLinearBar marker = new StiLinearBar();
        marker.setStartWidth(0.15);
        marker.setEndWidth(0.15);
        marker.setBrush((StiBrush)new StiSolidBrush(StiColor.fromArgb((int)205, (int)220, (int)57)));
        marker.setValueObj(85.0);
        marker.getValue().setValue("85");
        scale.getItems().add(marker);
        return scale;
    }

    private static void addLinearRanges(double minValue, double maxValue, StiLinearScale scale) {
        StiLinearRangeList list = new StiLinearRangeList();
        StiLinearRange linearRange1 = new StiLinearRange();
        linearRange1.setPlacement(StiPlacement.Overlay);
        linearRange1.setStartValue(minValue + (maxValue - minValue) * 0.0);
        linearRange1.setEndValue(minValue + (maxValue - minValue) * 0.3);
        linearRange1.setStartWidth(0.3);
        linearRange1.setEndWidth(0.3);
        linearRange1.setBorderBrush((StiBrush)new StiEmptyBrush());
        linearRange1.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Red.color()));
        list.getRanges().add(linearRange1);
        StiLinearRange linearRange2 = new StiLinearRange();
        linearRange2.setPlacement(StiPlacement.Overlay);
        linearRange2.setStartValue(minValue + (maxValue - minValue) * 0.3);
        linearRange2.setEndValue(minValue + (maxValue - minValue) * 0.65);
        linearRange2.setStartWidth(0.3);
        linearRange2.setEndWidth(0.3);
        linearRange2.setBorderBrush((StiBrush)new StiEmptyBrush());
        linearRange2.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Yellow.color()));
        list.getRanges().add(linearRange2);
        StiLinearRange linearRange3 = new StiLinearRange();
        linearRange3.setPlacement(StiPlacement.Overlay);
        linearRange3.setStartValue(minValue + (maxValue - minValue) * 0.65);
        linearRange3.setEndValue(minValue + (maxValue - minValue) * 1.0);
        linearRange3.setStartWidth(0.3f);
        linearRange3.setEndWidth(0.3f);
        linearRange3.setBorderBrush((StiBrush)new StiEmptyBrush());
        linearRange3.setBrush((StiBrush)new StiSolidBrush(StiColorEnum.Green.color()));
        list.getRanges().add(linearRange3);
        scale.getItems().add(list);
    }
}

