/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools.pdf;

import com.stimulsoft.base.drawing.StiFontReader;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.export.tools.BitConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public class StiOpenTypeHelper {
    private final int TtfHeaderSize = 12;
    private static List<String> RequiredTablesNames = new ArrayList<String>();
    private static Hashtable<Integer, String> names;
    private final int ARG_1_AND_2_ARE_WORDS = 1;
    private final int WE_HAVE_A_SCALE = 8;
    private final int MORE_COMPONENTS = 32;
    private final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private final int WE_HAVE_A_TWO_BY_TWO = 128;

    public byte[] reduceFontSize(byte[] buff, String fontName, boolean remakeGlyphTable, int[] GlyphList, int[] GlyphRtfList) throws IOException {
        try {
            int[] data = new int[buff.length];
            for (int i = 0; i < buff.length; ++i) {
                data[i] = buff[i] & 0xFF;
            }
            StiFontReader.TtfInfo ttf = StiFontReader.ScanFontFile((int[])data, (String)fontName);
            if (ttf != null) {
                ArrayList<String> tablesNames = new ArrayList<String>(RequiredTablesNames);
                if (!ttf.Tables.containsKey("glyf")) {
                    if (ttf.Tables.containsKey("CFF ")) {
                        tablesNames.add("CFF ");
                    } else {
                        remakeGlyphTable = false;
                    }
                }
                int numTablesRequired = 0;
                for (String table : ttf.Tables.keySet()) {
                    if (!tablesNames.contains(table)) continue;
                    ++numTablesRequired;
                }
                Hashtable<String, NewTableItem> newTables = new Hashtable<String, NewTableItem>();
                if (remakeGlyphTable) {
                    int glyphNumber;
                    int indexGlyph;
                    boolean[] glyphNeeds = new boolean[ttf.Maxp.NumGlyphs];
                    boolean[] glyphNeedsScan = new boolean[ttf.Maxp.NumGlyphs];
                    for (indexGlyph = 0; indexGlyph < GlyphList.length; ++indexGlyph) {
                        glyphNumber = GlyphList[indexGlyph];
                        if (glyphNumber >= ttf.Maxp.NumGlyphs) continue;
                        glyphNeeds[glyphNumber] = true;
                        glyphNeedsScan[glyphNumber] = true;
                    }
                    if (GlyphRtfList != null) {
                        for (indexGlyph = 0; indexGlyph < GlyphRtfList.length; ++indexGlyph) {
                            glyphNumber = GlyphRtfList[indexGlyph];
                            if (glyphNumber >= ttf.Maxp.NumGlyphs) continue;
                            glyphNeeds[glyphNumber] = true;
                            glyphNeedsScan[glyphNumber] = true;
                        }
                    }
                    if (GlyphRtfList != null) {
                        for (indexGlyph = 0; indexGlyph < GlyphRtfList.length; ++indexGlyph) {
                            glyphNumber = GlyphRtfList[indexGlyph];
                            if (glyphNumber >= ttf.Maxp.NumGlyphs) continue;
                            glyphNeeds[glyphNumber] = true;
                            glyphNeedsScan[glyphNumber] = true;
                        }
                    }
                    glyphNeeds[0] = true;
                    glyphNeeds[1] = true;
                    glyphNeeds[2] = true;
                    glyphNeeds[3] = true;
                    glyphNeedsScan[0] = true;
                    glyphNeedsScan[1] = true;
                    glyphNeedsScan[2] = true;
                    glyphNeedsScan[3] = true;
                    if (ttf.Tables.containsKey("glyf")) {
                        StiFontReader.Table locaTable = (StiFontReader.Table)ttf.Tables.get("loca");
                        StiFontReader.Table glyfTable = (StiFontReader.Table)ttf.Tables.get("glyf");
                        boolean needScan = true;
                        while (needScan) {
                            needScan = false;
                            for (int indexGlyph2 = 0; indexGlyph2 < ttf.Maxp.NumGlyphs; ++indexGlyph2) {
                                if (!glyphNeedsScan[indexGlyph2]) continue;
                                glyphNeedsScan[indexGlyph2] = false;
                                int locaOffsetScan = locaTable.Offset + indexGlyph2 * (ttf.Head.IndexToLocFormat == 1 ? 4 : 2);
                                int offsetGlyf = 0;
                                offsetGlyf = ttf.Head.IndexToLocFormat == 1 ? this.getUInt32(buff, locaOffsetScan) : 2 * this.getUInt16(buff, locaOffsetScan);
                                if (this.getInt16(buff, offsetGlyf += glyfTable.Offset) != -1) continue;
                                needScan = true;
                                offsetGlyf += 10;
                                int flags = 0;
                                do {
                                    flags = this.getUInt16(buff, offsetGlyf);
                                    int glyphIndex = this.getUInt16(buff, offsetGlyf + 2);
                                    if (glyphIndex < ttf.Maxp.NumGlyphs) {
                                        glyphNeeds[glyphIndex] = true;
                                        glyphNeedsScan[glyphIndex] = true;
                                    }
                                    offsetGlyf += 4;
                                    if ((flags & 1) > 0) {
                                        offsetGlyf += 2;
                                        offsetGlyf += 2;
                                    } else {
                                        offsetGlyf += 2;
                                    }
                                    if ((flags & 8) > 0) {
                                        offsetGlyf += 2;
                                        continue;
                                    }
                                    if ((flags & 0x40) > 0) {
                                        offsetGlyf += 2;
                                        offsetGlyf += 2;
                                        continue;
                                    }
                                    if ((flags & 0x80) <= 0) continue;
                                    offsetGlyf += 2;
                                    offsetGlyf += 2;
                                    offsetGlyf += 2;
                                    offsetGlyf += 2;
                                } while ((flags & 0x20) > 0);
                            }
                        }
                        int newLength = 0;
                        int locaOffset = locaTable.Offset;
                        for (int indexGlyph3 = 0; indexGlyph3 < ttf.Maxp.NumGlyphs; ++indexGlyph3) {
                            int offsetBegin = 0;
                            int offsetEnd = 0;
                            if (ttf.Head.IndexToLocFormat == 1) {
                                offsetBegin = this.getUInt32(buff, locaOffset);
                                offsetEnd = this.getUInt32(buff, locaOffset + 4);
                                locaOffset += 4;
                            } else {
                                offsetBegin = 2 * this.getUInt16(buff, locaOffset);
                                offsetEnd = 2 * this.getUInt16(buff, locaOffset + 2);
                                locaOffset += 2;
                            }
                            if (!glyphNeeds[indexGlyph3]) continue;
                            newLength += offsetEnd - offsetBegin;
                        }
                        byte[] newGlyfTable = new byte[newLength + 4];
                        if (glyfTable.Offset + glyfTable.Length + 4 < buff.length) {
                            System.arraycopy(buff, glyfTable.Offset + glyfTable.Length, newGlyfTable, newLength, 4);
                        }
                        Object newLocaTable = new byte[locaTable.Length + 4];
                        if (locaTable.Offset + locaTable.Length + 4 < buff.length) {
                            System.arraycopy(buff, locaTable.Offset + locaTable.Length, newLocaTable, locaTable.Length, 4);
                        }
                        int currentGlyfPos = 0;
                        locaOffset = locaTable.Offset;
                        int locaOffset2 = 0;
                        for (int indexGlyph4 = 0; indexGlyph4 < ttf.Maxp.NumGlyphs; ++indexGlyph4) {
                            int offsetBegin = 0;
                            int offsetEnd = 0;
                            if (ttf.Head.IndexToLocFormat == 1) {
                                offsetBegin = this.getUInt32(buff, locaOffset);
                                offsetEnd = this.getUInt32(buff, locaOffset + 4);
                                locaOffset += 4;
                            } else {
                                offsetBegin = 2 * this.getUInt16(buff, locaOffset);
                                offsetEnd = 2 * this.getUInt16(buff, locaOffset + 2);
                                locaOffset += 2;
                            }
                            int lengthGlyf = offsetEnd - offsetBegin;
                            if (glyphNeeds[indexGlyph4]) {
                                for (int indexPos = 0; indexPos < lengthGlyf; ++indexPos) {
                                    newGlyfTable[currentGlyfPos + indexPos] = buff[glyfTable.Offset + offsetBegin + indexPos];
                                }
                            } else {
                                lengthGlyf = 0;
                            }
                            if (ttf.Head.IndexToLocFormat == 0) {
                                this.setUInt16((byte[])newLocaTable, locaOffset2, currentGlyfPos / 2);
                            } else {
                                this.setUInt32((byte[])newLocaTable, locaOffset2, currentGlyfPos);
                            }
                            currentGlyfPos += lengthGlyf;
                            locaOffset2 += ttf.Head.IndexToLocFormat == 1 ? 4 : 2;
                        }
                        if (ttf.Head.IndexToLocFormat == 0) {
                            this.setUInt16((byte[])newLocaTable, locaOffset2, currentGlyfPos / 2);
                        } else {
                            this.setUInt32((byte[])newLocaTable, locaOffset2, currentGlyfPos);
                        }
                        NewTableItem newGlyfTableItem = new NewTableItem();
                        newGlyfTableItem.Tag = glyfTable.Tag;
                        newGlyfTableItem.NewLength = currentGlyfPos;
                        newGlyfTableItem.NewTable = newGlyfTable;
                        NewTableItem newLocaTableItem = new NewTableItem();
                        newLocaTableItem.Tag = locaTable.Tag;
                        newLocaTableItem.NewLength = locaTable.Length;
                        newLocaTableItem.NewTable = (byte[])newLocaTable;
                        newTables.put("glyf", newGlyfTableItem);
                        newTables.put("loca", newLocaTableItem);
                    } else {
                        StiFontReader.Table cffTable = (StiFontReader.Table)ttf.Tables.get("CFF ");
                        Cff cff = new Cff();
                        cff.Read(data, cffTable.Offset, cffTable.Length);
                        cff.GlyphsNeed = glyphNeeds;
                        cff.CutUnusedSubr();
                        int[] newCffBytes = cff.Save();
                        NewTableItem newCffTableItem = new NewTableItem();
                        newCffTableItem.Tag = cffTable.Tag;
                        newCffTableItem.NewLength = newCffBytes.length;
                        newCffTableItem.NewTable = this.toByteArray(newCffBytes);
                        newTables.put("CFF ", newCffTableItem);
                    }
                }
                byte[] newHeader = new byte[12 + numTablesRequired * 16];
                System.arraycopy(buff, ttf.HeaderOffset, newHeader, 0, newHeader.length);
                int maximumPower = 1;
                while (2 << maximumPower - 1 <= numTablesRequired) {
                    ++maximumPower;
                }
                int searchRange = (2 << --maximumPower - 1) * 16;
                int entrySelector = maximumPower;
                int rangeShift = numTablesRequired * 16 - searchRange;
                this.setUInt16(newHeader, ttf.HeaderOffset + 4, numTablesRequired);
                this.setUInt16(newHeader, ttf.HeaderOffset + 6, searchRange);
                this.setUInt16(newHeader, ttf.HeaderOffset + 8, entrySelector);
                this.setUInt16(newHeader, ttf.HeaderOffset + 10, rangeShift);
                int currentTable = 0;
                int currentPos = 12 + numTablesRequired * 16;
                ArrayList tables = new ArrayList(ttf.Tables.values());
                tables.sort(new Comparator<StiFontReader.Table>(){

                    @Override
                    public int compare(StiFontReader.Table o1, StiFontReader.Table o2) {
                        return o1.TagString.compareTo(o2.TagString);
                    }
                });
                for (StiFontReader.Table table : tables) {
                    if (!tablesNames.contains(table.TagString)) continue;
                    int tableLength = table.Length;
                    if (newTables.containsKey(table.TagString)) {
                        tableLength = ((NewTableItem)newTables.get((Object)table.TagString)).NewLength;
                    }
                    int pos = 12 + currentTable * 16;
                    this.setUInt32(newHeader, pos, table.Tag);
                    this.setUInt32(newHeader, pos + 4, table.Checksum);
                    this.setUInt32(newHeader, pos + 8, currentPos);
                    this.setUInt32(newHeader, pos + 12, tableLength);
                    int remainder = (currentPos += tableLength) % 4;
                    if (remainder > 0) {
                        currentPos += 4 - remainder;
                    }
                    ++currentTable;
                }
                ByteArrayOutputStream mem = new ByteArrayOutputStream();
                mem.write(newHeader, 0, newHeader.length);
                for (StiFontReader.Table table : tables) {
                    int remainder;
                    if (!tablesNames.contains(table.TagString)) continue;
                    int tableLength = table.Length;
                    if (newTables.containsKey(table.TagString)) {
                        tableLength = ((NewTableItem)newTables.get((Object)table.TagString)).NewLength;
                        mem.write(((NewTableItem)newTables.get((Object)table.TagString)).NewTable, 0, tableLength);
                    } else {
                        mem.write(buff, table.Offset, table.Length);
                    }
                    if ((remainder = tableLength % 4) <= 0) continue;
                    mem.write(new byte[4 - remainder], 0, 4 - remainder);
                }
                mem.close();
                buff = mem.toByteArray();
                mem.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buff;
    }

    private int getUInt16(byte[] buff, int pos) {
        int value = 0;
        for (int i = 0; i < 2; ++i) {
            int shift = (1 - i) * 8;
            value += (buff[i + pos] & 0xFF) << shift;
        }
        return value;
    }

    private int getUInt32(byte[] buff, int pos) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (buff[i + pos] & 0xFF) << shift;
        }
        return value;
    }

    private int getInt8(byte[] buff, int pos) {
        int res = buff[pos];
        return res > 127 ? res - 256 : res;
    }

    private int getInt16(byte[] buff, int pos) {
        int res = this.getUInt16(buff, pos);
        return res > Short.MAX_VALUE ? res - 65536 : res;
    }

    private void setUInt16(byte[] buff, int pos, int value) {
        buff[pos + 1] = (byte)(value & 0xFF);
        buff[pos] = (byte)(value >> 8 & 0xFF);
    }

    private void setUInt32(byte[] buff, int pos, int value) {
        buff[pos + 3] = (byte)(value & 0xFF);
        buff[pos + 2] = (byte)(value >> 8 & 0xFF);
        buff[pos + 1] = (byte)(value >> 16 & 0xFF);
        buff[pos + 0] = (byte)(value >> 24 & 0xFF);
    }

    public void arraycopy(byte[] buf, int pos, int[] dest, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            dest[i] = buf[pos + i - start] & 0xFF;
        }
    }

    public void arraycopy(int[] buf, int pos, byte[] dest, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            dest[i] = (byte)buf[pos + i - start];
        }
    }

    public byte[] toByteArray(int[] buf) {
        byte[] res = new byte[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            res[i] = (byte)buf[i];
        }
        return res;
    }

    static {
        RequiredTablesNames.add("head");
        RequiredTablesNames.add("hhea");
        RequiredTablesNames.add("hmtx");
        RequiredTablesNames.add("maxp");
        RequiredTablesNames.add("cmap");
        RequiredTablesNames.add("OS/2");
        RequiredTablesNames.add("post");
        RequiredTablesNames.add("cvt ");
        RequiredTablesNames.add("fpgm");
        RequiredTablesNames.add("glyf");
        RequiredTablesNames.add("loca");
        RequiredTablesNames.add("prep");
        RequiredTablesNames.add("name");
        names = new Hashtable();
        names.put(1, "hstem");
        names.put(3, "vstem");
        names.put(4, "vmoveto");
        names.put(5, "rlineto");
        names.put(6, "hlineto");
        names.put(7, "vlineto");
        names.put(8, "rrcurveto");
        names.put(10, "callsubr");
        names.put(11, "return");
        names.put(14, "endchar");
        names.put(18, "hstemhm");
        names.put(19, "hintmask");
        names.put(20, "cntrmask");
        names.put(21, "rmoveto");
        names.put(22, "hmoveto");
        names.put(23, "vstemhm");
        names.put(24, "rcurveline");
        names.put(25, "rlinecurve");
        names.put(26, "vvcurveto");
        names.put(27, "hhcurveto");
        names.put(29, "callgsubr");
        names.put(30, "vhcurveto");
        names.put(31, "hvcurveto");
    }

    public class NewTableItem {
        public int Tag;
        public int CheckSum;
        public int NewOffset;
        public int NewLength;
        public byte[] NewTable;
    }

    public class Cff {
        private int[] fontBytes;
        private int[] newBytes;
        private int[] bufGetData = new int[4];
        private byte[] bufGetData2 = new byte[4];
        private Integer fontBytesOffset;
        private Integer newBytesOffset;
        private int baseLength;
        private boolean debugInfo = false;
        public Integer Offset = 0;
        public Cff_Header Header;
        public Index NameIndex;
        public DictIndex TopDictIndex;
        public StiStringIndex StringIndex;
        public Index GlobalSubrIndex;
        public boolean[] GlyphsNeed;
        public List<Block> TablesList;

        private String getReal() {
            int b;
            StringBuilder sb = new StringBuilder();
            while (!this.addRealPart((byte)((b = this.getCard8()) >> 4 & 0xF), sb) && !this.addRealPart((byte)(b & 0xF), sb)) {
            }
            return sb.toString();
        }

        private boolean addRealPart(byte val, StringBuilder sb) {
            if (val <= 9) {
                sb.append((char)(48 + val));
            }
            if (val == 10) {
                sb.append(".");
            }
            if (val == 11) {
                sb.append("E");
            }
            if (val == 12) {
                sb.append("E-");
            }
            if (val == 14) {
                sb.append("-");
            }
            return val == 15;
        }

        private int getCard8() {
            Integer n = this.fontBytesOffset;
            Integer n2 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
            return this.fontBytes[n];
        }

        private int getCard16() {
            Integer n = this.fontBytesOffset;
            Integer n2 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
            int n3 = this.fontBytes[n] << 8;
            n = this.fontBytesOffset;
            n2 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
            return n3 | this.fontBytes[n];
        }

        private int getOffSize() {
            return this.getCard8();
        }

        private Integer getOffset(int offSize) {
            if (offSize == 1) {
                return this.getCard8();
            }
            if (offSize == 2) {
                return this.getCard16();
            }
            if (offSize == 3) {
                Integer n = this.fontBytesOffset;
                Integer n2 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                int n3 = this.fontBytes[n] << 16;
                n = this.fontBytesOffset;
                n2 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                int n4 = n3 | this.fontBytes[n] << 8;
                n = this.fontBytesOffset;
                n2 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                return n4 | this.fontBytes[n];
            }
            if (offSize == 4) {
                Integer n = this.fontBytesOffset;
                Integer n5 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                int n6 = this.fontBytes[n] << 24;
                n = this.fontBytesOffset;
                n5 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                int n7 = n6 | this.fontBytes[n] << 16;
                n = this.fontBytesOffset;
                n5 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                int n8 = n7 | this.fontBytes[n] << 8;
                n = this.fontBytesOffset;
                n5 = this.fontBytesOffset = Integer.valueOf(this.fontBytesOffset + 1);
                return n8 | this.fontBytes[n];
            }
            throw new RuntimeException("Unknown OffSize value");
        }

        private void setOffset(int[] buf, int offset, int offSize, int value) {
            if (offSize == 1) {
                buf[offset] = value;
            }
            if (offSize == 2) {
                buf[offset] = value >> 8 & 0xFF;
                buf[offset + 1] = value & 0xFF;
            }
            if (offSize == 3) {
                buf[offset] = value >> 16 & 0xFF;
                buf[offset + 1] = value >> 8 & 0xFF;
                buf[offset + 2] = value & 0xFF;
            }
            if (offSize == 4) {
                buf[offset] = value >> 24 & 0xFF;
                buf[offset + 1] = value >> 16 & 0xFF;
                buf[offset + 2] = value >> 8 & 0xFF;
                buf[offset + 3] = value & 0xFF;
            }
        }

        private int GetUInt8(int[] buff, int pos) {
            return buff[pos];
        }

        private Integer GetUInt16(int[] buff, int pos) {
            this.bufGetData[0] = buff[pos + 1];
            this.bufGetData[1] = buff[pos + 0];
            return BitConverter.ToUInt16(this.bufGetData, 0);
        }

        private Integer GetUInt32(byte[] buff, int pos) {
            this.bufGetData[0] = buff[pos + 3];
            this.bufGetData[1] = buff[pos + 2];
            this.bufGetData[2] = buff[pos + 1];
            this.bufGetData[3] = buff[pos + 0];
            return BitConverter.ToUInt32(this.bufGetData, 0);
        }

        private Integer GetInt16(int[] buff, int pos) {
            return this.GetUInt16(buff, pos);
        }

        private void SetUInt16(int[] buff, int pos, Integer value) {
            System.arraycopy(BitConverter.getBytes(value), 0, this.bufGetData2, 0, BitConverter.getBytes(value).length);
            buff[pos + 0] = this.bufGetData2[1] & 0xFF;
            buff[pos + 1] = this.bufGetData2[0] & 0xFF;
        }

        public void Read(int[] fontBytes, int offset, int length) throws UnsupportedEncodingException {
            this.TablesList = new ArrayList<Block>();
            this.fontBytes = fontBytes;
            this.Offset = offset;
            this.baseLength = length;
            this.fontBytesOffset = offset;
            this.Header = new Cff_Header(this, "Header");
            this.NameIndex = new Index(this, "NameIndex");
            this.TopDictIndex = new DictIndex(this, "TopDictIndex");
            this.StringIndex = new StiStringIndex(this, "StringIndex");
            this.GlobalSubrIndex = new Index(this, "GlobalSubrIndex");
            this.Header.Read(offset, 4);
            this.NameIndex.Read(this.Header.Cff_Offset + this.Header.Cff_Size, 0);
            this.TopDictIndex.Read(this.NameIndex.Cff_Offset + this.NameIndex.Cff_Size, 0);
            this.StringIndex.Read(this.TopDictIndex.Cff_Offset + this.TopDictIndex.Cff_Size, 0);
            this.GlobalSubrIndex.Read(this.StringIndex.Cff_Offset + this.StringIndex.Cff_Size, 0);
        }

        public int GetSize() {
            return this.Header.GetSize() + this.NameIndex.GetSize() + this.TopDictIndex.GetSize() + this.StringIndex.GetSize() + this.GlobalSubrIndex.GetSize();
        }

        public int[] Save() throws IOException {
            this.newBytes = new int[this.GetSize()];
            this.newBytesOffset = 0;
            this.Header.Save();
            this.NameIndex.Save();
            this.TopDictIndex.Save(true);
            this.StringIndex.Save();
            this.GlobalSubrIndex.Save();
            this.TopDictIndex.Save(false);
            return this.newBytes;
        }

        public void CutUnusedSubr() {
            try {
                if (this.GlyphsNeed != null && this.TopDictIndex.Dicts.get((int)0).FDSelect != null) {
                    int index;
                    int[] gids = new int[this.TopDictIndex.Dicts.get((int)0).CharStringsIndex.Count];
                    int start = this.TopDictIndex.Dicts.get((int)0).FDSelect.Cff_Offset;
                    this.fontBytesOffset = start;
                    int format = this.getCard8();
                    if (format == 0) {
                        System.arraycopy(this.fontBytes, start + 1, gids, 0, gids.length);
                    } else if (format == 3) {
                        int nRanges = this.getCard16();
                        int fd = 0;
                        int prev = -1;
                        for (int i = 0; i < nRanges; ++i) {
                            int first = this.getCard16();
                            if (prev >= 0) {
                                for (int glyphId = prev; glyphId < first; ++glyphId) {
                                    gids[glyphId] = fd;
                                }
                            }
                            prev = first;
                            fd = this.getCard8();
                        }
                        if (prev >= 0) {
                            int first = this.getCard16();
                            for (int glyphId = prev; glyphId < first; ++glyphId) {
                                gids[glyphId] = fd;
                            }
                        }
                    } else {
                        return;
                    }
                    boolean[] fds = new boolean[this.TopDictIndex.Dicts.get((int)0).FontDictIndex.Count];
                    for (index = 0; index < this.GlyphsNeed.length; ++index) {
                        if (!this.GlyphsNeed[index]) continue;
                        fds[gids[index]] = true;
                    }
                    for (index = 0; index < this.TopDictIndex.Dicts.get((int)0).FontDictIndex.Count; ++index) {
                        if (fds[index]) continue;
                        this.TopDictIndex.Dicts.get((int)0).FontDictIndex.Dicts.get((int)index).Private.SubrIndex = null;
                        this.TopDictIndex.Dicts.get((int)0).FontDictIndex.Dicts.get((int)index).Private.Items.remove(19);
                    }
                }
                if (this.debugInfo) {
                    Hashtable<Integer, Integer> sidsMap = new Hashtable<Integer, Integer>();
                    Block charset = null;
                    for (Block block : this.TablesList) {
                        if (!"Charset".equals(block.Name)) continue;
                        charset = block;
                    }
                    this.fontBytesOffset = charset.Cff_Offset;
                    int format = this.getCard8();
                    if (format == 1 || format == 2) {
                        int sid = 0;
                        int gid = 1;
                        int maxSid = this.TopDictIndex.Dicts.get((int)0).CharStringsIndex.Count;
                        while (sid < maxSid && this.fontBytesOffset < charset.Cff_Offset + charset.Cff_Size) {
                            sid = this.getCard16();
                            int num = (format == 1 ? this.getCard8() : this.getCard16()) + 1;
                            while (num-- > 0) {
                                sidsMap.put(gid++, sid++);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String GetBaseTablesString() {
            ArrayList<Block> list = new ArrayList<Block>(this.TablesList);
            list.sort(new Comparator<Block>(){

                @Override
                public int compare(Block o1, Block o2) {
                    return o1.Cff_Offset.compareTo(o2.Cff_Offset);
                }
            });
            StringBuilder sb = new StringBuilder();
            int pos = this.Offset;
            for (int index = 0; index < list.size(); ++index) {
                Block item = (Block)list.get(index);
                if (item.Cff_Offset < pos) {
                    sb.append("  Overlap " + (pos - item.Cff_Offset) + " ! \r\n");
                }
                if (item.Cff_Offset > pos) {
                    sb.append("  Gap " + (item.Cff_Offset - pos) + " ! \r\n");
                }
                sb.append(this.Offset + item.Cff_Offset + " " + item.Cff_Size + " " + item.Name + " \r\n");
                pos = item.Cff_Offset + item.Cff_Size;
            }
            if (this.Offset + this.baseLength > pos) {
                sb.append("  Gap " + (this.Offset + this.baseLength - pos) + " ! \r\n");
            }
            sb.append(this.baseLength + " \r\n");
            return sb.toString();
        }

        public String GetNewTablesString() {
            ArrayList<Block> list = new ArrayList<Block>(this.TablesList);
            list.sort(new Comparator<Block>(){

                @Override
                public int compare(Block o1, Block o2) {
                    return o1.Cff_NewOffset.compareTo(o2.Cff_NewOffset);
                }
            });
            StringBuilder sb = new StringBuilder();
            int pos = this.Offset;
            for (int index = 0; index < list.size(); ++index) {
                Block item = (Block)list.get(index);
                if (item.Cff_NewOffset < pos) {
                    sb.append("  Overlap " + (pos - item.Cff_NewOffset) + " ! \r\n");
                }
                if (item.Cff_NewOffset > pos) {
                    sb.append("  Gap " + (item.Cff_NewOffset - pos) + " ! \r\n");
                }
                sb.append(this.Offset + item.Cff_NewOffset + " " + item.Cff_NewSize + " " + item.Name + " \r\n");
                pos = item.Cff_NewOffset + item.Cff_NewSize;
            }
            int size = this.GetSize();
            if (this.Offset + size > pos) {
                sb.append("  Gap " + (this.Offset + size - pos) + " ! \r\n");
            }
            sb.append(size + " \r\n");
            return sb.toString();
        }

        public class Cff_CharStringsIndex
        extends Index {
            @Override
            public int GetSize(boolean onlyMain) {
                if (this.Cff.GlyphsNeed == null) {
                    return this.Cff_Size;
                }
                int size = 3 + (this.Count + 1) * this.OffSize;
                for (int i = 0; i < this.Count; ++i) {
                    if (i < this.Cff.GlyphsNeed.length && this.Cff.GlyphsNeed[i]) {
                        size += this.Offsets[i + 1] - this.Offsets[i];
                        continue;
                    }
                    ++size;
                }
                return size;
            }

            @Override
            public void Save(boolean main) throws IOException {
                if (this.Cff.GlyphsNeed == null) {
                    super.Save(main);
                    return;
                }
                this.Cff_NewOffset = this.Cff.newBytesOffset;
                int offset = this.Cff.newBytesOffset;
                this.Cff.SetUInt16(this.Cff.newBytes, offset, this.Count);
                ((Cff)this.Cff).newBytes[offset + 2] = this.OffSize;
                int addOffs = 3 + (this.Count + 1) * this.OffSize - 1;
                int offsetCur = 1;
                this.Cff.setOffset(this.Cff.newBytes, offset + 3, this.OffSize, offsetCur);
                for (int i = 0; i < this.Count; ++i) {
                    this.Cff.newBytesOffset = offset + offsetCur + addOffs;
                    if (i < this.Cff.GlyphsNeed.length && this.Cff.GlyphsNeed[i]) {
                        int csLen = this.Offsets[i + 1] - this.Offsets[i];
                        System.arraycopy(this.Cff.fontBytes, this.Cff_Offset + this.Offsets[i], this.Cff.newBytes, offset + offsetCur + addOffs, csLen);
                        offsetCur += csLen;
                    } else {
                        ((Cff)this.Cff).newBytes[offset + offsetCur + addOffs] = 14;
                        ++offsetCur;
                    }
                    this.Cff.setOffset(this.Cff.newBytes, offset + 3 + (i + 1) * this.OffSize, this.OffSize, offsetCur);
                }
                int newSize = this.GetSize();
                this.Cff.newBytesOffset = offset + newSize;
                this.Cff_NewSize = newSize;
            }

            public String GetCommandsList(int offset, int length) {
                ArrayList<DictItem> items = new ArrayList<DictItem>();
                ArrayList<Object> operands = new ArrayList<Object>();
                this.Cff.fontBytesOffset = offset;
                while (this.Cff.fontBytesOffset < offset + length) {
                    int b0 = this.Cff.getCard8();
                    if (b0 == 28 || b0 >= 32 && b0 <= 255) {
                        Number operand = null;
                        if (b0 == 28) {
                            operand = (short)(this.Cff.getCard8() << 8 | this.Cff.getCard8());
                        }
                        if (b0 >= 32 && b0 <= 246) {
                            operand = b0 - 139;
                        }
                        if (b0 >= 247 && b0 <= 250) {
                            operand = (b0 - 247) * 256 + this.Cff.getCard8() + 108;
                        }
                        if (b0 >= 251 && b0 <= 254) {
                            operand = -(b0 - 251) * 256 - this.Cff.getCard8() - 108;
                        }
                        if (b0 == 255) {
                            operand = (this.Cff.getCard8() << 24 | this.Cff.getCard8() << 16 | this.Cff.getCard8() << 8 | this.Cff.getCard8()) / 65536;
                        }
                        operands.add(operand);
                        continue;
                    }
                    DictItem item = new DictItem();
                    item.Operator = b0;
                    if (b0 == 12) {
                        item.Operator = b0 << 8 | this.Cff.getCard8();
                    }
                    item.Operands = operands;
                    items.add(item);
                    operands = new ArrayList();
                }
                StringBuilder sb = new StringBuilder();
                for (DictItem item : items) {
                    String op = String.valueOf(item.Operator);
                    if (names.containsKey(item.Operator)) {
                        op = (String)names.get(item.Operator) + "(" + op + ")";
                    }
                    StringBuilder sb2 = new StringBuilder();
                    for (int index = 0; index < item.Operands.size(); ++index) {
                        sb2.append(item.Operands.get(index));
                        if (index >= item.Operands.size() - 1) continue;
                        sb2.append(", ");
                    }
                    sb.append(op + " [" + sb2 + "]\n");
                }
                return sb.toString();
            }

            public Cff_CharStringsIndex(Cff cff, String name) {
                this(cff, name, true);
            }

            public Cff_CharStringsIndex(Cff cff, String name, boolean addToPool) {
                super(cff, name, addToPool);
            }
        }

        public class Cff_Header
        extends Block {
            public int Major;
            public int Minor;
            public int HdrSize;
            public int OffSize;

            @Override
            public void Read(int offset, int length) {
                this.Cff_Offset = offset;
                this.Cff_Size = length;
                this.Major = this.Cff.getCard8();
                this.Minor = this.Cff.getCard8();
                this.HdrSize = this.Cff.getCard8();
                this.OffSize = this.Cff.getOffSize();
            }

            public Cff_Header(Cff cff, String name) {
                this(cff, name, true);
            }

            public Cff_Header(Cff cff, String name, boolean addToPool) {
                super(cff, name, addToPool);
            }
        }

        public class DictIndex
        extends Index {
            public List<Dict> Dicts;

            @Override
            public void Read(int offset, int length) throws UnsupportedEncodingException {
                super.Read(offset, length);
                this.Dicts = new ArrayList<Dict>();
                for (int index = 0; index < this.Offsets.length - 1; ++index) {
                    Dict item = new Dict(this.Cff, this.Name + "-Dict" + index, false);
                    item.Read(this.Cff_Offset + this.Offsets[index], this.Offsets[index + 1] - this.Offsets[index]);
                    this.Dicts.add(item);
                }
                if (this.OffSize == 1 && this.Count > 1) {
                    this.OffSize = 2;
                }
            }

            @Override
            public int GetSize(boolean onlyMain) {
                int size = 3 + (this.Count + 1) * this.OffSize;
                for (Dict dictItem : this.Dicts) {
                    size += dictItem.GetSize(onlyMain);
                }
                return size;
            }

            @Override
            public void Save() throws IOException {
                this.Save(false);
            }

            @Override
            public void Save(boolean main) throws IOException {
                if (main) {
                    this.Cff_NewOffset = this.Cff.newBytesOffset;
                    int offset = this.Cff.newBytesOffset;
                    this.Cff.SetUInt16(this.Cff.newBytes, offset, this.Count);
                    ((Cff)this.Cff).newBytes[offset + 2] = this.OffSize;
                    int addOffs = 3 + (this.Count + 1) * this.OffSize - 1;
                    int offsetCur = 1;
                    this.Cff.setOffset(this.Cff.newBytes, offset + 3, this.OffSize, offsetCur);
                    for (int i = 0; i < this.Count; ++i) {
                        this.Cff.newBytesOffset = offset + offsetCur + addOffs;
                        this.Dicts.get(i).Save(true);
                        this.Cff.setOffset(this.Cff.newBytes, offset + 3 + (i + 1) * this.OffSize, this.OffSize, offsetCur += this.Dicts.get(i).GetSize(true));
                    }
                    int newSize = this.GetSize(true);
                    this.Cff.newBytesOffset = offset + newSize;
                    this.Cff_NewSize = newSize;
                } else {
                    for (int i = 0; i < this.Count; ++i) {
                        this.Dicts.get(i).Save(false);
                    }
                }
            }

            public DictIndex(Cff cff, String name) {
                this(cff, name, true);
            }

            public DictIndex(Cff cff, String name, boolean addToPool) {
                super(cff, name, addToPool);
            }
        }

        public class Dict
        extends Block {
            public Hashtable<Integer, DictItem> Items;
            public List<Integer> ItemKeys;
            public Hashtable<Integer, Integer> Adresses;
            public Block Charset;
            public Block Encoding;
            public Cff_CharStringsIndex CharStringsIndex;
            public Dict Private;
            public DictIndex FontDictIndex;
            public Block FDSelect;
            public Index SubrIndex;

            @Override
            public void Read(int offset, int length) throws UnsupportedEncodingException {
                int encodingOffset;
                int charsetOffset;
                this.Cff_Offset = offset;
                this.Cff_Size = length;
                this.Items = new Hashtable();
                this.Cff.fontBytesOffset = offset;
                int lastPos = offset;
                ArrayList<Object> operands = new ArrayList<Object>();
                while (this.Cff.fontBytesOffset < offset + length) {
                    int b0 = this.Cff.getCard8();
                    if (b0 <= 21) {
                        DictItem item = new DictItem();
                        item.Operator = b0;
                        if (b0 == 12) {
                            item.Operator = b0 << 8 | this.Cff.getCard8();
                        }
                        item.Operands = operands;
                        item.RawDataOffset = lastPos;
                        item.RawDataLength = this.Cff.fontBytesOffset - lastPos;
                        this.Items.put(item.Operator, item);
                        if (!this.ItemKeys.contains(item.Operator)) {
                            this.ItemKeys.add(item.Operator);
                        }
                        operands = new ArrayList();
                        lastPos = this.Cff.fontBytesOffset;
                    }
                    if (b0 < 28 || b0 > 254 || b0 == 31) continue;
                    Object operand = null;
                    if (b0 >= 32 && b0 <= 246) {
                        operand = b0 - 139;
                    }
                    if (b0 >= 247 && b0 <= 250) {
                        operand = (b0 - 247) * 256 + this.Cff.getCard8() + 108;
                    }
                    if (b0 >= 251 && b0 <= 254) {
                        operand = -(b0 - 251) * 256 - this.Cff.getCard8() - 108;
                    }
                    if (b0 == 28) {
                        operand = (short)(this.Cff.getCard8() << 8 | this.Cff.getCard8());
                    }
                    if (b0 == 29) {
                        operand = this.Cff.getCard8() << 24 | this.Cff.getCard8() << 16 | this.Cff.getCard8() << 8 | this.Cff.getCard8();
                    }
                    if (b0 == 30) {
                        operand = this.Cff.getReal();
                    }
                    operands.add(operand);
                }
                if (this.Items.containsKey(17)) {
                    int charStringsOffset = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)17)).Operands.get(0));
                    this.CharStringsIndex = new Cff_CharStringsIndex(this.Cff, "CharStringsIndex");
                    this.CharStringsIndex.Read(this.Cff.Offset + charStringsOffset, 0);
                    this.Items.get((Object)Integer.valueOf((int)17)).RawData = new byte[]{29, 0, 0, 0, 0, 17};
                }
                if (this.Items.containsKey(15) && (charsetOffset = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)15)).Operands.get(0))) > 3) {
                    int charsetFormat = this.Cff.GetUInt8(this.Cff.fontBytes, charsetOffset += this.Cff.Offset.intValue());
                    int charsetLength = 0;
                    if (charsetFormat == 0) {
                        charsetLength = 1 + (this.CharStringsIndex.Count - 1) * 2;
                    }
                    if (charsetFormat == 1 || charsetFormat == 2) {
                        int nLeft;
                        this.Cff.fontBytesOffset = charsetOffset + 1;
                        for (int countGlyphs = 1; countGlyphs < this.CharStringsIndex.Count; countGlyphs += nLeft + 1) {
                            this.Cff.getCard16();
                            nLeft = charsetFormat == 1 ? this.Cff.getCard8() : this.Cff.getCard16();
                        }
                        charsetLength = this.Cff.fontBytesOffset - charsetOffset;
                    }
                    this.Charset = new Block(this.Cff, "Charset");
                    this.Charset.Cff_Offset = charsetOffset;
                    this.Charset.Cff_Size = charsetLength;
                    this.Items.get((Object)Integer.valueOf((int)15)).RawData = new byte[]{29, 0, 0, 0, 0, 15};
                }
                if (this.Items.containsKey(16) && (encodingOffset = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)16)).Operands.get(0))) > 1) {
                    int encodingFormat = this.Cff.GetUInt8(this.Cff.fontBytes, encodingOffset += this.Cff.Offset.intValue());
                    int encodingLength = 0;
                    if (encodingFormat == 0) {
                        encodingLength = 2 + this.Cff.GetUInt8(this.Cff.fontBytes, encodingOffset + 1);
                    }
                    if (encodingFormat == 1) {
                        encodingLength = 2 + this.Cff.GetUInt8(this.Cff.fontBytes, encodingOffset + 1) * 2;
                    }
                    if ((encodingFormat & 0x80) > 0) {
                        encodingLength = 2 + this.Cff.GetUInt8(this.Cff.fontBytes, encodingOffset + 1) * 3;
                    }
                    this.Encoding = new Block(this.Cff, "Encoding");
                    this.Encoding.Cff_Offset = encodingOffset;
                    this.Encoding.Cff_Size = encodingLength;
                    this.Items.get((Object)Integer.valueOf((int)16)).RawData = new byte[]{29, 0, 0, 0, 0, 16};
                }
                if (this.Items.containsKey(18)) {
                    int privateOffset = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)18)).Operands.get(1));
                    int privateLength = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)18)).Operands.get(0));
                    this.Private = new Dict(this.Cff, "PrivateDict");
                    this.Private.Read(this.Cff.Offset + privateOffset, privateLength);
                    this.Items.get((Object)Integer.valueOf((int)18)).RawData = new byte[]{29, 0, 0, 0, 0, 29, 0, 0, 0, 0, 18};
                }
                if (this.Items.containsKey(19)) {
                    int subrOffset = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)19)).Operands.get(0));
                    this.SubrIndex = new Index(this.Cff, "Subr");
                    this.SubrIndex.Read(this.Cff_Offset + subrOffset, 0);
                    this.Items.get((Object)Integer.valueOf((int)19)).RawData = new byte[]{29, 0, 0, 0, 0, 19};
                }
                if (this.Items.containsKey(3108)) {
                    int fontDictIndexOffset = (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)3108)).Operands.get(0));
                    this.FontDictIndex = new DictIndex(this.Cff, "FontDictIndex");
                    this.FontDictIndex.Read(this.Cff.Offset + fontDictIndexOffset, 0);
                    this.Items.get((Object)Integer.valueOf((int)3108)).RawData = new byte[]{29, 0, 0, 0, 0, 12, 36};
                }
                if (this.Items.containsKey(3109)) {
                    int fDSelectOffset = this.Cff.Offset + (int)Func.Convert.toInt32(this.Items.get((Object)Integer.valueOf((int)3109)).Operands.get(0));
                    int fDSelectFormat = this.Cff.GetUInt8(this.Cff.fontBytes, fDSelectOffset);
                    int fDSelectLength = 0;
                    if (fDSelectFormat == 0) {
                        fDSelectLength = 1 + (this.CharStringsIndex.Count - 1);
                    }
                    if (fDSelectFormat == 3) {
                        fDSelectLength = 3 + this.Cff.GetUInt16(this.Cff.fontBytes, fDSelectOffset + 1) * 3 + 2;
                    }
                    this.FDSelect = new Block(this.Cff, "FDSelect");
                    this.FDSelect.Cff_Offset = fDSelectOffset;
                    this.FDSelect.Cff_Size = fDSelectLength;
                    this.Items.get((Object)Integer.valueOf((int)3109)).RawData = new byte[]{29, 0, 0, 0, 0, 12, 37};
                }
            }

            @Override
            public void Save(boolean main) throws IOException {
                if (main) {
                    this.Cff_NewOffset = this.Cff.newBytesOffset;
                    this.Adresses = new Hashtable();
                    ByteArrayOutputStream ms = new ByteArrayOutputStream();
                    for (Integer dictItemKey : this.Items.keySet()) {
                        DictItem dictItem = this.Items.get(dictItemKey);
                        this.Adresses.put(dictItemKey, this.Cff.newBytesOffset + ms.size());
                        if (dictItem.RawData == null) {
                            ms.write(StiOpenTypeHelper.this.toByteArray(this.Cff.fontBytes), dictItem.RawDataOffset, dictItem.RawDataLength);
                            continue;
                        }
                        ms.write(dictItem.RawData, 0, dictItem.RawData.length);
                    }
                    byte[] buf = ms.toByteArray();
                    ms.close();
                    StiOpenTypeHelper.this.arraycopy(buf, 0, this.Cff.newBytes, (int)this.Cff.newBytesOffset, buf.length);
                    Cff cff = this.Cff;
                    cff.newBytesOffset = cff.newBytesOffset + buf.length;
                    this.Cff_NewSize = buf.length;
                } else {
                    if (this.Charset != null) {
                        this.StoreOffset(15);
                        this.Charset.Save();
                    }
                    if (this.Encoding != null) {
                        this.StoreOffset(16);
                        this.Encoding.Save();
                    }
                    if (this.FDSelect != null) {
                        this.StoreOffset(3109);
                        this.FDSelect.Save();
                    }
                    if (this.CharStringsIndex != null) {
                        this.StoreOffset(17);
                        this.CharStringsIndex.Save();
                    }
                    if (this.Private != null) {
                        this.StoreOffset(18, 2);
                        this.Private.Save(true);
                        this.StoreOffset(18, 1, this.Private.Cff_NewSize);
                        this.Private.Save();
                    }
                    if (this.FontDictIndex != null) {
                        this.StoreOffset(3108);
                        this.FontDictIndex.Save(true);
                        this.FontDictIndex.Save();
                    }
                    if (this.SubrIndex != null) {
                        this.StoreOffset(19, 1, this.Cff_NewOffset);
                        this.SubrIndex.Save();
                    }
                }
            }

            @Override
            public int GetSize(boolean onlyMain) {
                int size = 0;
                for (DictItem dictItemValue : this.Items.values()) {
                    if (dictItemValue.RawData == null) {
                        size += dictItemValue.RawDataLength;
                        continue;
                    }
                    size += dictItemValue.RawData.length;
                }
                if (!onlyMain) {
                    if (this.CharStringsIndex != null) {
                        size += this.CharStringsIndex.GetSize();
                    }
                    if (this.Charset != null) {
                        size += this.Charset.GetSize();
                    }
                    if (this.Encoding != null) {
                        size += this.Encoding.GetSize();
                    }
                    if (this.Private != null) {
                        size += this.Private.GetSize();
                    }
                    if (this.FontDictIndex != null) {
                        size += this.FontDictIndex.GetSize();
                    }
                    if (this.FDSelect != null) {
                        size += this.FDSelect.GetSize();
                    }
                    if (this.SubrIndex != null) {
                        size += this.SubrIndex.GetSize();
                    }
                }
                return size;
            }

            private void StoreOffset(int code) {
                this.StoreOffset(code, 1, -1);
            }

            private void StoreOffset(int code, int pos) {
                this.StoreOffset(code, pos, -1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void StoreOffset(int code, int pos, int arg) {
                int bb;
                int newOffset = this.Cff.newBytesOffset;
                int addr = this.Adresses.get(code);
                if (pos > 1) {
                    addr += 5;
                }
                if (code == 18 && pos == 1) {
                    newOffset = arg;
                }
                if (code == 19) {
                    newOffset -= arg;
                }
                if ((bb = this.Cff.newBytes[addr]) == 29) {
                    this.Cff.setOffset(this.Cff.newBytes, addr + 1, 4, newOffset);
                    return;
                } else if (bb == 28) {
                    if (newOffset < Short.MIN_VALUE || newOffset > Short.MAX_VALUE) throw new RuntimeException("todo, too big value for short");
                    this.Cff.setOffset(this.Cff.newBytes, addr + 1, 2, newOffset);
                    return;
                } else if (bb >= 247 && bb <= 250) {
                    if (newOffset < 108 || newOffset > 1131) throw new RuntimeException("todo, too big value for size2");
                    int tempB = newOffset - 108;
                    byte b0 = (byte)(tempB >> 8 & 0xFF);
                    byte b1 = (byte)(tempB - b0 * 256 & 0xFF);
                    ((Cff)this.Cff).newBytes[addr] = (byte)(b0 + 247);
                    ((Cff)this.Cff).newBytes[addr + 1] = b1;
                    return;
                } else {
                    if (bb < 251 || bb > 254) throw new RuntimeException("todo, small address");
                    if (newOffset < -1131 || newOffset > -108) throw new RuntimeException("todo, too big value for size2");
                    int tempB = Math.abs(newOffset) - 108;
                    byte b0 = (byte)(tempB >> 8 & 0xFF);
                    byte b1 = (byte)(tempB - b0 * 256 & 0xFF);
                    ((Cff)this.Cff).newBytes[addr] = (byte)(b0 + 251);
                    ((Cff)this.Cff).newBytes[addr + 1] = b1;
                }
            }

            public Dict(Cff cff, String name) {
                this(cff, name, true);
            }

            public Dict(Cff cff, String name, boolean addToPool) {
                super(cff, name, addToPool);
                this.ItemKeys = new ArrayList<Integer>();
            }
        }

        public class DictItem {
            public int Operator;
            public List<Object> Operands;
            public int RawDataOffset;
            public int RawDataLength;
            public byte[] RawData;

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int index = 0; index < this.Operands.size(); ++index) {
                    sb.append(this.Operands.get(index));
                    if (index >= this.Operands.size() - 1) continue;
                    sb.append(", ");
                }
                return this.Operator + "[" + sb + "]";
            }
        }

        public class StiStringIndex
        extends Index {
            String[] strings;

            @Override
            public void Read(int offset, int length) throws UnsupportedEncodingException {
                super.Read(offset, length);
                if (this.Cff.debugInfo) {
                    this.strings = new String[this.Count - 1];
                    for (int i = 0; i < this.Count - 1; ++i) {
                        byte[] bytes = new byte[this.Offsets[i + 1] - this.Offsets[i]];
                        StiOpenTypeHelper.this.arraycopy(this.Cff.fontBytes, this.Cff_Offset + this.Offsets[i], bytes, 0, this.Offsets[i + 1] - this.Offsets[i]);
                        this.strings[i] = String.format("%04d", 391 + i) + " " + new String(bytes, "UTF-8");
                    }
                }
            }

            public StiStringIndex(Cff cff, String name) {
                this(cff, name, true);
            }

            public StiStringIndex(Cff cff, String name, boolean addToPool) {
                super(cff, name, addToPool);
            }
        }

        public class Index
        extends Block {
            public int Count;
            public int OffSize;
            public int[] Offsets;

            @Override
            public void Read(int offset, int length) throws UnsupportedEncodingException {
                this.Cff.fontBytesOffset = offset;
                this.Cff_Offset = offset;
                this.Cff_Size = 2;
                this.Count = this.Cff.getCard16();
                if (this.Count > 0) {
                    this.OffSize = this.Cff.getOffSize();
                    this.Offsets = new int[this.Count + 1];
                    int addOffset = 3 + (this.Count + 1) * this.OffSize - 1;
                    for (int i = 0; i < this.Count + 1; ++i) {
                        this.Offsets[i] = this.Cff.getOffset(this.OffSize) + addOffset;
                    }
                    this.Cff_Size = this.Offsets[this.Offsets.length - 1];
                    this.Cff.fontBytesOffset = this.Cff_Offset + this.Cff_Size;
                }
            }

            public Index(Cff cff, String name) {
                this(cff, name, true);
            }

            public Index(Cff cff, String name, boolean addToPool) {
                super(cff, name, addToPool);
            }
        }

        public class Block {
            public Cff Cff;
            public Integer Cff_Offset;
            public Integer Cff_Size;
            public Integer Cff_NewOffset;
            public Integer Cff_NewSize;
            public String Name;

            public void Read(int offset, int length) throws UnsupportedEncodingException {
                this.Cff_Offset = offset;
                this.Cff_Size = length;
            }

            public int GetSize() {
                return this.GetSize(false);
            }

            public int GetSize(boolean onlyMain) {
                return this.Cff_Size;
            }

            public void Save() throws IOException {
                this.Save(false);
            }

            public void Save(boolean main) throws IOException {
                this.Cff_NewOffset = this.Cff.newBytesOffset;
                this.Cff_NewSize = this.Cff_Size;
                System.arraycopy(this.Cff.fontBytes, this.Cff_Offset, this.Cff.newBytes, this.Cff.newBytesOffset, this.Cff_Size);
                Cff cff = this.Cff;
                cff.newBytesOffset = cff.newBytesOffset + this.Cff_Size;
            }

            public String toString() {
                return this.Name + "(" + this.Cff_Offset + "," + this.Cff_Size + ")";
            }

            public Block(Cff cff, String name) {
                this(cff, name, true);
            }

            public Block(Cff cff, String name, boolean addToPool) {
                this.Cff = cff;
                this.Name = name;
                if (addToPool) {
                    this.Cff.TablesList.add(this);
                }
            }
        }
    }
}

