/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.base.utils.StiOutputStreamWriter;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.export.EmfTextAlignmentMode;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.tools.IStiExportGeomWriter;
import com.stimulsoft.report.export.tools.StiPdfData;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import java.util.Stack;

public class StiPdfGeomWriter
implements IStiExportGeomWriter {
    private final double penWidthDefault = 0.1;
    private final int precision_digits = 3;
    private final double hiToTwips = 0.72;
    private final float pdfCKT = 0.55228f;
    private StiPoint lastPoint;
    private boolean makePath = false;
    private boolean pathClosed = false;
    private StringBuilder path = null;
    private int currentNumberFormat = 0;
    public int pageNumber = 0;
    public Stack<AffineTransform> matrixCache = new Stack();
    public StiPoint basePoint = new StiPoint();
    public boolean allowThinLines = false;
    private boolean forceNewPoint = false;
    private Double xmin = null;
    private Double xmax = null;
    private Double ymin = null;
    private Double ymax = null;
    public float componentAngle = 0.0f;
    private StiOutputStreamWriter pageStream = null;
    private StiPdfExportService pdfService = null;
    public boolean assembleData = false;

    public StiPdfGeomWriter() {
    }

    public StiPdfGeomWriter(StiOutputStreamWriter stream, StiPdfExportService service) {
        this(stream, service, false);
    }

    public StiPdfGeomWriter(StiOutputStreamWriter stream, StiPdfExportService service, boolean assembleData) {
        this.pageStream = stream;
        this.pdfService = service;
        this.assembleData = assembleData;
        this.matrixCache = new Stack();
    }

    public void setClip(StiRectangle rect) throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine(this.getRectString(rect) + "W n");
    }

    private void calculateMinMax(StiPoint pt) {
        this.xmin = this.xmin == null ? Double.valueOf(pt.x) : Double.valueOf(Math.min(this.xmin, pt.x));
        this.xmax = this.xmax == null ? Double.valueOf(pt.x) : Double.valueOf(Math.max(this.xmax, pt.x));
        this.ymin = this.ymin == null ? Double.valueOf(pt.y) : Double.valueOf(Math.min(this.ymin, pt.y));
        this.ymax = this.ymax == null ? Double.valueOf(pt.y) : Double.valueOf(Math.max(this.ymax, pt.y));
    }

    private String convertToString(double value) {
        Double numValue = StiMath.round((double)value, (int)3);
        return numValue.toString();
    }

    private void setStrokeColor(StiPen pen) throws IOException {
        this.pdfService.setStrokeColor(pen.getColor());
        double penWidth = pen.getWidth();
        if (penWidth == 0.0) {
            penWidth = 0.1;
        }
        this.pageStream.writeLine("%s w", new Object[]{this.convertToString(penWidth)});
    }

    private void setNonStrokeColor(StiBrush brush) throws IOException {
        this.pdfService.setNonStrokeColor(((StiSolidBrush)brush).getColor());
    }

    private String getPointString(StiPoint point) {
        this.calculateMinMax(point);
        return String.format("%s %s %s ", this.convertToString(point.x), this.convertToString(point.y), this.makePath && this.path.length() > 0 && !this.forceNewPoint ? "l" : "m");
    }

    private String getLineToString(StiPoint pointTo) {
        this.calculateMinMax(pointTo);
        return String.format("%s %s l ", this.convertToString(pointTo.x), this.convertToString(pointTo.y));
    }

    private String getRectString(double x, double y, double width, double height) {
        return this.getRectString(new StiRectangle(x, y, width, height));
    }

    private String getRectString(StiRectangle rect) {
        return String.format("%s %s %s %s re ", this.convertToString(rect.x), this.convertToString(rect.getTop()), this.convertToString(rect.getRight() - rect.x), this.convertToString(rect.getBottom() - rect.y));
    }

    private String getBezierString(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        this.calculateMinMax(new StiPoint(p1x, p1y));
        this.calculateMinMax(new StiPoint(p2x, p2y));
        this.calculateMinMax(new StiPoint(p3x, p3y));
        return String.format("%s %s %s %s %s %s c ", this.convertToString(p1x), this.convertToString(p1y), this.convertToString(p2x), this.convertToString(p2y), this.convertToString(p3x), this.convertToString(p3y));
    }

    private String getPolylineString(StiPoint[] points, boolean close, boolean drawTo) {
        int index;
        StringBuilder sb = new StringBuilder();
        if (!drawTo) {
            sb.append(this.getPointString(points[0]));
        }
        int n = index = drawTo ? 0 : 1;
        while (index < points.length) {
            sb.append(this.getLineToString(points[index]));
            ++index;
        }
        if (close) {
            sb.append("h ");
        }
        return sb.toString();
    }

    private String getEllipseString(StiRectangle rect) {
        double tmpX = rect.width / 2.0 * (double)0.44772f;
        double tmpY = rect.height / 2.0 * (double)0.44772f;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %s m ", this.convertToString(rect.x), this.convertToString(rect.y + rect.height / 2.0)));
        sb.append(this.getBezierString(rect.x, rect.y + rect.height - tmpY, rect.x + tmpX, rect.y + rect.height, rect.x + rect.width / 2.0, rect.y + rect.height));
        sb.append(this.getBezierString(rect.x + rect.width - tmpX, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height - tmpY, rect.x + rect.width, rect.y + rect.height / 2.0));
        sb.append(this.getBezierString(rect.x + rect.width, rect.y + tmpY, rect.x + rect.width - tmpX, rect.y, rect.x + rect.width / 2.0, rect.y));
        sb.append(this.getBezierString(rect.x + tmpX, rect.y, rect.x, rect.y + tmpY, rect.x, rect.y + rect.height / 2.0));
        return sb.toString();
    }

    @Override
    public void beginPath() {
        if (this.assembleData) {
            return;
        }
        this.path = new StringBuilder();
        this.makePath = true;
        this.pathClosed = false;
        this.xmin = null;
        this.xmax = null;
        this.ymin = null;
        this.ymax = null;
        this.forceNewPoint = false;
    }

    @Override
    public void closeFigure() {
        if (this.assembleData) {
            return;
        }
        this.path.append("h ");
        this.pathClosed = true;
    }

    @Override
    public void endPath() {
        if (this.assembleData) {
            return;
        }
        this.makePath = false;
    }

    @Override
    public void fillPath(Object brush) throws IOException {
        StiRectangle rect = this.assembleData ? new StiRectangle() : new StiRectangle(this.xmin.doubleValue(), this.ymin.doubleValue(), this.xmax - this.xmin, this.ymax - this.ymin);
        StiRefObject isTransparent = new StiRefObject((Object)false);
        boolean needRestore = this.setBrush(brush, rect, (StiRefObject<Boolean>)isTransparent, true);
        if (this.assembleData) {
            return;
        }
        if (!this.pathClosed) {
            this.endPath();
        }
        if (!((Boolean)isTransparent.argvalue).booleanValue()) {
            this.pageStream.write(this.path.toString());
            this.pageStream.writeLine("f");
        }
        if (needRestore) {
            this.pageStream.writeLine("Q");
        }
    }

    @Override
    public void strokePath(Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        if (!this.isPenEmpty(pen)) {
            this.setPen(pen, false, false);
            this.pageStream.write(this.path.toString());
            this.pageStream.writeLine("S");
        }
    }

    @Override
    public void moveTo(StiPoint point) throws IOException {
        if (this.assembleData) {
            return;
        }
        this.lastPoint = point;
        String stPoint = this.getPointString(point);
        if (this.makePath) {
            this.path.append(stPoint + "\r\n");
        } else {
            this.pageStream.writeLine(stPoint);
        }
    }

    @Override
    public void drawLine(StiPoint pointFrom, StiPoint pointTo, Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stLine = this.getPointString(pointFrom) + this.getLineToString(pointTo);
        if (this.makePath) {
            this.path.append(stLine + "\r\n");
        } else {
            boolean forceThin = pointFrom.x == pointTo.x || pointFrom.y == pointTo.y;
            this.outputLineString(stLine + "S", pen, forceThin);
        }
        this.lastPoint = pointTo;
    }

    @Override
    public void drawLineTo(StiPoint pointTo, StiPen pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stLine = this.getLineToString(pointTo);
        if (this.makePath) {
            this.path.append(stLine + "\r\n");
        } else {
            this.outputLineString(stLine + "S", pen);
        }
        this.lastPoint = pointTo;
    }

    public void drawRectangle(StiRectangle rect, Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            return;
        }
        this.outputLineString(this.getRectWithCornersString(rect) + "S", pen);
    }

    private void outputLineString(String st, Object pen) throws IOException {
        this.outputLineString(st, pen, false);
    }

    private boolean isPenEmpty(Object objPen) {
        if (objPen == null) {
            return true;
        }
        if (objPen instanceof StiPen) {
            return ((StiPen)objPen).getColor().a == 0;
        }
        if (objPen instanceof StiPenGeom) {
            StiPenGeom pen = (StiPenGeom)objPen;
            return pen.getBrush().a == 0 || pen.getPenStyle() == StiPenStyle.None;
        }
        return false;
    }

    private void outputLineString(String st, Object pen, boolean forceThin) throws IOException {
        if (!this.isPenEmpty(pen)) {
            boolean needRestoreState = this.setPen(pen, true, forceThin);
            this.pageStream.writeLine(st);
            if (needRestoreState) {
                this.pageStream.writeLine("Q");
            }
        }
    }

    public boolean setPen(Object objPen, boolean saveState, boolean forceThin) throws IOException {
        String dash;
        double penWidthForDash;
        double penWidth;
        StiPen pen;
        boolean needSaveState = false;
        if (objPen instanceof StiPen) {
            pen = (StiPen)objPen;
            this.pdfService.setStrokeColor(pen.getColor());
            double d = penWidth = pen.getWidth() > 0.72 ? pen.getWidth() : pen.getWidth() * 0.72;
            if (penWidth == 0.0) {
                penWidth = 0.1;
            }
            penWidthForDash = pen.getWidth();
            if (this.allowThinLines) {
                penWidth = pen.getWidth() < 0.5 || forceThin && pen.getWidth() == 1.0 ? 0.1 : pen.getWidth();
                penWidthForDash = penWidth > 0.1 ? penWidth : 0.4;
            }
            this.pageStream.writeLine("%s w", new Object[]{this.convertToString(penWidth)});
            boolean bl = needSaveState = saveState && pen.getDashStyle() != StiPenStyle.Solid;
            if (needSaveState) {
                this.pageStream.writeLine("q");
            }
            if ((dash = this.getPenStyleDashString(pen.getDashStyle(), penWidthForDash * 0.035)) != null) {
                this.pageStream.writeLine(dash);
            }
        }
        if (objPen instanceof StiPenGeom) {
            pen = (StiPenGeom)objPen;
            this.pdfService.setStrokeColor(pen.getBrush());
            double d = penWidth = pen.getThickness() > 0.72 ? pen.getThickness() : pen.getThickness() * 0.72;
            if (penWidth == 0.0) {
                penWidth = 0.1;
            }
            penWidthForDash = pen.getThickness();
            if (this.allowThinLines) {
                penWidth = pen.getThickness() < 0.5 || forceThin && pen.getThickness() == 1.0 ? 0.1 : pen.getThickness();
                penWidthForDash = penWidth > 0.1 ? penWidth : 0.4;
            }
            this.pageStream.writeLine("%s w", new Object[]{this.convertToString(penWidth)});
            boolean bl = needSaveState = saveState && pen.getPenStyle() != StiPenStyle.Solid;
            if (needSaveState) {
                this.pageStream.writeLine("q");
            }
            if ((dash = this.getPenStyleDashString(pen.getPenStyle(), penWidthForDash * 0.035)) != null) {
                this.pageStream.writeLine(dash);
            }
        }
        return needSaveState;
    }

    private String getPenStyleDashString(StiPenStyle style, double step) {
        double pow = 1.0 / Math.pow(10.0, 3.0);
        if (step < pow) {
            step = pow;
        }
        switch (style) {
            case Dot: {
                return String.format("[%s %s] 0 d", this.convertToString(step), this.convertToString(step * 58.0));
            }
            case Dash: {
                return String.format("[%s %s] 0 d", this.convertToString(step * 49.5), this.convertToString(step * 62.0));
            }
            case DashDot: {
                return String.format("[%s %s %s %s] 0 d", this.convertToString(step * 50.0), this.convertToString(step * 55.0), this.convertToString(step), this.convertToString(step * 55.0));
            }
            case DashDotDot: {
                return String.format("[%s %s %s %s %s %s] 0 d", this.convertToString(step * 50.0), this.convertToString(step * 55.0), this.convertToString(step), this.convertToString(step * 55.0), this.convertToString(step), this.convertToString(step * 55.0));
            }
        }
        return null;
    }

    private String getRectWithCornersString(StiRectangle rect) {
        return this.getRectString(rect);
    }

    @Override
    public void drawRectangle(StiRectangle rect, StiPen pen) throws Exception {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (pen != null) {
            this.setStrokeColor(pen);
            this.pageStream.writeLine(this.getRectString(rect) + "S");
        }
    }

    @Override
    public void fillRectangle(StiRectangle rect, StiColor color) throws Exception {
        if (color.getA() != 0) {
            this.fillRectangle(rect, new StiSolidBrush(color));
        }
    }

    @Override
    public void fillRectangle(StiRectangle rect, Object brush) throws Exception {
        StiRefObject isTransparent = new StiRefObject((Object)false);
        boolean needRestore = this.setBrush(brush, rect, (StiRefObject<Boolean>)isTransparent, true);
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (brush != null && !((Boolean)isTransparent.argvalue).booleanValue()) {
            StiGlassBrush glass;
            StiGlassBrush stiGlassBrush = glass = brush instanceof StiGlassBrush ? (StiGlassBrush)brush : null;
            if (glass != null) {
                if (glass.getDrawHatch()) {
                    this.pageStream.writeLine("/Cs1 cs /PH%s scn", new Object[]{this.pdfService.getHatchNumber((StiHatchBrush)glass.getTopBrush()) + 1});
                } else {
                    this.pdfService.setNonStrokeColor(glass.getTopColor());
                }
                this.pageStream.writeLine(this.getRectString(rect.x, rect.y, rect.width, rect.height / 2.0) + "f");
                if (glass.getDrawHatch()) {
                    this.pageStream.writeLine("/Cs1 cs /PH%s scn", new Object[]{this.pdfService.getHatchNumber((StiHatchBrush)glass.getBottomBrush()) + 1});
                } else {
                    this.pdfService.setNonStrokeColor(glass.getBottomColor());
                }
                this.pageStream.writeLine(this.getRectString(rect.x, rect.y + rect.height / 2.0, rect.width, rect.height / 2.0) + "f");
            } else {
                this.pageStream.writeLine(this.getRectWithCornersString(rect) + "f");
            }
        }
        if (needRestore) {
            this.pageStream.writeLine("Q");
        }
    }

    public StiPoint[] convertSplineToCubicBezier(StiPoint[] points, float tension) {
        int count = points.length;
        int len_pt = count * 3 - 2;
        StiPoint[] pt = new StiPoint[len_pt];
        pt[0] = points[0];
        pt[1] = this.calculateCurveBezierEndPoints(points[0], points[1], tension *= 0.3f);
        for (int index = 0; index < count - 2; ++index) {
            StiPoint[] temp = this.calculateCurveBezier(points, index, tension);
            pt[3 * index + 2] = temp[0];
            pt[3 * index + 3] = points[index + 1];
            pt[3 * index + 4] = temp[1];
        }
        pt[len_pt - 2] = this.calculateCurveBezierEndPoints(points[count - 1], points[count - 2], tension);
        pt[len_pt - 1] = points[count - 1];
        return pt;
    }

    private StiPoint[] calculateCurveBezier(StiPoint[] points, int index, float tension) {
        double xDiff = points[index + 2].x - points[index + 0].x;
        double yDiff = points[index + 2].y - points[index + 0].y;
        return new StiPoint[]{new StiPoint(points[index + 1].x - (double)tension * xDiff, points[index + 1].y - (double)tension * yDiff), new StiPoint(points[index + 1].x + (double)tension * xDiff, points[index + 1].y + (double)tension * yDiff)};
    }

    private StiPoint calculateCurveBezierEndPoints(StiPoint end, StiPoint adj, float tension) {
        return new StiPoint((double)tension * (adj.x - end.x) + end.x, (double)tension * (adj.y - end.y) + end.y);
    }

    public void drawSpline(StiPoint[] points, float tension, Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        StiPoint[] pts = this.convertSplineToCubicBezier(points, tension);
        int nCurves = (pts.length - 1) / 3;
        StringBuilder stSpline = new StringBuilder();
        stSpline.append(this.getPointString(pts[0]) + this.getBezierString(pts[1], pts[2], pts[3]));
        for (int index = 1; index < nCurves; ++index) {
            stSpline.append(this.getBezierString(pts[index * 3 + 1], pts[index * 3 + 2], pts[index * 3 + 3]));
        }
        if (this.makePath) {
            this.path.append(stSpline.toString() + "\r\n");
        } else {
            this.outputLineString(stSpline.toString() + "S", pen);
        }
        this.lastPoint = pts[pts.length - 1];
    }

    public String getBezierString(StiPoint p1, StiPoint p2, StiPoint p3) {
        this.calculateMinMax(p1);
        this.calculateMinMax(p2);
        this.calculateMinMax(p3);
        return String.format("%s %s %s %s %s %s c ", this.convertToString(p1.x), this.convertToString(p1.y), this.convertToString(p2.x), this.convertToString(p2.y), this.convertToString(p3.x), this.convertToString(p3.y));
    }

    @Override
    public void drawPolyline(StiPoint[] points, Object pen) throws IOException {
        this.drawPolyline(points, pen, false, false);
    }

    @Override
    public void drawPolygon(StiPoint[] points, StiPen pen) throws Exception {
        if (this.makePath) {
            throw new Exception();
        }
        this.drawPolyline(points, pen, true, false);
    }

    public void drawPolyline(StiPoint[] points, Object pen, boolean close, boolean drawTo) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stPolyline = this.getPolylineString(points, close, drawTo);
        if (this.makePath) {
            this.path.append(stPolyline);
        } else {
            this.outputLineString(stPolyline + "S", pen);
        }
        this.lastPoint = points[points.length - 1];
    }

    @Override
    public void drawPolylineTo(StiPoint[] points, StiPen pen) throws IOException {
        this.drawPolyline(points, pen, false, true);
    }

    @Override
    public void fillPolygon(StiPoint[] points, Object brush) throws Exception {
        for (StiPoint pt : points) {
            this.calculateMinMax(pt);
        }
        StiRectangle rect = new StiRectangle(this.xmin.doubleValue(), this.ymin.doubleValue(), this.xmax - this.xmin, this.ymax - this.ymin);
        StiRefObject isTransparent = new StiRefObject((Object)false);
        boolean needRestore = this.setBrush(brush, rect, (StiRefObject<Boolean>)isTransparent, true);
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (brush != null && !((Boolean)isTransparent.argvalue).booleanValue()) {
            String stPolygon = this.getPolylineString(points, true, false);
            this.pageStream.writeLine(stPolygon + "f");
        }
        if (needRestore) {
            this.pageStream.writeLine("Q");
        }
    }

    @Override
    public void drawBezier(StiPoint p1, StiPoint p2, StiPoint p3, StiPoint p4, Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stBezier = this.getPointString(p1) + this.getBezierString(p2, p3, p4);
        if (this.makePath) {
            this.path.append(stBezier + "\r\n");
        } else {
            this.outputLineString(stBezier + "S", pen);
        }
        this.lastPoint = p4;
    }

    public void fillPolygons(List<List<StiPoint>> points, Object brush) throws IOException {
        for (List<StiPoint> list : points) {
            for (StiPoint pt : list) {
                this.calculateMinMax(pt);
            }
        }
        StiRectangle rect = new StiRectangle(this.xmin.doubleValue(), this.ymin.doubleValue(), this.xmax - this.xmin, this.ymax - this.ymin);
        StiRefObject isTransparent = new StiRefObject((Object)false);
        boolean needRestore = this.setBrush(brush, rect, (StiRefObject<Boolean>)isTransparent, true);
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            return;
        }
        if (brush != null && !((Boolean)isTransparent.argvalue).booleanValue()) {
            for (List<StiPoint> list : points) {
                String stPolygon = this.getPolylineString(list.toArray(new StiPoint[0]), true, false);
                this.pageStream.writeLine(stPolygon + "f");
            }
        }
        if (needRestore) {
            this.pageStream.writeLine("Q");
        }
    }

    @Override
    public void drawBezierTo(StiPoint p2, StiPoint p3, StiPoint p4, Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        String stBezier = this.getBezierString(p2, p3, p4);
        if (this.makePath) {
            this.path.append(stBezier + "\r\n");
        } else {
            this.outputLineString(stBezier + "S", pen);
        }
        this.lastPoint = p4;
    }

    @Override
    public void drawArc(StiRectangle rect, float startAngle, float sweepAngle) throws IOException {
        if (this.assembleData) {
            return;
        }
        StiPoint[] pts = this.convertArcToBezierPoints(rect, startAngle, sweepAngle);
        int nCurves = (pts.length - 1) / 3;
        this.drawBezier(pts[0], pts[1], pts[2], pts[3], null);
        for (int index = 1; index < nCurves; ++index) {
            this.drawBezierTo(pts[index * 3 + 1], pts[index * 3 + 2], pts[index * 3 + 3], null);
        }
    }

    public void drawPie(StiRectangle rect, float startAngle, float sweepAngle) throws IOException {
        if (this.assembleData) {
            return;
        }
        StiPoint[] pts = this.convertArcToBezierPoints(rect, startAngle, sweepAngle);
        int nCurves = (pts.length - 1) / 3;
        double cx = rect.x + rect.width / 2.0;
        double cy = rect.y + rect.height / 2.0;
        this.drawBezier(pts[0], pts[1], pts[2], pts[3], null);
        for (int index = 1; index < nCurves; ++index) {
            this.drawBezierTo(pts[index * 3 + 1], pts[index * 3 + 2], pts[index * 3 + 3], null);
        }
        this.drawLineTo(new StiPoint(cx, cy), null);
        this.drawLineTo(pts[0], null);
    }

    private StiPoint[] convertArcToBezierPoints(StiRectangle rect, float startAngle, float sweepAngle) {
        double cx = rect.x + rect.width / 2.0;
        double cy = rect.y + rect.height / 2.0;
        double rx = rect.width / 2.0;
        double ry = rect.height / 2.0;
        startAngle *= (float)Math.PI / 180;
        int nCurves = (int)Math.ceil((double)Math.abs(sweepAngle *= (float)Math.PI / 180) / 1.5707963267948966);
        StiPoint[] pts = new StiPoint[3 * nCurves + 1];
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new StiPoint();
        }
        float aSweep = sweepAngle / (float)nCurves;
        double y0 = Math.sin(aSweep / 2.0f);
        double x0 = Math.cos(aSweep / 2.0f);
        double tx = (1.0 - x0) * 4.0 / 3.0;
        double ty = y0 - tx * x0 / (y0 + 1.0E-4);
        double[] px = new double[4];
        double[] py = new double[4];
        px[0] = x0;
        py[0] = -y0;
        px[1] = x0 + tx;
        py[1] = -ty;
        px[2] = x0 + tx;
        py[2] = ty;
        px[3] = x0;
        py[3] = y0;
        double sn = Math.sin(startAngle + aSweep / 2.0f);
        double cs = Math.cos(startAngle + aSweep / 2.0f);
        pts[0].x = (float)(cx + rx * (px[0] * cs - py[0] * sn));
        pts[0].y = (float)(cy + ry * (px[0] * sn + py[0] * cs));
        for (int iCurve = 0; iCurve < nCurves; ++iCurve) {
            float aStart = startAngle + aSweep * (float)iCurve;
            sn = Math.sin(aStart + aSweep / 2.0f);
            cs = Math.cos(aStart + aSweep / 2.0f);
            for (int index = 1; index <= 3; ++index) {
                pts[index + iCurve * 3].x = (float)(cx + rx * (px[index] * cs - py[index] * sn));
                pts[index + iCurve * 3].y = (float)(cy + ry * (px[index] * sn + py[index] * cs));
            }
        }
        return pts;
    }

    public void drawEllipse(StiRectangle rect, Object pen) throws IOException {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            return;
        }
        this.outputLineString(this.getEllipseString(rect) + "S", pen);
    }

    @Override
    public void fillEllipse(StiRectangle rect, Object brush) throws Exception {
        StiRefObject isTransparent = new StiRefObject((Object)false);
        boolean needRestore = this.setBrush(brush, rect, (StiRefObject<Boolean>)isTransparent, true);
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
        if (brush != null && !((Boolean)isTransparent.argvalue).booleanValue()) {
            this.pageStream.writeLine(this.getEllipseString(rect) + "f");
        }
        if (needRestore) {
            this.pageStream.writeLine("Q");
        }
    }

    @Override
    public void setPixel(StiPoint point, StiColor color) {
        if (this.assembleData) {
            return;
        }
    }

    public boolean setBrush(Object brush, StiRectangle rect, StiRefObject<Boolean> isTransparent, boolean saveState) throws IOException {
        isTransparent.argvalue = false;
        if (this.assembleData) {
            if (brush instanceof StiGradientBrush || brush instanceof StiGlareBrush || brush instanceof StiHatchBrush || brush instanceof StiGlassBrush) {
                this.pdfService.storeShadingData1((StiBrush)brush, this.pageNumber);
                this.pdfService.storeHatchData((StiBrush)brush);
            }
            return false;
        }
        boolean needSaveState = false;
        StiColor tempColor = StiColorEnum.Transparent.color();
        if (brush instanceof StiColor) {
            tempColor = (StiColor)brush;
        }
        if (brush instanceof StiBrush) {
            tempColor = StiBrush.ToColor((StiBrush)((StiBrush)brush));
            if (tempColor.a == 0 && brush instanceof StiHatchBrush) {
                tempColor = ((StiHatchBrush)brush).getBackColor();
            }
        }
        this.pdfService.setNonStrokeColor(tempColor);
        if (tempColor.a == 0) {
            isTransparent.argvalue = true;
        }
        if (brush instanceof StiGradientBrush || brush instanceof StiGlareBrush || brush instanceof StiHatchBrush || brush instanceof StiGlassBrush) {
            AffineTransform mm = this.matrixCache.peek();
            StiPoint p1 = new StiPoint(rect.x, rect.getBottom());
            StiPoint p2 = new StiPoint(rect.getRight(), rect.y);
            Point2D.Double pp1 = new Point2D.Double(p1.x, p1.y);
            Point2D.Double pp2 = new Point2D.Double(p2.x, p2.y);
            mm.transform(pp1, pp1);
            mm.transform(pp2, pp2);
            StiPoint[] points = new StiPoint[]{new StiPoint(((Point2D)pp1).getX(), ((Point2D)pp1).getY()), new StiPoint(((Point2D)pp2).getX(), ((Point2D)pp2).getY())};
            StiRectangle rect2 = new StiRectangle(points[0].x, points[0].y, points[1].x - points[0].x, points[1].y - points[0].y);
            int shadingCurrent = this.pdfService.storeShadingData2(rect2.x, rect2.y, rect2.width, rect2.height, (StiBrush)brush, this.componentAngle);
            if (brush instanceof StiGradientBrush || brush instanceof StiGlareBrush) {
                this.pageStream.writeLine("/Pattern cs /P%s scn", new Object[]{1 + shadingCurrent});
            }
            if (brush instanceof StiHatchBrush) {
                StiHatchBrush hBrush = (StiHatchBrush)brush;
                this.pageStream.writeLine("/Cs1 cs /PH%s scn", new Object[]{this.pdfService.getHatchNumber(hBrush) + 1});
            }
            if (brush instanceof StiGlassBrush) {
                StiGlassBrush glass = (StiGlassBrush)brush;
                if (glass.getDrawHatch()) {
                    this.pageStream.writeLine("/Cs1 cs /PH%s scn", new Object[]{this.pdfService.getHatchNumber((StiHatchBrush)glass.getTopBrush()) + 1});
                } else {
                    this.pdfService.setNonStrokeColor(glass.getTopColor());
                }
                if (glass.getDrawHatch()) {
                    this.pageStream.writeLine("/Cs1 cs /PH%s scn", new Object[]{this.pdfService.getHatchNumber((StiHatchBrush)glass.getBottomBrush()) + 1});
                } else {
                    this.pdfService.setNonStrokeColor(glass.getBottomColor());
                }
            }
            needSaveState = true;
        }
        boolean bl = needSaveState = needSaveState && saveState;
        if (needSaveState) {
            this.pageStream.writeLine("q");
        }
        return needSaveState;
    }

    @Override
    public void drawImage(StiImage img, StiRectangle rect) throws IOException {
        StiImage image = new StiImage();
        image.setClientRectangle(rect.clone());
        image.setImage(img);
        image.setPage(img.getPage());
        image.setSmoothing(true);
        image.setStretch(true);
        if (this.assembleData) {
            this.pdfService.storeImageDataForGeom(image);
            return;
        }
        StiPdfData pp = new StiPdfData();
        pp.Component = image;
        pp.Width = rect.width;
        pp.Height = rect.height;
        this.pageStream.writeLine("q");
        this.pdfService.pushColorToStack();
        this.pageStream.writeLine("1 0 0 1 %s %s cm", new Object[]{this.convertToString(rect.x), this.convertToString(rect.y + rect.height)});
        this.pageStream.writeLine("1 0 0 -1 0 0 cm");
        this.pdfService.renderImage(pp, 1.0f, true);
        this.pageStream.writeLine("Q");
        this.pdfService.popColorFromStack();
    }

    @Override
    public void drawText(StiPoint basePoint, String text, int[] charsOffset, StiFont font, StiColor textColor, double angle, EmfTextAlignmentMode textAlign) throws Exception {
        if (this.assembleData) {
            return;
        }
        if (this.makePath) {
            throw new Exception();
        }
    }

    @Override
    public void drawString(String st, StiFont font, StiBrush brush, StiRectangle rect, StiTextHorAlignment horAlignment, StiVertAlignment vertAlignment) throws IOException {
        if (this.assembleData) {
            if (font != null) {
                int n = this.pdfService.pdfFont.getFontNumber(font);
            }
            StringBuilder sb = new StringBuilder(st);
            this.pdfService.pdfFont.storeUnicodeSymbolsInMap(sb);
            return;
        }
        StiText txt = new StiText();
        txt.setClientRectangle(rect.clone());
        txt.setText(st);
        txt.setFont(font);
        txt.setTextBrush(brush);
        txt.setHorAlignment(horAlignment);
        txt.setVertAlignment(vertAlignment);
        StiPdfData pp = new StiPdfData();
        pp.Component = txt;
        pp.Width = rect.width * 0.72;
        pp.Height = rect.height * 0.72;
        this.pageStream.writeLine("q");
        this.pdfService.pushColorToStack();
        this.pageStream.writeLine("1 0 0 1 %s %s cm", new Object[]{this.convertToString(rect.x), this.convertToString(rect.y + rect.height)});
        this.pageStream.writeLine("1 0 0 -1 0 0 cm");
        this.pageStream.writeLine("1.39 0 0 1.39 0 0 cm");
        this.pdfService.renderTextFont(pp);
        this.pdfService.renderText(pp);
        this.pageStream.writeLine("Q");
        this.pdfService.popColorFromStack();
    }

    @Override
    public void saveState() throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine("q");
        this.pdfService.pushColorToStack();
        if (this.matrixCache.size() > 0) {
            this.matrixCache.push((AffineTransform)this.matrixCache.peek().clone());
        }
    }

    @Override
    public void restoreState() throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine("Q");
        this.pdfService.popColorFromStack();
        if (this.matrixCache.size() > 0) {
            this.matrixCache.pop();
        }
    }

    @Override
    public void translateTransform(double x, double y) throws IOException {
        if (this.assembleData) {
            return;
        }
        this.pageStream.writeLine("1 0 0 1 %s %s cm", new Object[]{this.convertToString(x), this.convertToString(y)});
        if (this.matrixCache.size() > 0) {
            this.matrixCache.peek().translate(x, y);
        }
    }

    @Override
    public void rotateTransform(double angle) throws IOException {
        if (this.assembleData) {
            return;
        }
        double AngleInRadians = angle * Math.PI / 180.0;
        this.pageStream.writeLine("%s %s %s %s 0 0 cm", new Object[]{this.convertToString(Math.cos(AngleInRadians)), this.convertToString(Math.sin(AngleInRadians)), this.convertToString(-Math.sin(AngleInRadians)), this.convertToString(Math.cos(AngleInRadians))});
        if (this.matrixCache.size() > 0) {
            this.matrixCache.peek().rotate(AngleInRadians);
        }
    }

    @Override
    public StiSize measureString(String st, StiFont font) {
        return new StiSize();
    }
}

